
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwmp3_Source
#define SOM_Module_cwmp3_Source
#endif
#define CWMP3_Class_Source
#define M_CWMP3_Class_Source


#define INCL_PM
#define INCL_DOS
#define INCL_DOSERRORS

#include "os2.h"
#include <stdio.h>
#include "cwmp3.ih"
#include <wpdisk.h>

extern char classDLLPath[CCHMAXPATH];

int iGenreLast=147;
char *genreList[]={
	"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk",
	"Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies",
	"Other", "Pop", "R&B", "Rap", "Reggae", "Rock",
	"Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks",
	"Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk",
	"Fusion", "Trance", "Classical", "Instrumental", "Acid", "House",
	"Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass",
	"Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock",
	"Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk",
	"Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta",
	"Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret",
	"New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi",
	"Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical",
	"Rock & Roll", "Hard Rock", "Folk", "Folk/Rock", "National Folk", "Swing",
	"Fast-Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde",
	"Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band",
	"Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson",
	"Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus",
	"Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba",
	"Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet",
	"Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall",
	"Goa", "Drum & Bass", "Club House", "Hardcore", "Terror",
	"Indie", "BritPop", "NegerPunk", "Polsk Punk", "Beat",
	"Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary C",
	"Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop",
	"SynthPop",
};

HMODULE queryModuleHandle(void);
PSZ queryModuleName(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
void _removeTrailingSpaces(char * chrString);
BOOL cwObjectIsOnCD(WPObject * somSelf);
ULONG cwQueryOSRelease(void);
BOOL cwMoveNotebookButtonsWarp4(HWND hwndDlg, USHORT usID, USHORT usDelta);

PSZ _queryMp3HelpLibraryName(void)
{
  static char helpLibraryName[CCHMAXPATH];
  BOOL bDone=FALSE;

  if(!bDone) {
    if(queryModuleHandle()) {
      char  *ptr;
      strncpy(helpLibraryName, classDLLPath, sizeof(helpLibraryName)-1);
      if((ptr=strrchr(helpLibraryName, '\\'))!=NULLHANDLE) {
        *(++ptr)=0;
        if(strlen(helpLibraryName)+strlen(MP3FILE_HELP_LIBRARY)<sizeof(helpLibraryName)) {
          strcat(helpLibraryName, MP3FILE_HELP_LIBRARY );
          bDone=TRUE;
          return helpLibraryName;
        }
      }
    }
    return NULLHANDLE;
  }

  return helpLibraryName;
}

void _fillEntryfieldsWithCurrentId3( CWMP3 *cwMp3, HWND hwnd)
{
  ID3TAG id3Tag;
  char fName[31];

  if(_cwmmQueryId3Tag(cwMp3, &id3Tag))
    {
      fName[0]=0;
      strncat(fName,id3Tag.id3Name,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3NAME),fName);
      
      fName[0]=0;
      strncat(fName,id3Tag.id3Artist,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST),fName);

      fName[0]=0;
      strncat(fName,id3Tag.id3Album,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ALBUM),fName);

      fName[0]=0;
      strncat(fName,id3Tag.id3Year,4);
      fName[4]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3YEAR),fName);

      fName[0]=0;
      strncat(fName,id3Tag.id3Comment,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT),fName);

      /* Genre */
      if(id3Tag.id3Genre[0]>iGenreLast) {
        fName[0]=0;
        strncat(fName,"",30);
        fName[30]=0;
        _removeTrailingSpaces(fName);
        WinSetWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE), fName);
      }
      else {
        WinSetWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE),genreList[id3Tag.id3Genre[0]]);
      }
    }
}

MRESULT EXPENTRY id3TagDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWMP3 *cwMp3;

  switch(msg) {
  case WM_INITDLG :
    cwMp3=(CWMP3*)PVOIDFROMMP(mp2);
    WinSetWindowULong(WinWindowFromID(hwnd,IDEF_ID3NAME),
                      QWL_USER,(ULONG)cwMp3);//Save object ptr.
    if(somIsObj(cwMp3)) {
      //      do {
      for(;;) {
        ULONG rc;
        int a;
        HWND hwndTemp;

        /* Move default buttons on Warp 4 */
        cwMoveNotebookButtonsWarp4(hwnd, IDPB_ID3HELP, 15);
        
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3NAME),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ARTIST),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ALBUM),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3COMMENT),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3YEAR),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)4),0);
        /* Fill drop downlist */
        hwndTemp=WinWindowFromID(hwnd, IDDD_ID3GENRE);
        for(a=0;a<=iGenreLast;a++)
          WinSendMsg(hwndTemp, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(genreList[a]));

        /* Get the ID3 tags from the file and insert them into the entry fields */
        _fillEntryfieldsWithCurrentId3(cwMp3, hwnd);
        break;
      }
      //while (FALSE);
    }
    WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  case WM_COMMAND:    
    cwMp3=(CWMP3*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_ID3NAME),QWL_USER);
    if(somIsObj(cwMp3)) {
      ID3TAG id3Tag;
      char fName[31];

      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CANCEL:
          /* Get the ID3 tags from the file and insert them into the entry fields */
          _fillEntryfieldsWithCurrentId3(cwMp3, hwnd);
          break;
        case IDPB_ID3SAVE:
          {
            ULONG ulYear;
            int a;
            
            memset(&id3Tag,0,sizeof(id3Tag));
            memcpy(id3Tag.id3Tag,"TAG",sizeof(id3Tag.id3Tag));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3NAME), 31, fName);
            memcpy(id3Tag.id3Name, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST), 31, fName);
            memcpy(id3Tag.id3Artist, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ALBUM), 31, fName);
            memcpy(id3Tag.id3Album, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT), 31, fName);
            memcpy(id3Tag.id3Comment, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3YEAR), 5, fName);
            memcpy(id3Tag.id3Year, fName,strlen(fName));

            /* Find genre */
            WinQueryWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE), 31, fName);
            for(a=0;a<=iGenreLast;a++)
              if(!stricmp(fName, genreList[a]))
                break;
            if(a>iGenreLast)
              id3Tag.id3Genre[0]=0xFF;/* No Genre inserted */
            else
              id3Tag.id3Genre[0]=a;
            _cwmmSetId3Tag(cwMp3, &id3Tag);
          }
          break;
        default:
          break;
        }
    }
    return (MRESULT) TRUE;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


SOM_Scope ULONG  SOMLINK cwmp3_cwmmAddId3TagPage(CWMP3 *somSelf, 
                                                 HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  /*    CWMP3Data *somThis = CWMP3GetData(somSelf);*/
    CWMP3MethodDebug("CWMP3","cwmp3_cwmmAddId3TagPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = id3TagDlgProc;
  //The resource DLL
  pageinfo.resid = queryModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_ID3TAGS;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  pageinfo.idDefaultHelpPanel = MP3FILE_SETTINGS_PANEL;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = _queryMp3HelpLibraryName();
  //We have a major tab so we need a name
  /* pageName: "ISO filesystem" */
  getMessage(pageName, ID_ID3TAGSPAGENAME, sizeof(pageName),  queryModuleHandle(), hwndNotebook);
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook

  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);

}

#if 0
SOM_Scope ULONG  SOMLINK cwmp3_wpQueryDetailsData(CWMP3 *somSelf, 
                                                  PVOID* ppDetailsData, 
                                                  PULONG pcp)
{
  BOOL rcParent;
  PMP3DETAILS pMp3Details;

    CWMP3Data *somThis = CWMP3GetData(somSelf);
    CWMP3MethodDebug("CWMP3","cwmp3_wpQueryDetailsData");

    rcParent= (CWMP3_parent_CWAudio_wpQueryDetailsData(somSelf, 
                                                    ppDetailsData, 
                                                    pcp));

  /* The WPS asks for data to be displayed */
  if(ppDetailsData)
    {
      /* Fill the structure with the info to be displayed */      
      pMp3Details=(PMP3DETAILS)*ppDetailsData;  
      pMp3Details->pszTrackName=_id3Name;
      pMp3Details->pszArtist=_id3Artist;
      pMp3Details->pszAlbum=_id3Album;
      pMp3Details->pszYear=_id3Year;
      pMp3Details->pszComment=_id3Comment;
      pMp3Details->pszGenre=_id3Genre;
      *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pMp3Details);  
    }
  else
    {
      /* Buffer size is queried */
      if(pcp)
        *pcp+=sizeof(*pMp3Details);
    }

  return TRUE;

}
#endif


static void convertID3CodePage(ID3TAG *id3Tag, ULONG ulFromCp, ULONG ulToCp)
{

  //  if(ulCodePage==0 || ulIsoCodePage==0)
  if(ulFromCp==0 || ulToCp==0)
    return;
  else {
    char fName[32];
    char fTransName[32];
    ID3TAG  id3Temp;

    HAB hab=WinQueryAnchorBlock(HWND_DESKTOP);

    id3Temp=*id3Tag;
    memset(&id3Temp,0,sizeof(id3Temp));
    memcpy(id3Temp.id3Tag,"TAG",sizeof(id3Temp.id3Tag));

    strncpy(fName, id3Tag->id3Name,30);
    fName[30]=0;/* The ID3 spec allows 30 chars. */
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Name, fTransName, 30);
    
    //    memset(fname,0,sizeof(fname));
    strncpy(fName,id3Tag->id3Artist,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Artist, fTransName, 30);    
    
    strncpy(fName,id3Tag->id3Album,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Album, fTransName, 30);    
    
    strncpy(fName,id3Tag->id3Year,4);
    fName[4]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Year, fTransName, 4);    


    if(id3Tag->id3Comment[28]==0 &&
       id3Tag->id3Comment[29]!=0 ) {
      strncpy(fName,id3Tag->id3Comment,28); /* Keep Track information of ID3 V1.1 */
      fName[28]==0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[28]=0;
      strncpy(id3Temp.id3Comment, fTransName,strlen(fTransName));
      id3Temp.id3Comment[28]=0;
      id3Temp.id3Comment[29]=id3Tag->id3Comment[29];
    }
    else {
      strncpy(fName,id3Tag->id3Comment,30);
      fName[30]==0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[30]=0;
      strncpy(id3Temp.id3Comment, fTransName,strlen(fTransName));
    }

#if 0
    fName[0]=0;
    strncat(fName, id3Tag->id3Name,30);
    fName[30]=0;/* The ID3 spec allows 30 chars. */
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Name, fTransName, 30);
    
    //    memset(fname,0,sizeof(fname));
    fName[0]=0;
    strncat(fName,id3Tag->id3Artist,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Artist, fTransName, 30);    
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Album,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Album, fTransName, 30);    
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Year,4);
    fName[4]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Year, fTransName, 4);    


    if(id3Tag->id3Comment[28]==0 &&
       id3Tag->id3Comment[29]!=0 ) {
      strncpy(fName,id3Tag->id3Comment,28); /* Keep Track information of ID3 V1.1 */
      fName[28]==0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[28]=0;
    }
    else {
      strncpy(fName,id3Tag->id3Comment,30);
      fName[30]==0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[30]=0;
    }

#if 0
    fName[0]=0;
    strncat(fName,id3Tag->id3Comment,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
#endif
    memcpy(id3Temp.id3Comment, fTransName,strlen(fTransName));
#endif

    id3Temp.id3Genre[0]=id3Tag->id3Genre[0];

    *id3Tag=id3Temp;
  }

}

/*
 * The prototype for cwmp3_cwmmQueryId3Tag was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmp3_cwmmQueryId3Tag(CWMP3 *somSelf, 
                                              ID3TAG* id3Tag)
{
  FILE *file;
  ULONG ulSize;
  char fName[CCHMAXPATH];
  M_CWMP3* m_cwMP3;
  M_CWMP3Data *m_cwMP3Data;
  
  /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
  CWMP3MethodDebug("CWMP3","cwmp3_cwmmQueryId3Tag");
  
  /* Get ID3 tag */
  ulSize=sizeof(fName);
  if(!_wpQueryRealName(somSelf, fName, &ulSize, TRUE))
    return FALSE;
  
  if((file=fopen(fName, "rb"))==NULLHANDLE)
    return FALSE;
  
  if(fseek(file, -128, SEEK_END)){
    fclose(file);
    return FALSE;
  }
  if(128!=fread(id3Tag, 1, 128, file)){
    fclose(file);
    return FALSE;
  }
  fclose(file);
  
  if(memicmp(id3Tag->id3Tag,"TAG",3))
    return FALSE;/* No ID3 tag */

  /* Convert the info to ISO 8859-1. Somewhere I've seen info the ID3 tag uses this charset.
     Can't find this reference anymore :-(. Because the windows CP is nearly identical
     we should convert the data anyway to see the right info if put into the tag on W*n systems.
     It's a W*n world out there so it's likely this CP was used. The usual W*ndoze user does not
     care about details but just clicks 'OK'. Do I hear I LOVE YOU? <eg> */
  m_cwMP3=_CWMP3;
  if(!somIsObj(m_cwMP3))
    return TRUE;

  m_cwMP3Data  = M_CWMP3GetData(m_cwMP3);
  //  convertID3CodePage(id3Tag, ulIsoCodePage, ulCodePage);
  convertID3CodePage(id3Tag, m_cwMP3Data->ulIsoCodePage, m_cwMP3Data->ulCodePage);
  return TRUE;
}


SOM_Scope BOOL  SOMLINK cwmp3_cwmmSetId3Tag(CWMP3 *somSelf, ID3TAG* id3Tag)
{
  ID3TAG id3TagQuery;
  FILE *file;
  ULONG ulSize;
  char fName[CCHMAXPATH];
  BOOL   bHaveTag=FALSE;
  HFILE hFile;
  ULONG ulAction;
  ULONG rc;
  M_CWMP3* m_cwMP3;
  M_CWMP3Data *m_cwMP3Data;

    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_cwmmSetId3Tag");

    /* Needed to access class instance variables */
    m_cwMP3=_CWMP3;
    if(!somIsObj(m_cwMP3))
      return FALSE;
    m_cwMP3Data  = M_CWMP3GetData(m_cwMP3);

#if 0 
    /* Check if there's already a Tag */
    if(!_cwmmQueryId3Tag(somSelf, &id3TagQuery))
      bHaveTag=FALSE;
    else {
      bFileHasTag=TRUE;
      if(!memicmp(id3TagQuery.id3Tag,"TAG",3))
        bHaveTag=TRUE;
    }
#endif

    /* Check if there's already a Tag */
    if(_cwmmQueryId3Tag(somSelf, &id3TagQuery))
      {
        //        bFileHasTag=TRUE;
        if(!memicmp(id3TagQuery.id3Tag,"TAG",3))
          bHaveTag=TRUE; /* Make sure we have valid information to write. If not the old Tag is kept. */
      }

    /* Open the MP3 */
    ulSize=sizeof(fName);
    _wpQueryRealName(somSelf, fName, &ulSize, TRUE);
    if((rc=DosOpen(fName, &hFile, &ulAction, 0, 0, OPEN_ACTION_FAIL_IF_NEW|OPEN_ACTION_OPEN_IF_EXISTS,
                   OPEN_FLAGS_FAIL_ON_ERROR|OPEN_SHARE_DENYWRITE|OPEN_ACCESS_WRITEONLY,NULL))!=NULLHANDLE) {
      return FALSE;
    }

    if(bHaveTag) {
      /* There's a Tag so move fileptr to the beginning of it */
      if(DosSetFilePtr(hFile, -128, FILE_END, &ulSize)){
        DosClose(hFile);
        return FALSE;
      }
    }
    else
      {
        /* No Tag yet. Move fileptr to the end */
        if(DosSetFilePtr(hFile, 0, FILE_END, &ulSize)){
          DosClose(hFile);
          return FALSE;
        }
      }

    /* Convert the data from current codepage to ISO 8859-1 which is used for ID3 */
    //    convertID3CodePage(id3Tag, ulCodePage, ulIsoCodePage);
    convertID3CodePage(id3Tag, m_cwMP3Data->ulCodePage, m_cwMP3Data->ulIsoCodePage);

    /* Save comment field */
    fName[0]=id3Tag->id3Comment[28];
    fName[1]=id3Tag->id3Comment[29];

    /* Write Tag to the file */
    if(bHaveTag) {
      /* If there's an old tag, keep the track info of ID3 V1.1 */
      if(id3TagQuery.id3Comment[28]==0 &&
         id3TagQuery.id3Comment[29]!=0) {
        /* Track number is the last byte of the comment field. */
        id3Tag->id3Comment[28]=0;/* Terminate comment */
        id3Tag->id3Comment[29]=id3TagQuery.id3Comment[29];/* Old track number */
      }
    }
    if(DosWrite(hFile,id3Tag, 128, &ulSize)){
      DosClose(hFile);
      /* Convert back */
      convertID3CodePage(id3Tag, m_cwMP3Data->ulIsoCodePage, m_cwMP3Data->ulCodePage);
      //      convertID3CodePage(id3Tag, ulIsoCodePage, ulCodePage);
      return FALSE;
    }
    DosClose(hFile);

    id3Tag->id3Comment[28]=fName[0];
    id3Tag->id3Comment[29]=fName[1];

    /* Convert back */
    //    convertID3CodePage(id3Tag, ulIsoCodePage, ulCodePage);
    convertID3CodePage(id3Tag, m_cwMP3Data->ulIsoCodePage, m_cwMP3Data->ulCodePage);

    /* Set new instance data in CWAudio */
    fName[0]=0;
    strncat(fName,id3Tag->id3Name,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_NAME);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Artist,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ARTIST);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Album,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ALBUM);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Year,4);
    fName[4]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_YEAR);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Comment,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_COMMENT);
    
    //        sprintf(fName,"%d %s",id3Tag.id3Genre[0],genre_list[id3Tag.id3Genre[0]]);
    //  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, fName, "Genre",1234, MB_MOVEABLE|MB_OK);
    if(id3Tag->id3Genre[0]>iGenreLast) {
      fName[0]=0;
      strncat(fName,"",30);
      fName[30]=0;
      _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_GENRE);
    }
    else {
      _cwmmSetTrackInfo(somSelf, genreList[id3Tag->id3Genre[0]], 0, IDINFO_GENRE);
    }

    return TRUE;
}

/*
 *    cwmmAddWaveInformationPage : override;
 */

/*
 *    wpAddSettingsPages        : override;
 */

SOM_Scope BOOL  SOMLINK cwmp3_wpRestoreState(CWMP3 *somSelf, 
                                             ULONG ulReserved)
{
  BOOL bRc; 
  ID3TAG id3Tag;
  char fName[CCHMAXPATH];

  /*    CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_wpRestoreState");


    bRc= (CWMP3_parent_CWAudio_wpRestoreState(somSelf, ulReserved));

#if 0
    if(bGotCD) {
      WPDisk *wpDisk;
      int iDiskNum;

      if((wpDisk=_wpQueryDisk(somSelf))==NULLHANDLE)
        return bRc;
      if((iDiskNum=_wpQueryLogicalDrive(wpDisk))==0)
        return bRc;
      if((iDiskNum>=iFirstCD && iDiskNum<=iFirstCD+iNumCD)) {
        return bRc;
      }
    }
#endif

    /* Don't read ID3 tags for files on CD */
    if(cwObjectIsOnCD(somSelf))
      return bRc;

    /* Get ID3 tag */
    if(_cwmmQueryId3Tag(somSelf, &id3Tag))
      {
        fName[0]=0;
        strncat(fName,id3Tag.id3Name,30);
        fName[30]=0;/* The ID3 spec allows 30 chars. */
        _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_NAME);
          
        fName[0]=0;
        strncat(fName,id3Tag.id3Artist,30);
        fName[30]=0;
        _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ARTIST);
          
        fName[0]=0;
        strncat(fName,id3Tag.id3Album,30);
        fName[30]=0;
        _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ALBUM);
          
        fName[0]=0;
        strncat(fName,id3Tag.id3Year,4);
        fName[4]=0;
        _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_YEAR);
          
        fName[0]=0;
        strncat(fName,id3Tag.id3Comment,30);
        fName[30]=0;
        _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_COMMENT);
          
        //        sprintf(fName,"%d %s",id3Tag.id3Genre[0],genre_list[id3Tag.id3Genre[0]]);
        //  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, fName, "Genre",1234, MB_MOVEABLE|MB_OK);
        if(id3Tag.id3Genre[0]>iGenreLast) {
          fName[0]=0;
          strncat(fName,"",30);
          fName[30]=0;/* ID3 encodes genre into one byte. */
          _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_GENRE);
        }
        else {
          _cwmmSetTrackInfo(somSelf, genreList[id3Tag.id3Genre[0]], 0, IDINFO_GENRE);
        }
      }
    /* Get MP3 technical data */
    return bRc;
}

#if 0
SOM_Scope BOOL  SOMLINK cwmp3_wpAddSettingsPages(CWMP3 *somSelf, 
                                                 HWND hwndNotebook)
{
    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_wpAddSettingsPages");

    return (CWMP3_parent_CWAudio_wpAddSettingsPages(somSelf, 
                                                    hwndNotebook)
            /*            && _cwmmAddId3TagPage(somSelf, 
                               hwndNotebook)*/
            );
}
#endif

SOM_Scope BOOL  SOMLINK cwmp3_wpSetup(CWMP3 *somSelf, PSZ pszSetupString)
{
  char buffer[CCHMAXPATH];
  ULONG bufferSize;
  ID3TAG id3Tag;
  int a;

    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_wpSetup");

    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3TRACKNAME, buffer, &bufferSize))
      {
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        //        if(bufferSize<30+1)
        //        buffer[bufferSize-1]=' ';
        memcpy(id3Tag.id3Name, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3ARTIST, buffer, &bufferSize))
      {
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        //   if(bufferSize<30+1)
        //   buffer[bufferSize-1]=' ';
        memcpy(id3Tag.id3Artist, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3ALBUM, buffer, &bufferSize))
      {
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        //       if(bufferSize<30+1)
        //       buffer[bufferSize-1]=' ';

        memcpy(id3Tag.id3Album, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3COMMENT, buffer, &bufferSize))
      {
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag,0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        //  if(bufferSize<30+1)
        //  buffer[bufferSize-1]=' ';
        memcpy(id3Tag.id3Comment, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3YEAR, buffer, &bufferSize))
      {
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        if(bufferSize==4+1) {
          memcpy(id3Tag.id3Year, buffer, 4);
          _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
        }
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3GENRE, buffer, &bufferSize))
      {
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        /* Find genre from string */
        for(a=0;a<=iGenreLast;a++)
          if(!stricmp(buffer, genreList[a]))
            break;
        if(a>iGenreLast)
          id3Tag.id3Genre[0]=0xFF;/* No Genre inserted */
        else
          id3Tag.id3Genre[0]=a;
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
      }

    return (CWMP3_parent_CWAudio_wpSetup(somSelf, pszSetupString));
}


/*
 *cwmmAddTrackNamePage      : override;
 */

SOM_Scope void  SOMLINK cwmp3_wpObjectReady(CWMP3 *somSelf, ULONG ulCode, 
                                            WPObject* refObject)
{
  PSZ psz;
    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_wpObjectReady");

    /* Make sure the type is set in the EA so the Audio player works */
    if((psz=_wpQueryType(somSelf))!=NULLHANDLE)
      _wpSetType(somSelf, psz,NULL);
    _wpSaveDeferred(somSelf);

    CWMP3_parent_CWAudio_wpObjectReady(somSelf, ulCode, refObject);
}


SOM_Scope ULONG  SOMLINK cwmp3_cwmmAddTrackNamePage(CWMP3 *somSelf, 
                                                    HWND hwndNotebook)
{
    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_cwmmAddTrackNamePage");

    
    return _cwmmAddId3TagPage(somSelf,
                              hwndNotebook);
}



SOM_Scope BOOL  SOMLINK cwmp3_wpSaveState(CWMP3 *somSelf)
{
    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    CWMP3MethodDebug("CWMP3","cwmp3_wpSaveState");

    /* Set .TYPE EA so the editor and the player are happy. */
    _wpSetType(somSelf, "MP3,Digital Audio" , NULL);

    return (CWMP3_parent_CWAudio_wpSaveState(somSelf));
}


/*
 * SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryTitle(CWMP3 *somSelf)
 */

/*
 * The prototype for cwmp3M_wpclsQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryTitle(M_CWMP3 *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_MP3TITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"MP3Audio.MP3");

    return chrTitle;
}


SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryInstanceType(M_CWMP3 *somSelf)
{
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsQueryInstanceType");

    return "MP3,Digital Audio";

}

SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryInstanceFilter(M_CWMP3 *somSelf)
{
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsQueryInstanceFilter");

    return "*.MP3";

}


SOM_Scope ULONG  SOMLINK cwmp3M_wpclsQueryIconData(M_CWMP3 *somSelf, 
                                                   PICONINFO pIconInfo)
{
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsQueryIconData");

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = queryModuleHandle();
      pIconInfo->resid   = ID_ICONMP3FILE;
	} /* endif */

	return ( sizeof(ICONINFO) );

}

#if 0
SOM_Scope ULONG  SOMLINK cwmp3M_wpclsQueryDetailsInfo(M_CWMP3 *somSelf, 
                                                      PCLASSFIELDINFO* ppClassFieldInfo, 
                                                      PULONG pSize)
{
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;
  ULONG rc;


    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsQueryDetailsInfo");

    cParentColumns= (M_CWMP3_parent_M_CWAudio_wpclsQueryDetailsInfo(somSelf, 
                                                           ppClassFieldInfo, 
                                                           pSize));
    if(pSize)
      *pSize+=sizeof(MP3DETAILS);
    
    if(ppClassFieldInfo)
      {
        if(*ppClassFieldInfo)
          {
            pCfi=*ppClassFieldInfo;
            for(i=0; i<cParentColumns;i++)
              pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);
            
            pCfi->pNextFieldInfo=cfiMp3FieldInfo;
          }
        else
          *ppClassFieldInfo=cfiMp3FieldInfo;
      }    
    return cParentColumns+NUM_MP3_FIELDS;
}
#endif

ULONG _getISOCp(void)
{
  ULONG ulData;
  ULONG ulNumCp;
  char fName[100];
  /* Get number of codepages */
  if((ulNumCp=WinQueryCpList(WinQueryAnchorBlock(HWND_DESKTOP), 1, &ulData))!=0) {
    ULONG *ulCpList;

    /* Get memory for codepage list */ 
    ulCpList=(ULONG*)malloc(ulNumCp*sizeof(ULONG));
    if(ulCpList) {
      int a;
      /* Get codepage list */
      if((ulNumCp=WinQueryCpList(WinQueryAnchorBlock(HWND_DESKTOP), ulNumCp, ulCpList))!=0) {
        for(a=0;a<ulNumCp;a++)
          {
            if(ulCpList[a]==819) {
              free(ulCpList);
              return (ULONG) 819;/* The IBM ISO 8859-1 CP */
            } 
          }
        /* ISO 8859-1 CP not found. Try to find 1004 (Windows extended) which is a quite good match */
        for(a=0;a<ulNumCp;a++)
          {
            if(ulCpList[a]==1004) {
              free(ulCpList);
              return (ULONG) 1004;/* The IBM ISO 8859-1 CP */
            } 
          }
      }
      free(ulCpList);
    }
  }
  /* No CP found or an error occured */
  return 0;
}

SOM_Scope void  SOMLINK cwmp3M_wpclsInitData(M_CWMP3 *somSelf)
{
  PCLASSFIELDINFO pCfi;
  USHORT i,rc;
  ULONG ulCp[4];
  ULONG ulInfoLen=0;
  //char fName[100];
  M_CWMP3Data *somThis = M_CWMP3GetData(somSelf);
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsInitData");

    M_CWMP3_parent_M_CWAudio_wpclsInitData(somSelf);

    /* Get system codepage */
    if(DosQueryCp(sizeof(ulCp), ulCp,&ulInfoLen)!=NO_ERROR) {
      _ulCodePage=0;/* Indicate some error */
    }
    else 
      _ulCodePage=ulCp[0];

    /* Get ISO codepage */
    _ulIsoCodePage=_getISOCp();


#if 0
    pszMp3ColTitles[0]=chrTrackName;
    pszMp3ColTitles[1]=chrArtist;
    pszMp3ColTitles[2]=chrAlbum;
    pszMp3ColTitles[3]=chrYear;
    pszMp3ColTitles[4]=chrComment;
    pszMp3ColTitles[5]=chrGenre;

  /* Setup the static data for the details view */
  for(i=0,pCfi=cfiMp3FieldInfo;i<NUM_MP3_FIELDS;i++,pCfi++)
    {
      memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));

      pCfi->cb=sizeof(CLASSFIELDINFO);
      pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
      pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
      pCfi->pNextFieldInfo=pCfi+1;
       pCfi->pTitleData=(PVOID)pszMp3ColTitles[i];
      pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;

      switch(i)
        {
        case 0:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszTrackName));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 1:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszArtist));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          //          WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, pszMp3ColTitles[i], pCfi->pTitleData,1234, MB_MOVEABLE|MB_OK);
          break;
        case 2:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszAlbum));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 3: /* CC */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszYear));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 4:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszComment));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 5:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszGenre));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        }/* switch(i) */
    }/* for() */
  cfiMp3FieldInfo[NUM_MP3_FIELDS-1].pNextFieldInfo=NULL;
#endif

}



SOM_Scope BOOL  SOMLINK cwmp3M_wpclsQueryDefaultHelp(M_CWMP3 *somSelf, 
                                                     PULONG pHelpPanelId, 
                                                     PSZ pszHelpLibrary)
{
  PSZ pszHelpLibName;

    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_CWMP3MethodDebug("M_CWMP3","cwmp3M_wpclsQueryDefaultHelp");

    if((pszHelpLibName=_queryMp3HelpLibraryName())!=NULLHANDLE)
      {
        if(pHelpPanelId)
          *pHelpPanelId=MP3FILE_HELP_PANEL;
        if(pszHelpLibrary)
          strncpy(pszHelpLibrary, pszHelpLibName, CCHMAXPATH);
        return TRUE; 
      }

    return (M_CWMP3_parent_M_CWAudio_wpclsQueryDefaultHelp(somSelf, 
                                                           pHelpPanelId, 
                                                           pszHelpLibrary));
}


