
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwastream_Source
#define SOM_Module_cwastream_Source
#endif
#define CWAudioStream_Class_Source
#define M_CWAudioStream_Class_Source

#define INCL_PM
#define INCL_MCIOS2
#include <os2.h>
#include <stdio.h>
#include "os2me.h"
#include "cwastream.ih"
#include "cwaudioinc.h"

HMODULE queryModuleHandle(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);

static BOOL _getUrlFromFile(WPFileSystem * wpFS, char *chrBuf, ULONG ulBufSize)
{
  ULONG ulSize;
  char* pChr;
  FILE* fStream;

  for(;;)
    {
      ulSize=ulBufSize;
      if(!_wpQueryRealName(wpFS, chrBuf, &ulSize, TRUE))
        break;
      
      if((fStream=fopen( chrBuf, "r"))==NULLHANDLE)
        break;
      
      fgets(chrBuf, ulBufSize, fStream);
      fclose(fStream);
      if((pChr=strchr(chrBuf, '\n'))!=NULLHANDLE)
        *pChr=0;

      return TRUE;
    }
  return FALSE;
}

static BOOL _saveUrlToFile(WPFileSystem * wpFS, char *chrUrl)
{
  ULONG ulSize;
  char* pChr;
  FILE* fStream;
  char chrPath[CCHMAXPATH];

  for(;;)
    {
      ulSize=sizeof(chrPath);
      if(!_wpQueryRealName(wpFS, chrPath, &ulSize, TRUE))
        break;
      
      if((fStream=fopen( chrPath, "w"))==NULLHANDLE)
        break;
      
      if(EOF==fputs(chrUrl,  fStream))
        break;
      fclose(fStream);

      return TRUE;
    }
  fclose(fStream);
  return FALSE;
}

/************************************************************/
/*                                                          */
/*                                                          */
/*                                                          */
/************************************************************/
MRESULT EXPENTRY playStreamProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        CWAudio * thisPtr;
        thisPtr=(CWAudio *)PVOIDFROMMP(mp2);/* Get object ptr */
        if(somIsObj(thisPtr)) {
          switch(LONGFROMMP(mp1))
            {
              case ACKEY_START:
                {
                  unsigned char chrCommand[CCHMAXPATH*2];
                  unsigned char chrURL[CCHMAXPATH];
                  char retMsg[20];
                  APIRET rc;
                  char* pChr;
                  FILE* fStream;
                  ULONG ulSize;

                  WinSetWindowULong(hwnd, QWL_USER, (ULONG)thisPtr);

                  _cwmmSetRecordTitles(thisPtr, "Connecting to server...", TRUE);

                  /* Read URL from file */
                  if(!_getUrlFromFile(thisPtr, chrURL, sizeof(chrURL)))
                    {
                      WinPostMsg(hwnd,WM_QUIT,0,0);
                      return MRFALSE;
                    };

                  sprintf(chrCommand,"open ipipe:%s type WAVEAUDIO alias wave%d SHAREABLE wait", chrURL, thisPtr);
                  rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    _cwmmSetRecordTitles(thisPtr, "Can't connect to server!", TRUE);
                    WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 2, 4000);
                    /*                    WinPostMsg(hwnd,WM_QUIT,0,0);*/
                    return MRFALSE;
                  }

                  /* Set time format */
                  sprintf(chrCommand,"SET wave%d TIME FORMAT MILLISECONDS wait", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  sprintf(chrCommand,"play wave%d ", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000);
                  _cwmmSetRecordTitles(thisPtr, "00:00", TRUE);

                  break;
                }
            case ACKEY_STOP:
              {
                /* Stop playing */
                unsigned char chrCommand[CCHMAXPATH];
                char retMsg[20];

                WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,1 );
                
                sprintf(chrCommand,"stop wave%d wait", thisPtr);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                
                sprintf(chrCommand,"close wave%d wait", thisPtr);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                
                WinPostMsg(hwnd,WM_QUIT,0,0);
              }
            default:
              break;
            }
        }/* if(thisPtr) */
        return MRFALSE;
      }
    case WM_TIMER:
      switch(SHORT1FROMMP(mp1))
        {
        case 1:
          {
            CWAudio * thisPtr;
            thisPtr=(CWAudio *)WinQueryWindowULong(hwnd, QWL_USER);
            
            if(somIsObj(thisPtr)) {
              char retMsg[20];
              unsigned char chrCommand[CCHMAXPATH];
              APIRET rc;
              ULONG ulCur;
              
              /* Get current play position */
              sprintf(chrCommand,"STATUS wave%d POSITION WAIT", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                return MRFALSE;
              }
              
              ulCur=atoi(retMsg)/1000;
              sprintf(chrCommand, "%02d:%02d", ulCur/60, ulCur%60);
              
              /* Set new time in icon title */
              _cwmmSetRecordTitles(thisPtr, chrCommand, TRUE);

              sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
              rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                return MRFALSE;
              }
              if(stricmp(retMsg, "playing")) {
                /* Not playing anymore. Try to reconnect */
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_START), MPFROMP(thisPtr));
              }
              return MRFALSE;
            }
          }
        case 2:
          WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd, 2);
          WinPostMsg(hwnd,WM_QUIT,0,0);
          return MRFALSE;
        default:
          break;
        }
      break;
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

MRESULT EXPENTRY streamUrlDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWAudioStream *cwAudioStream;

  switch(msg) {
  case WM_INITDLG :
    cwAudioStream=(CWAudio*)PVOIDFROMMP(mp2);
    WinSetWindowULong(WinWindowFromID(hwnd,IDEF_URL),
                      QWL_USER,(ULONG)cwAudioStream);//Save object ptr.

    if(somIsObj(cwAudioStream)) {
      char chrURL[CCHMAXPATH];
      /* CWAudioStreamData *somThis = CWAudioStreamGetData(cwAudioStream); */

      /* Move default buttons on Warp 4 */
      // cwMoveNotebookButtonsWarp4(hwnd, IDPB_ID3HELP, 15);
      if(_getUrlFromFile(cwAudioStream, chrURL, sizeof(chrURL)))
        {
          WinSetWindowText(WinWindowFromID(hwnd,IDEF_URL),chrURL);
        }
      WinSendMsg(WinWindowFromID(hwnd,IDEF_URL),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)CCHMAXPATH),0);
    }
    WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd),
                       (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      cwAudioStream=(CWAudioStream*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_URL), QWL_USER);
      if(somIsObj(cwAudioStream)) {
        char fName[CCHMAXPATH];

        WinQueryWindowText(WinWindowFromID(hwnd,IDEF_URL), sizeof(fName), fName);
        _saveUrlToFile(cwAudioStream, fName);
      }
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
#if 0
  case WM_COMMAND:
    cwAudio=(CWAudio*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_ID3NAME),QWL_USER);
    if(somIsObj(cwAudio)) {
      char fName[100];

      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CANCEL:
          break;
        default:
          break;
        }
    }
    return (MRESULT) TRUE;
#endif
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}


SOM_Scope ULONG  SOMLINK cwastream_cwmmAddURLPage(CWAudioStream *somSelf, 
                                                  HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    CWAudioStreamMethodDebug("CWAudioStream","cwastream_cwmmAddURLPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = streamUrlDlgProc;
  //The resource DLL
  pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_STREAMURLPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = TRACKNAME_SETTINGS_PANEL;
  //Tell the WPS the help library name
  //pageinfo.pszHelpLibraryName = _queryMp3HelpLibraryName();
  //We have a major tab so we need a name
  getMessage(pageName, IDSTR_STREAMURLPAGENAME, sizeof(pageName),  queryModuleHandle(), hwndNotebook);
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook

  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);
}

SOM_Scope BOOL  SOMLINK cwastream_wpModifyPopupMenu(CWAudioStream *somSelf, 
                                                    HWND hwndMenu, 
                                                    HWND hwndCnr, 
                                                    ULONG iPosition)
{
  BOOL bRC;
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    CWAudioStreamMethodDebug("CWAudioStream","cwastream_wpModifyPopupMenu");

    bRC=(CWAudioStream_parent_CWAudio_wpModifyPopupMenu(somSelf, 
                                                        hwndMenu, 
                                                        hwndCnr, 
                                                        iPosition));
    WinSendMsg(hwndMenu,MM_DELETEITEM,MPFROM2SHORT( ID_MENU_PLAYER, TRUE),
               0L);
    WinSendMsg(hwndMenu,MM_DELETEITEM,MPFROM2SHORT( ID_MENU_EDITOR, TRUE),
               0L);
    WinSendMsg(hwndMenu,MM_DELETEITEM,MPFROM2SHORT( ID_MENU_CONVERT, FALSE),
               0L);

    return bRC;
}

SOM_Scope BOOL  SOMLINK cwastream_wpAddSettingsPages(CWAudioStream *somSelf, 
                                                     HWND hwndNotebook)
{
  BOOL bRc;
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    CWAudioStreamMethodDebug("CWAudioStream","cwastream_wpAddSettingsPages");

    bRc=CWAudioStream_parent_CWAudio_wpAddSettingsPages(somSelf, 
                                                              hwndNotebook);
    _cwmmAddURLPage(somSelf,  hwndNotebook);
    return bRc;
}

SOM_Scope void  SOMLINK cwastream_wpInitData(CWAudioStream *somSelf)
{
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    CWAudioStreamMethodDebug("CWAudioStream","cwastream_wpInitData");

    CWAudioStream_parent_CWAudio_wpInitData(somSelf);
    _cwmmSetObjWindowProc(somSelf, &playStreamProc);
}

SOM_Scope ULONG  SOMLINK cwastream_cwmmAddWaveInformationPage(CWAudioStream *somSelf, 
                                                              HWND hwndNotebook)
{
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    CWAudioStreamMethodDebug("CWAudioStream","cwastream_cwmmAddWaveInformationPage");

    return SETTINGS_PAGE_REMOVED;
}

SOM_Scope ULONG  SOMLINK cwastream_cwmmAddTrackNamePage(CWAudioStream *somSelf, 
                                                        HWND hwndNotebook)
{
    /* CWAudioStreamData *somThis = CWAudioStreamGetData(somSelf); */
    CWAudioStreamMethodDebug("CWAudioStream","cwastream_cwmmAddTrackNamePage");

    return SETTINGS_PAGE_REMOVED;
}

SOM_Scope PSZ  SOMLINK cwastreamM_wpclsQueryInstanceType(M_CWAudioStream *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_CWAudioStreamMethodDebug("M_CWAudioStream","cwastreamM_wpclsQueryInstanceType");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_AUDIOSTREAMTITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Audio-Stream");

    return chrTitle;
}

SOM_Scope BOOL  SOMLINK cwastreamM_wpclsQueryDefaultHelp(M_CWAudioStream *somSelf, 
                                                         PULONG pHelpPanelId, 
                                                         PSZ pszHelpLibrary)
{
    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_CWAudioStreamMethodDebug("M_CWAudioStream","cwastreamM_wpclsQueryDefaultHelp");

    return (M_CWAudioStream_parent_M_CWAudio_wpclsQueryDefaultHelp(somSelf, 
                                                                   pHelpPanelId, 
                                                                   pszHelpLibrary));
}

SOM_Scope PSZ  SOMLINK cwastreamM_wpclsQueryTitle(M_CWAudioStream *somSelf)
{
  static char chrTitle[20]={0};

    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_CWAudioStreamMethodDebug("M_CWAudioStream","cwastreamM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_AUDIOSTREAMTITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Audio-Stream");

    return chrTitle;
}

SOM_Scope ULONG  SOMLINK cwastreamM_wpclsQueryIconData(M_CWAudioStream *somSelf, 
                                                       PICONINFO pIconInfo)
{
    /* M_CWAudioStreamData *somThis = M_CWAudioStreamGetData(somSelf); */
    M_CWAudioStreamMethodDebug("M_CWAudioStream","cwastreamM_wpclsQueryIconData");

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = queryModuleHandle();
      pIconInfo->resid   = ID_ICONAUDIOSTREAM;
	} /* endif */

	return ( sizeof(ICONINFO) );
}

