/*
 * (C) Chris Wohlgemuth 2002-2003
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwaudio_Source
#define SOM_Module_cwaudio_Source
#endif
#define CWAudio_Class_Source
#define M_CWAudio_Class_Source

#define INCL_PM
#define INCL_DOS
#define INCL_WINWORKPLACE
#define INCL_MMIOOS2
#define INCL_DOSDEVIOCTL
#define INCL_MCIOS2
#define  INCL_ERRORS

#include <os2.h>
#include <stdio.h>
#include <string.h>
#include "os2me.h"

#define MRFALSE  1

ULONG thisPtr=1234;
char chrDevice[20];

int closeTrack(void)
{
  char retMsg[20];
  APIRET rc;
  unsigned char chrCommand[CCHMAXPATH*2];

  fprintf(stderr, "Trying to close file...\n");
  sprintf(chrCommand,"close wave%d wait", thisPtr);
  rc=mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
    fprintf(stderr, "  !!! Error while closing file.\n");
    return 1;
  }
  return 0;  
}

int main()
{
  unsigned char chrCommand[CCHMAXPATH*2];
  char name[CCHMAXPATH]="J:\\MMOS2\\timiditymcd_2104\\midi\\impromptu.mid";
  ULONG ulNameSize;
  char retMsg[20];
  APIRET rc;
  int iTime;
  ULONG hwnd=0;

  fprintf(stderr, "Started program...\n");

  strncpy(chrDevice,"SEQUENCER", sizeof(chrDevice));
  
  /* Open audio file */  
  fprintf(stderr, "Trying to open file %s...\n", name);
  sprintf(chrCommand,"open \"%s\"  type %s alias wave%d SHAREABLE wait",name, chrDevice, thisPtr);
  rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
    fprintf(stderr, "   !!! Error while opening %s\n", name);
    return MRFALSE;
  }
  fprintf(stderr, "File opened.\n");

  /* Set time format */
  fprintf(stderr, "Setting time format.\n");
  sprintf(chrCommand,"SET wave%d TIME FORMAT MILLISECONDS wait", thisPtr);
  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
    fprintf(stderr, "   !!! Error while setting time format\n");
    closeTrack();
    return MRFALSE;
  }


  fprintf(stderr, "Getting length of audio track.\n");
  sprintf(chrCommand,"STATUS wave%d LENGTH WAIT", thisPtr);
  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
    fprintf(stderr, "   !!! Error while getting length\n");
    closeTrack();
    return MRFALSE;
  }

  fprintf(stderr, "Starting track.\n");
  sprintf(chrCommand,"play wave%d ", thisPtr);
  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
    fprintf(stderr, "   !!! Error while playing\n");
    closeTrack();
    return MRFALSE;
  }

  DosSleep(5000);
  sprintf(chrCommand,"stop wave%d wait", thisPtr);
  mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);

#if 0  
  /* Set volume */
  sprintf(chrCommand,"SET wave%d AUDIO VOLUME %d wait", thisPtr, globalClassVolume);
  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
              /* Not able to set the volume isn't that bad so don't quit in case of an error. */
#if 0
  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
    return MRFALSE;
  }
#endif
  sprintf(chrCommand,"stop wave%d wait", thisPtr);
  mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
#endif


  closeTrack();

  return 0;
}

