
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwaudio_Source
#define SOM_Module_cwaudio_Source
#endif
#define CWAudio_Class_Source
#define M_CWAudio_Class_Source

#define INCL_PM
//#define INCL_DOSMODULEMGR
#define INCL_DOS
#define INCL_WINWORKPLACE
#define INCL_MMIOOS2
#define INCL_REXXSAA
#define INCL_DOSDEVIOCTL
#define INCL_MCIOS2

#include <os2.h>
#include <stdio.h>
#include <rexxsaa.h>                   /* needed for Rexx */
#include "os2me.h"
#include "cwmmdataf.ih"
#include "cwaudio.ih"
#include "except.h"
#include "cwaudioinc.h"
#include <wpdisk.h>
#include <wpfolder.h>

char classDLLPath[CCHMAXPATH]={0};
char chrHelpLibrary[CCHMAXPATH]={0};

//extern int iFirstCD;
//extern int iNumCD;
// BOOL bGotCD;

extern char *genreList[];
extern int iGenreLast;

HMODULE queryModuleHandle(void);
PSZ queryModuleName(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags);
BOOL cwQueryCDDrives(int *iNumCD, int * iFirstDrive);
ULONG EXPENTRY rxCallCWMMFunc(PSZ name, LONG argc, RXSTRING argv[], PSZ queuename,PRXSTRING retstring);
void HlpSendCommandToObject(char* chrObject, char* command);
PSZ _queryMp3HelpLibraryName(void);
BOOL cwMoveNotebookButtonsWarp4(HWND hwndDlg, USHORT usID, USHORT usDelta);
BOOL cwObjectIsOnCD(WPObject * somSelf);
void HlpWriteToTrapLog(const char* chrFormat, ...);
SOMClass* cwGetSomClass(char* chrClassName);

void _fillEntryfieldsWithCurrentTrackNames( CWAudio *cwAudio, HWND hwnd)
{
  char tempChar[100];
  char *chr=tempChar;

  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_NAME))
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3NAME), chr);
  //WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, chr, tempChar, 123, MB_MOVEABLE);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_ARTIST))
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_ALBUM))
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3ALBUM),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_COMMENT))
    WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_YEAR))
    WinSetWindowText(WinWindowFromID(hwnd,IDEF_ID3YEAR),tempChar);
  if(_cwmmQueryTrackInfo(cwAudio, &chr, sizeof(tempChar), IDINFO_GENRE))
    WinSetWindowText(WinWindowFromID(hwnd,IDDD_ID3GENRE),tempChar);
}

BOOL cwSaveStringToEA(WPFileSystem * wpFSObject,  PSZ pKey, PSZ pValue)
{
  LONG rc;                             /* Ret code                   */
  PVOID       fealist;                 /* fealist buffer             */
  EAOP2       eaop;                    /* eaop structure             */
  PFEA2       pfea;                    /* pfea structure             */
  HFILE       handle;                  /* file handle                */
  ULONG       act;                     /* open action                */
  ULONG ulSize;
  USHORT    usSizeEA;

  char chrFileName[CCHMAXPATH];
  
  if((fealist=_wpAllocMem(wpFSObject, strlen(pKey)+strlen(pValue)+sizeof(FEA2)+0x100 /* Add some space */,
                          &ulSize))==NULLHANDLE)
    return FALSE;

  ulSize=sizeof(chrFileName);
  _wpQueryRealName(wpFSObject, chrFileName,&ulSize,TRUE);
  if ((rc = DosOpen(chrFileName, &handle, &act,
      0L, 0, OPEN_ACTION_OPEN_IF_EXISTS,
      OPEN_ACCESS_READWRITE + OPEN_SHARE_DENYWRITE +
      OPEN_FLAGS_FAIL_ON_ERROR + OPEN_FLAGS_WRITE_THROUGH, NULL))!=NO_ERROR) {
    return FALSE;
  }


  eaop.fpFEA2List = (PFEA2LIST)fealist;/* Set memory for the FEA     */
  eaop.fpGEA2List = NULL;              /* GEA is unused              */
  pfea = &eaop.fpFEA2List->list[0];    /* point to first FEA         */
  pfea->fEA = '\0';                    /* set the flags              */
                                       /* Size of FEA name field     */
  pfea->cbName = (BYTE)strlen(pKey);
                                       /* Size of Value for this one */
  pfea->cbValue = (SHORT)strlen(pValue)+4;
                                       /* Set the name of this FEA   */
  strcpy((PSZ)pfea->szName, pKey);
                                       /* Set the EA value           */
  usSizeEA=0xFFFD;
  memcpy((PSZ)pfea->szName+(pfea->cbName+1), &usSizeEA,
      2);/* It's an ASCII value */
  usSizeEA=strlen(pValue);
  memcpy((PSZ)pfea->szName+(pfea->cbName+3), &usSizeEA,
      sizeof(USHORT));/* It's an ASCII value */

  memcpy((PSZ)pfea->szName+(pfea->cbName+5), pValue,
      usSizeEA);
  pfea->oNextEntryOffset = 0;          /* no next entry              */
  eaop.fpFEA2List->cbList =            /* Set the total size var     */
      sizeof(ULONG) + sizeof(FEA2) + pfea->cbName + pfea->cbValue;

                                       /* set the file info          */
  rc = DosSetFileInfo(handle, 2, (PSZ)&eaop, sizeof(EAOP2));
  DosClose(handle);                    /* Close the File             */
  _wpFreeMem(wpFSObject,fealist);                 /* Free the memory            */
  return TRUE;
}


MRESULT EXPENTRY trackNameDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWAudio *cwAudio;

  switch(msg) {
  case WM_INITDLG :
    cwAudio=(CWAudio*)PVOIDFROMMP(mp2);
    WinSetWindowULong(WinWindowFromID(hwnd,IDEF_ID3NAME),
                      QWL_USER,(ULONG)cwAudio);//Save object ptr.
    if(somIsObj(cwAudio)) {
      ULONG rc;
      int a;
      HWND hwndTemp;
      char name[50];
      CWAudioData *somThis = CWAudioGetData(cwAudio);
      /* Move default buttons on Warp 4 */
      cwMoveNotebookButtonsWarp4(hwnd, IDPB_ID3HELP, 15);

      getMessage(name, IDSTR_TRACKNAME, sizeof(name),  queryModuleHandle(), hwnd);
      WinSetWindowText(WinWindowFromID(hwnd,IDGB_ID3TAGS), name);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3NAME),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Name)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ARTIST),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Artist)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ALBUM),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Album)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3COMMENT),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Comment)-1),0);
      WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3YEAR),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)sizeof(_id3Year)-1),0);
      
      /* Fill drop downlist */
      hwndTemp=WinWindowFromID(hwnd, IDDD_ID3GENRE);
      for(a=0;a<=iGenreLast;a++)
        WinSendMsg(hwndTemp, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(genreList[a]));
      
      _fillEntryfieldsWithCurrentTrackNames( cwAudio, hwnd);
    }
    WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd),
                       (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  case WM_COMMAND:
    cwAudio=(CWAudio*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_ID3NAME),QWL_USER);
    if(somIsObj(cwAudio)) {
      char fName[100];

      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CANCEL:
          _fillEntryfieldsWithCurrentTrackNames( cwAudio, hwnd);
          break;
        case IDPB_ID3SAVE:
          {
            CWAudioData *somThis = CWAudioGetData(cwAudio);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3NAME), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_NAME);          
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_ARTIST);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ALBUM), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_ALBUM);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_COMMENT);
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3YEAR), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_YEAR);
            /* Find genre */
            WinQueryWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE), 100, fName);
            _cwmmSetTrackInfo(cwAudio, fName,  0, IDINFO_GENRE);
          }
          break;
        default:
          break;
        }
    }
    return (MRESULT) TRUE;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/* Remove all trailing spaces from a string. The string MUST be terminated by 0! */
void _removeTrailingSpaces(char * chrString)
{
  char *ptr;

  if((ptr=strrchr(chrString, 0))==NULLHANDLE)
    return;

  if(ptr==chrString)
    return;

  while(ptr>=chrString && (*ptr==0 || *ptr==' '))
    ptr--;

  *(++ptr)=0;
}


MRESULT EXPENTRY waveInfoDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  CWAudio *cwAudio;

  switch(msg) {
  case WM_INITDLG :
    cwAudio=(CWAudio*)LONGFROMMP(mp2);
    if(somIsObj(cwAudio)) {
      char fName[CCHMAXPATH];
      CWAudioData *somThis = CWAudioGetData(cwAudio);
      
      sprintf(fName,"%d",_ulChannels);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_CHANNELS),fName);
      
      sprintf(fName,"%d",_ulSampleRate);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_SAMPLERATE),fName);
      sprintf(fName,"%d",_ulBPS);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_BPS),fName);
      sprintf(fName,"%d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
      WinSetWindowText(WinWindowFromID(hwnd, IDST_PLAYTIME),fName);
      WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    }
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
#if 0
  case WM_WINDOWPOSCHANGED:
    {
      /* This prevents switching the notebook page behind the open folder */
      if(!(WinQueryWindowUShort(WinQueryWindow(hwnd, QW_PARENT), QWS_FLAGS) & FF_ACTIVE))
        mp2=MPFROMLONG(0x80000);
      break;
    }
#endif
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);

}

/****************************************************************/
/*                                                              */
/* Insert new settings notebook page showing audio information. */
/*                                                              */
/****************************************************************/
SOM_Scope ULONG  SOMLINK cwaudio_cwmmAddWaveInformationPage(CWAudio *somSelf, 
                                                            HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  CWAudioData *somThis = CWAudioGetData(somSelf);
  CWAudioMethodDebug("CWAudio","cwaudio_cwmmAddWaveInformationPage");


  if(_ulFileSize!=_wpQueryFileSize(somSelf)) {
    /* The filesize changed, somebody altered the audio file so reread the info */
    if(!cwObjectIsOnCD(somSelf)) {
      /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
         MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
         isn't necessary. When opening the settings notebook the info is reread anyway. */      
      
      /* Get class object */
      M_CWMMDataFile *m_cwmmDataFile=_CWMMDataFile;
      /* Get data pointer of class object */
      M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(m_cwmmDataFile);
      
      /* Send the object pointer to the audio worker thread to read the audio info in the background. */
      WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);
    }
  }

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = waveInfoDlgProc;
  //The resource DLL
  pageinfo.resid = queryModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_WAVEINFOPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = IDDLG_GENERAL2PAGE;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = NULLHANDLE;
  //We have a major tab so we need a name
  /* pageName: "ISO filesystem" */
  getMessage(pageName, ID_WAVEINFOPAGENAME, sizeof(pageName),  queryModuleHandle(), hwndNotebook);
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook
  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);
}


SOM_Scope BOOL  SOMLINK cwaudio_cwmmSetTrackInfo(CWAudio *somSelf, 
                                                 char* chrString, 
                                                 ULONG ulValue, 
                                                 int iWhich)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmSetIdInfo");

    if(iWhich<1||iWhich>IDINFO_LASTINFO)
      return FALSE;

    switch(iWhich)
      {
      case IDINFO_PLAYTIME:
        _ulPlaySecs=ulValue;
        sprintf(_chrPlayTime, "%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
        break;
      case IDINFO_NAME:
        strncpy(_id3Name,chrString,sizeof(_id3Name));
        _id3Name[sizeof(_id3Name)-1]=0;
        _removeTrailingSpaces(_id3Name);
        break;
      case IDINFO_ARTIST:
        strncpy(_id3Artist,chrString,sizeof(_id3Artist));
        _id3Artist[sizeof(_id3Artist)-1]=0;
        _removeTrailingSpaces(_id3Artist);
        break;
      case IDINFO_ALBUM:
        strncpy(_id3Album, chrString, sizeof(_id3Album));
        _id3Album[sizeof(_id3Album)-1]=0;
        _removeTrailingSpaces(_id3Album);
        break;
      case IDINFO_YEAR:
        strncpy(_id3Year, chrString, sizeof(_id3Year));
        _id3Year[sizeof(_id3Year)-1]=0;
        _removeTrailingSpaces(_id3Year);
        break;
      case IDINFO_COMMENT:
        strncpy(_id3Comment,chrString, sizeof(_id3Comment));
        _id3Comment[sizeof(_id3Comment)]=0;
        _removeTrailingSpaces(_id3Comment);
        break;
      case IDINFO_GENRE:
        strncpy(_id3Genre, chrString, sizeof(_id3Genre));
        _id3Genre[sizeof(_id3Genre)-1]=0;
        _removeTrailingSpaces(_id3Genre);
        break;
      default:
        return FALSE;
      }
    /* Return statement to be customized: */
    return TRUE;
}


/*
 * The prototype for cwaudio_cwmmQueryTrackInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwaudio_cwmmQueryTrackInfo(CWAudio *somSelf, 
                                                    char** chrString, 
                                                    ULONG ulSize, 
                                                    int iWhich)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmQueryTrackInfo");

    switch(iWhich)
      {
      case IDINFO_PLAYTIME:
        return _ulPlaySecs;
      case IDINFO_BPS:
        return _ulBPS;
      case IDINFO_CHANNELS:
        return _ulChannels;
      case IDINFO_SAMPLERATE:
        return _ulSampleRate;
      case IDINFO_NAME:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Name)) {
            strncpy(chr, _id3Name, sizeof(_id3Name));
            chr[sizeof(_id3Name)-1]=0;
          }
          else {
            strncpy(chr, _id3Name, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ARTIST:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Artist)) {
            strncpy(chr, _id3Artist, sizeof(_id3Artist));
            chr[sizeof(_id3Artist)-1]=0;
          }
          else {
            strncpy(chr, _id3Artist, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_ALBUM:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Album)) {
            strncpy(chr, _id3Album, sizeof(_id3Album));
            chr[sizeof(_id3Album)-1]=0;
          }
          else {
            strncpy(chr, _id3Album, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_COMMENT:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Comment)) {
            strncpy(chr, _id3Comment, sizeof(_id3Comment));
            chr[sizeof(_id3Comment)-1]=0;
          }
          else {
            strncpy(chr, _id3Comment, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_YEAR:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Year)) {
            strncpy(chr, _id3Year, sizeof(_id3Year));
            chr[sizeof(_id3Year)-1]=0;
          }
          else {
            strncpy(chr, _id3Year, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      case IDINFO_GENRE:
        {
          char *chr=*chrString;
          if(ulSize>=sizeof(_id3Genre)) {
            strncpy(chr, _id3Genre, sizeof(_id3Genre));
            chr[sizeof(_id3Genre)-1]=0;
          }
          else {
            strncpy(chr, _id3Genre, ulSize);
            chr[ulSize-1]=0;
          }
          if(chr[0]==0)
            return FALSE;
          else
            return TRUE;
        }
      default:
        break;
      }

    /* Return statement to be customized: */
    return 0;
}

typedef struct _OPENPARAMS
{
  /* CWMMDataFile* thisPtr; */
  WPObject* thisPtr;
  PID pid;
  SWCNTRL swCtrl;
  USEITEM useItem;
  VIEWITEM viewItem;
  //  char chrTitle[CCHMAXPATH];
}OPENPARAMS;


/************************************************************/
/*                                                          */
/*                                                          */
/*                                                          */
/************************************************************/
MRESULT EXPENTRY playObjectProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        CWAudio * thisPtr;
        thisPtr=(CWAudio *)PVOIDFROMMP(mp2);/* Get object ptr */
        if(somIsObj(thisPtr)) {
          switch(LONGFROMMP(mp1))
            {
              case ACKEY_START:
                {
                  unsigned char chrCommand[CCHMAXPATH*2];
                  char chrDevice[20];
                  char name[CCHMAXPATH];
                  ULONG ulNameSize;
                  char retMsg[20];
                  APIRET rc;
                  int iTime;
                  SOMClass* mmMIDIClass=cwGetSomClass("CWMIDI");
                  CWAudioData *somThis = CWAudioGetData(thisPtr);
                  
                  WinSetWindowULong(hwnd, QWL_USER, (ULONG)thisPtr);
                  
                  if(_somIsA(thisPtr, mmMIDIClass))
                    strncpy(chrDevice,"SEQUENCER", sizeof(chrDevice));
                  else
                    strncpy(chrDevice,"WAVEAUDIO", sizeof(chrDevice));
                  
                  ulNameSize=sizeof(name);
                  _wpQueryRealName(thisPtr, name, &ulNameSize, TRUE);
                  
                  /* Start audio file */  
                  sprintf(chrCommand,"open \"%s\"  type %s alias wave%d SHAREABLE wait",name, chrDevice, thisPtr);
                  rc = mciSendString( chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd,WM_QUIT,0,0);
                    return MRFALSE;
                  }

                  /* Set time format */
                  sprintf(chrCommand,"SET wave%d TIME FORMAT MILLISECONDS wait", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  sprintf(chrCommand,"STATUS wave%d LENGTH WAIT", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }
                  
                  iTime=atoi(retMsg);

                  //       sprintf(chrCommand,"SETPOSITIONADVISE wave%d ON EVERY %d NOTIFY", thisPtr, 3000);
                  //       rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                  
                  if(iTime>1100)
                    iTime-=700;
                  else
                    iTime-=300;

                  if(iTime<=0)
                    iTime=100;

                  // WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, retMsg, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
                  sprintf(chrCommand,"SETCUEPOINT wave%d ON at %d WAIT", thisPtr, iTime);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), hwnd, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 500);
                  
                  sprintf(chrCommand,"play wave%d ", thisPtr);
                  rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                  if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
                    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
                    return MRFALSE;
                  }

                  /* Set Time in icon title to 00:00 */
                  strncpy(chrCommand, _wpQueryTitle(thisPtr), CCHMAXPATH);
                  if(_ulPlaySecs) {
                    sprintf(retMsg, "%02d:%02d", _ulPlaySecs/60, _ulPlaySecs%60);                  
                    strncat(chrCommand,"\n00:00 / ",sizeof(chrCommand)-1-strlen(chrCommand));
                    strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
                  }
                  else
                    strncat(chrCommand,"\n00:00", sizeof(chrCommand)-1-strlen(chrCommand));
                  _cwmmSetRecordTitles(thisPtr, chrCommand, FALSE);
                  WinStartTimer(WinQueryAnchorBlock(hwnd), hwnd, 1, 1000);

                  break;
                }
            case ACKEY_STOP:
              {
                /* Stop playing */
                unsigned char chrCommand[CCHMAXPATH];
                char retMsg[20];

                WinStopTimer(WinQueryAnchorBlock(hwnd),hwnd,1 );
                
                sprintf(chrCommand,"stop wave%d wait", thisPtr);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                
                sprintf(chrCommand,"close wave%d wait", thisPtr);
                mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
                
                WinPostMsg(hwnd,WM_QUIT,0,0);
              }
            default:
              break;
            }
        }/* if(thisPtr) */
        return MRFALSE;
      }
      //case MM_MCIPOSITIONCHANGE:
    case WM_TIMER:
      if(SHORT1FROMMP(mp1)==1) {
        CWAudio * thisPtr;
        thisPtr=(CWAudio *)WinQueryWindowULong(hwnd, QWL_USER);

        if(somIsObj(thisPtr)) {
          char retMsg[40];
          unsigned char chrCommand[CCHMAXPATH+20];
          APIRET rc;
          ULONG ulCur;
          CWAudioData *somThis = CWAudioGetData(thisPtr);

          /* Get current play position */
          sprintf(chrCommand,"STATUS wave%d POSITION WAIT", thisPtr);
          rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
          if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
            //    WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
            return MRFALSE;
          }

          ulCur=atoi(retMsg)/1000;
          strncpy(chrCommand, _wpQueryTitle(thisPtr), CCHMAXPATH);
          strncat(chrCommand,"\n",sizeof(chrCommand)-1-strlen(chrCommand));
          if(_ulPlaySecs) {
            sprintf(retMsg, "%02d:%02d / %02d:%02d", ulCur/60, ulCur%60, _ulPlaySecs/60, _ulPlaySecs%60);
            strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
          }
          else
            {
            sprintf(retMsg, "%02d:%02d", ulCur/60, ulCur%60);
            strncat(chrCommand, retMsg,sizeof(chrCommand)-1-strlen(chrCommand));
            }
          /* Set new time in icon title */
          _cwmmSetRecordTitles(thisPtr, chrCommand, FALSE);
        }
        //        DosBeep(1000, 100);
        return MRFALSE;
      }
      break;
    case MM_MCICUEPOINT:
      {
        /***********************************************/
        /* The track is about to end                   */
        /***********************************************/
        CWAudio * thisPtr;
        thisPtr=(CWAudio *)WinQueryWindowULong(hwnd, QWL_USER);

        if(somIsObj(thisPtr)) {
          unsigned char chrCommand[CCHMAXPATH];
          char retMsg[20];

          sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
          do {
            APIRET rc;
            retMsg[0]=0;
            DosSleep(100);
            //   sprintf(chrCommand,"STATUS wave%d MODE WAIT", thisPtr);
            rc = mciSendString(chrCommand, retMsg, sizeof(retMsg), 0, 0);
            if((rc & 0x0000ffff)!=MCIERR_SUCCESS) {
              WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));

              return MRFALSE;
            }
            //  WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, retMsg, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
            //DosBeep(500,50);
            //HlpWriteToTrapLog("%s\n", retMsg);
          }
          while(!stricmp(retMsg, "playing"));
          WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(thisPtr));
        }
        return MRFALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

/************************************************************/
/*                                                          */
/* This thread is used to handle the object in use emphasis.*/
/* Playing starts on the object window proc.                */
/*                                                          */
/************************************************************/
void _Optlink playThreadFunc (void *arg)
{
  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  OPENPARAMS * params;
  CWMMDataFile *thisPtr;

  params=(OPENPARAMS*)arg;
  if(!params)
    return;

  thisPtr=params->thisPtr; 
  if(!somIsObj(thisPtr))
    return;

  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab,0);
    if(hmq) {
      HWND hwnd;
      CWMMDataFileData *somThis = CWMMDataFileGetData(thisPtr);
      //      CWAudioData *somThis = CWAudioGetData(thisPtr);

      if(somIsObj(thisPtr)) {
        params->useItem.type=USAGE_OPENVIEW;
        params->viewItem.handle=NULLHANDLE;
        
        hwnd=WinCreateWindow(HWND_OBJECT,WC_STATIC,"playObj", 0, 0, 0, 0, 0, 
                             NULLHANDLE, HWND_BOTTOM,12343,NULL,NULL);
        if(hwnd) {
          /* Window created. */
          _wpAddToObjUseList(thisPtr, &params->useItem);
          WinSubclassWindow(hwnd,_cwmmQueryObjWindowProc(thisPtr)/*&playObjectProc*/);

          //  DosSetPriority(PRTYS_THREAD, PRTYC_FOREGROUNDSERVER, 0, 0);

          WinPostMsg(hwnd, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_START), MPFROMP(thisPtr));
          _hwndObjectPlay=hwnd;
        
          while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
            WinDispatchMsg(hab,&qmsg);
          WinDestroyWindow(hwnd);
          _cwmmSetRecordTitles(thisPtr, NULLHANDLE, FALSE);
        }
        if(somIsObj(thisPtr)) {
          _wpDeleteFromObjUseList(thisPtr, &params->useItem);
          _hwndObjectPlay=NULLHANDLE;
          _wpSetDefaultView(thisPtr, _ulPreviousView);
        }/* somIsObj() */
      }/* somIsObj() */
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
  /* Free the parameters */
  _wpFreeMem(thisPtr, (PBYTE)params);
}

/****************************************************************/
/*                                                              */
/* New method which starts playing of the file. Playing is done */
/* on a separate thread.
/*                                                              */
/****************************************************************/
SOM_Scope void  SOMLINK cwaudio_cwmmPlayTrack(CWAudio *somSelf, 
                                              BOOL bPlay)
{
  ULONG ulError;
  OPENPARAMS *pThreadParams;

  /*    CWAudioData *somThis = CWAudioGetData(somSelf);*/
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmPlayTrack");

    if(bPlay) {
      if(!WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay)) {
        /* Start playing */
        pThreadParams=(OPENPARAMS*)_wpAllocMem(somSelf, sizeof(OPENPARAMS), &ulError);
        if(pThreadParams) {
          char chrTitle[CCHMAXPATH];
          char chrText[100];

          strncpy(chrTitle, _wpQueryTitle(somSelf), sizeof(chrTitle));
          chrTitle[sizeof(chrTitle)-1]=0;
          getMessage(chrText, IDSTR_STARTINGTRACK, sizeof(chrText), queryModuleHandle(), HWND_DESKTOP);
          strncat(chrTitle,"\n", sizeof(chrTitle)-1-strlen(chrTitle));
          strncat(chrTitle, chrText, sizeof(chrTitle)-1-strlen(chrTitle));

          memset((void*)pThreadParams ,0, sizeof(OPENPARAMS));
          pThreadParams->thisPtr=somSelf;
          pThreadParams->viewItem.view=ID_MENU_START;
          if(_beginthread(playThreadFunc,NULL,8192*16,(void*)pThreadParams)) //Fehlerbehandlung fehlt
            _cwmmSetRecordTitles(somSelf, chrTitle, FALSE);
        }
      }
    }
    else
      if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
        WinPostMsg(_hwndObjectPlay, WM_APPTERMINATENOTIFY, MPFROMLONG(ACKEY_STOP), MPFROMP(somSelf));
}


/****************************************************************/
/*                                                              */
/* Insert new settings notebook page showing track information. */
/*                                                              */
/****************************************************************/
SOM_Scope ULONG  SOMLINK cwaudio_cwmmAddTrackNamePage(CWAudio *somSelf, 
                                                      HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_cwmmAddTrackNamePage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = trackNameDlgProc;
  //The resource DLL
  pageinfo.resid = queryModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_ID3TAGS;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  pageinfo.idDefaultHelpPanel = TRACKNAME_SETTINGS_PANEL;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = _queryMp3HelpLibraryName();
  //We have a major tab so we need a name
  getMessage(pageName, ID_TRACKNAMEPAGENAME, sizeof(pageName),  queryModuleHandle(), hwndNotebook);
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook

  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);
}

SOM_Scope BOOL  SOMLINK cwaudio_wpAddSettingsPages(CWAudio *somSelf, 
                                                   HWND hwndNotebook)
{
  BOOL rc;

  MMIOINFO mmio;
  ULONG ulSize;
  HMMIO hmmio;
  MMAUDIOHEADER mmAudioHeader={0};
  LONG lBytesRead=0;
  char fName[CCHMAXPATH];

  CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpAddSettingsPages");


    rc= (CWAudio_parent_CWMMDataFile_wpAddSettingsPages(somSelf, hwndNotebook));

    return rc | _cwmmAddWaveInformationPage(somSelf, hwndNotebook)|
      _cwmmAddTrackNamePage(somSelf, hwndNotebook);
}


SOM_Scope ULONG  SOMLINK cwaudio_wpQueryDetailsData(CWAudio *somSelf, 
                                                    PVOID* ppDetailsData, 
                                                    PULONG pcp)
{
  BOOL rcParent;
  PAUDIODETAILS pAudioDetails;
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpQueryDetailsData");

    /* Call parent */
    rcParent= (CWAudio_parent_CWMMDataFile_wpQueryDetailsData(somSelf, 
                                                      ppDetailsData, 
                                                      pcp));


  /* The WPS asks for data to be displayed */
  if(ppDetailsData)
    {
#if 0
      char chrCommand[400];
      sprintf(chrCommand, "%s , ppDetailsData: %x  *ppDetailsData: %x &_chrPlayTime: %x",  _id3Artist, ppDetailsData,
              *ppDetailsData, &_chrPlayTime);
      WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, chrCommand, "CWAudio", 1234, MB_OK|MB_MOVEABLE);
#endif
      /* Fill the structure with the info to be displayed */      
      pAudioDetails=(PAUDIODETAILS)*ppDetailsData;  
      pAudioDetails->pszPlayTime=_chrPlayTime;
      pAudioDetails->pszSampleRate=_chrSampleRate;
      pAudioDetails->pszChannels=_chrChannels;
      pAudioDetails->pszBPS=_chrBPS;

      pAudioDetails->pszName=_id3Name;
      pAudioDetails->pszArtist=_id3Artist;
      pAudioDetails->pszAlbum=_id3Album;
      pAudioDetails->pszYear=_id3Year;
      pAudioDetails->pszComment=_id3Comment;
      pAudioDetails->pszGenre=_id3Genre;
      *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pAudioDetails);  
    }
  else
    {
      /* Buffer size is queried */
      if(pcp)
        *pcp+=sizeof(*pAudioDetails);
    }
    return rcParent;
}

SOM_Scope BOOL  SOMLINK cwaudio_wpRestoreState(CWAudio *somSelf, 
                                               ULONG ulReserved)
{
  BOOL bRc; 
  char fName[CCHMAXPATH];
  BOOL bReRead=FALSE;
  ULONG ulSize;

   CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpRestoreState");

    bRc=(CWAudio_parent_CWMMDataFile_wpRestoreState(somSelf, ulReserved));

    _bNeedSaving=FALSE;

    /* Query the audio info */
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_FILESIZE, &_ulFileSize))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_TIME, &_ulPlaySecs))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_CHANNELS, &_ulChannels))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_SAMPLERATE, &_ulSampleRate))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_BPS, &_ulBPS))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWAudio", KEY_TIME_MS, &_ulPlayMsecs))
      bReRead=TRUE;

    ulSize=sizeof(_id3Name);
    _wpRestoreString(somSelf, "CWAudio",KEY_TRACKNAME, _id3Name, &ulSize);
    ulSize=sizeof(_id3Artist);
    _wpRestoreString(somSelf, "CWAudio",KEY_ARTIST, _id3Artist, &ulSize);
    ulSize=sizeof(_id3Album);
    _wpRestoreString(somSelf, "CWAudio",KEY_ALBUM, _id3Album, &ulSize);
    ulSize=sizeof(_id3Comment);
    _wpRestoreString(somSelf, "CWAudio",KEY_COMMENT, _id3Comment, &ulSize);
    ulSize=sizeof(_id3Year);
    _wpRestoreString(somSelf, "CWAudio",KEY_YEAR, _id3Year, &ulSize);
    ulSize=sizeof(_id3Genre);
    _wpRestoreString(somSelf, "CWAudio",KEY_GENRE, _id3Genre, &ulSize);

    if(_ulFileSize!=_wpQueryFileSize(somSelf))
      bReRead=TRUE; /* The filesize changed, somebody altered the audio file so reread the info */

    if(!_ulFileSize)
      bReRead=FALSE;
    /* If filesize=0 do nothing because the file was just created and there's no contents yet */
 
    if(cwObjectIsOnCD(somSelf) && bReRead) {
      /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
         MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
         isn't necessary. When opening the settings notebook the info is reread anyway. */      
      bReRead=FALSE;
    }
    
    if(bReRead){
      /* Get class object */
      /* Get data pointer of class object */
      M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(_CWMMDataFile);

      /* Send the object pointer to the audio worker thread to read the audio info in the background. */
      WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);

#if 0
      /* The following was moved to the audioWorkerThread */
             do{          
          _ulFileSize=_wpQueryFileSize(somSelf);
          _bNeedSaving=TRUE;/* When the object is initialized the new instance data will be saved in wpObjectReady(). */
          bContinue=TRUE;
        }while(FALSE);
        if(!bContinue)
          return bRc;
#endif
        strncpy(_chrChannels, "??", sizeof(_chrChannels));
        strncpy(_chrSampleRate, "??", sizeof(_chrSampleRate));      
        strncpy(_chrBPS, "??", sizeof(_chrBPS));
        strncpy(_chrPlayTime, "??:??", sizeof(_chrPlayTime));

        _ulFileSize=0;
        _ulPlaySecs=0;
        _ulChannels=0;
        _ulSampleRate=0;
        _ulBPS=0;
        _ulPlayMsecs=0;
    }/* bReRead */
    else {
      sprintf(fName,"%d",_ulChannels);
      strncpy(_chrChannels, fName, sizeof(_chrChannels));
      _chrChannels[sizeof(_chrChannels)-1]=0;
      
      sprintf(fName,"%d", _ulSampleRate);
      strncpy(_chrSampleRate, fName, sizeof(_chrSampleRate));      
      _chrSampleRate[sizeof(_chrSampleRate)-1]=0;
      
      sprintf(fName,"%d",_ulBPS);
      strncpy(_chrBPS, fName, sizeof(_chrBPS));
      _chrBPS[sizeof(_chrBPS)-1]=0;
      
      sprintf(fName,"%02d:%02d",_ulPlaySecs/60, _ulPlaySecs%60);
      strncpy(_chrPlayTime, fName, sizeof(_chrPlayTime));
      _chrPlayTime[sizeof(_chrPlayTime)-1]=0;

    }
    return bRc;
}

SOM_Scope BOOL  SOMLINK cwaudio_wpSaveState(CWAudio *somSelf)
{
  char chrBuffer[10];
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpSaveState");

    if(_ulFileSize) {
      _wpSaveLong(somSelf, "CWAudio",KEY_TIME,_ulPlaySecs);
      _wpSaveLong(somSelf, "CWAudio",KEY_SAMPLERATE,_ulSampleRate);
      _wpSaveLong(somSelf, "CWAudio",KEY_CHANNELS,_ulChannels);
      _wpSaveLong(somSelf, "CWAudio",KEY_BPS,_ulBPS);
      _wpSaveLong(somSelf, "CWAudio",KEY_FILESIZE,_ulFileSize);
      _wpSaveLong(somSelf, "CWAudio",KEY_TIME_MS,_ulPlayMsecs);
    }

    _wpSaveString(somSelf, "CWAudio",KEY_TRACKNAME, _id3Name);
    _wpSaveString(somSelf, "CWAudio",KEY_ARTIST, _id3Artist);
    _wpSaveString(somSelf, "CWAudio",KEY_ALBUM, _id3Album);
    _wpSaveString(somSelf, "CWAudio",KEY_COMMENT, _id3Comment);
    _wpSaveString(somSelf, "CWAudio",KEY_YEAR, _id3Year);
    _wpSaveString(somSelf, "CWAudio",KEY_GENRE, _id3Genre);

    /* Save audio info in EA for other programs */
    cwSaveStringToEA(somSelf, "MMTRACKNAME", _id3Name);
    cwSaveStringToEA(somSelf, "MMARTIST", _id3Artist);
    cwSaveStringToEA(somSelf, "MMALBUM", _id3Album);
    cwSaveStringToEA(somSelf, "MMYEAR", _id3Year);
    cwSaveStringToEA(somSelf, "MMCOMMENT", _id3Comment);
    sprintf(chrBuffer,"%d",_ulSampleRate);
    cwSaveStringToEA(somSelf, "MMSAMPLERATE", chrBuffer);
    sprintf(chrBuffer,"%d",_ulChannels);
    cwSaveStringToEA(somSelf, "MMCHANNELS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulBPS);
    cwSaveStringToEA(somSelf, "MMBPS", chrBuffer);
    sprintf(chrBuffer,"%d",_ulPlaySecs);
    cwSaveStringToEA(somSelf, "MMPLAYTIME", chrBuffer);
    sprintf(chrBuffer,"%d",_ulPlayMsecs);
    cwSaveStringToEA(somSelf, "MMPLAYTIMEMS", chrBuffer);
    cwSaveStringToEA(somSelf, "MMGENRE", _id3Genre);

    /* Set .TYPE EA so the editor and the player are happy. */
    _wpSetType(somSelf, "Digital Audio" , NULL);
    return (CWAudio_parent_CWMMDataFile_wpSaveState(somSelf));
}


static BOOL insertAudioIOProcMenuItems( HWND hwndMenu )
{
    CHAR          szBuffer[ sizeof( FOURCC ) + CCHMAXPATH + 4 ];
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    void * memPtr;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;
    LONG          lBytesRead;
    HWND hwndSubMenu;
    MENUITEM mi;

    /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/
LONG          lNumIOProcs;
    /*!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!*/

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_AUDIO;
    mmFormatInfo.ulFlags|=MMIO_CANWRITEUNTRANSLATED;
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         * Error - mmioQueryFormatCount failed.
         */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    memPtr=pmmFormatInfoArray;
    if( pmmFormatInfoArray == NULL )
      {
        /*
         * Could not allocate enough memory for mmFormatInfo array.
         */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }

    // Create Empty Submenu //
    hwndSubMenu=WinCreateWindow(hwndMenu,WC_MENU,"",0,
                                0,0,0,0,
                                hwndMenu,//Owner. If set, this window 
                                //is destroyed if owner is destroyed
                                HWND_TOP,
                                ID_MENU_CONVERT,//menuid
                                NULL,NULL);

    mi.iPosition=MIT_END;
    mi.afStyle=MIS_TEXT;//|MIS_SUBMENU;
    mi.id=ID_MENU_CONVERT;
    mi.afAttribute=NULLHANDLE;    
    mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
    mi.hItem=NULLHANDLE;
    mi.hwndSubMenu=hwndSubMenu;

    if(!getMessage(szBuffer, IDSTR_MENU_CONVERT, sizeof(szBuffer), queryModuleHandle(), HWND_DESKTOP))
       sprintf(szBuffer,"~Convert to");
    WinSendMsg(hwndMenu,MM_INSERTITEM,(MPARAM)&mi,
               (MPARAM)szBuffer);

    for ( index = 0; index <lNumIOProcs; index++ )
      {

        mmioGetFormatName(pmmFormatInfoArray, szBuffer, &lBytesRead, 0L, 0L);
        //        FourccToString ( pmmFormatInfoArray->fccIOProc,
        //               pszFourccString );
        
        /* Insert NULL string terminator */
        *( szBuffer + lBytesRead ) = (CHAR)NULL;

        /* Compressed TIF is not supported because the Warp 4 IO-Procs are
           broken. */
        if(pmmFormatInfoArray->ulFlags & MMIO_CANWRITETRANSLATED)
          {
            /* Add menu item */
            /* Fill the MENUITEM structure */
            mi.iPosition=MIT_END;
            mi.afStyle=MIS_TEXT|MIS_SUBMENU;
            mi.id=ID_ITEM_FIRSTCONVERT+index;
            mi.afAttribute=NULLHANDLE;    
            mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
            mi.hItem=NULLHANDLE;
            WinSendMsg(hwndSubMenu, MM_INSERTITEM,(MPARAM)&mi,
                       (MPARAM)szBuffer);
          }
        /*
         *  advance to next entry in mmFormatInfo array
         */
        pmmFormatInfoArray++;
      }
    free(memPtr);
    return TRUE;
}

SOM_Scope BOOL  SOMLINK cwaudio_wpModifyPopupMenu(CWAudio *somSelf, 
                                                  HWND hwndMenu, 
                                                  HWND hwndCnr, 
                                                  ULONG iPosition)
{
  BOOL rc;
      CWAudioData *CWAData = CWAudioGetData(somSelf);
      CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpModifyPopupMenu");


    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_VOLUME, 1);

    _wpInsertPopupMenuItems(somSelf, hwndMenu, -1, queryModuleHandle(), ID_MENU_CONVERT, 0);
#if 0
    /* Insert all known audio I/O procs */
    TRY_LOUD(AUDIO_INSERTPOPUPMENU) {
      insertAudioIOProcMenuItems( hwndMenu );
    }/* TRY_LOUD */
    CATCH(AUDIO_INSERTPOPUPMENU)
      {
        HlpWriteToTrapLog("\nTrap occured in %s, file %s, near line %d.\n",
                          __FUNCTION__, __FILE__, __LINE__);
      } END_CATCH;
#endif
    if(WinIsWindow(WinQueryAnchorBlock(HWND_DESKTOP),_hwndObjectPlay))
      _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_STOP, 1);
    else
      {
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_EDITOR, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_PLAYER, 1);
        _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryModuleHandle(), ID_MENU_START, 1);
      }
    rc= (CWAudio_parent_CWMMDataFile_wpModifyPopupMenu(somSelf, 
                                                       hwndMenu, 
                                                       hwndCnr, 
                                                       iPosition));
#if 0
    if(CWAData->pOrgTitle)
      _cwmmSetRecordTitles(somSelf, CWAData->chrRecordTitle);
#endif
    return rc;
}


SOM_Scope BOOL  SOMLINK cwaudio_wpMenuItemSelected(CWAudio *somSelf, 
                                                   HWND hwndFrame, 
                                                   ULONG ulMenuId)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpMenuItemSelected");

    switch(ulMenuId)
      {
      case ID_MENU_VOLUME:
        {
          HOBJECT hObject;
          if((hObject=WinQueryObject("<MMPM2_MMVOLUME>"))!=NULLHANDLE)
            WinOpenObject(hObject, OPEN_DEFAULT, TRUE);
          return TRUE;
        }
      case ID_MENU_START:
      case ID_MENU_STOP:
      case ID_MENU_PLAYER:
      case ID_MENU_EDITOR:
      case ID_ITEM_CONVERT:
        _wpViewObject(somSelf, NULLHANDLE, ulMenuId,0);
        return TRUE;
      default:
        break;
      }
    return (CWAudio_parent_CWMMDataFile_wpMenuItemSelected(somSelf, 
                                                      hwndFrame, 
                                                      ulMenuId));
}


SOM_Scope void  SOMLINK cwaudio_wpObjectReady(CWAudio *somSelf, 
                                              ULONG ulCode, WPObject* refObject)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpObjectReady");

    if(_bNeedSaving)
      _wpSaveDeferred(somSelf);

    CWAudio_parent_CWMMDataFile_wpObjectReady(somSelf, ulCode, refObject);
}


SOM_Scope BOOL  SOMLINK cwaudio_wpRefresh(CWAudio *somSelf, ULONG ulView, 
                                          PVOID pReserved)
{
  BOOL bRc; 
  ULONG rc;
  MMIOINFO mmio;
  ULONG ulSize;
  HMMIO hmmio;
  MMAUDIOHEADER mmAudioHeader={0};
  LONG lBytesRead=0;
  char fName[CCHMAXPATH];

  CWAudioData *somThis = CWAudioGetData(somSelf);
  CWAudioMethodDebug("CWAudio","cwaudio_wpRefresh");

  bRc=(CWAudio_parent_CWMMDataFile_wpRefresh(somSelf, ulView, 
                                        pReserved));
  
  return bRc;
}


SOM_Scope BOOL  SOMLINK cwaudio_wpSetup(CWAudio *somSelf, PSZ pszSetupString)
{
  char buffer[CCHMAXPATH];
  ULONG bufferSize;

  CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpSetup");

    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOTRACKNAME, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_NAME);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOARTIST, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ARTIST);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOALBUM, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_ALBUM);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOCOMMENT, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_COMMENT);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOGENRE, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_GENRE);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOYEAR, buffer, &bufferSize))
      {
        _cwmmSetTrackInfo(somSelf, buffer, 0, IDINFO_YEAR);
        // _wpCnrRefreshDetails(somSelf);
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_AUDIOPLAYTIME, buffer, &bufferSize))
      {
        int iPlaytime=atoi(buffer);
        if(iPlaytime<0)
          iPlaytime=0;
        _cwmmSetTrackInfo(somSelf, buffer, iPlaytime, IDINFO_PLAYTIME);
        // _wpCnrRefreshDetails(somSelf);
      }

    /* Refresh */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_REFRESH, buffer,&bufferSize))
      {
        //        if(_ulFileSize!=_wpQueryFileSize(somSelf)) {
        _ulFileSize=1; /* Set filesize to 1 this will force a reread */
          /* The filesize changed, somebody altered the audio file so reread the info */
          if(!cwObjectIsOnCD(somSelf)) {
            /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
               MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
               isn't necessary. When opening the settings notebook the info is reread anyway. */      
            
            /* Get class object */
            M_CWMMDataFile *m_cwmmDataFile=_CWMMDataFile;
            /* Get data pointer of class object */
            M_CWMMDataFileData *cwmmData = M_CWMMDataFileGetData(m_cwmmDataFile);
            
            /* Send the object pointer to the audio worker thread to read the audio info in the background. */
            WinPostMsg(cwmmData->hwndAudioWorker , WM_APPTERMINATENOTIFY, somSelf, 0);
          }
          //   }
#if 0
        else
           {
          _wpRefresh(somSelf, 0,NULL);
          _wpCnrRefreshDetails(somSelf);
        }
#endif
      }

    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_COPYTAGTO, buffer, &bufferSize))
      {
        /* The caller requested to copy the tags from this audio file to another */
        char chrCommand[200];

        sprintf(chrCommand,"%s=%s;",SETUP_AUDIOTRACKNAME, _id3Name);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOARTIST, _id3Artist);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOALBUM, _id3Album);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOCOMMENT, _id3Comment);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOYEAR, _id3Year);
        HlpSendCommandToObject( buffer, chrCommand);

        sprintf(chrCommand,"%s=%s",SETUP_AUDIOGENRE, _id3Genre);
        HlpSendCommandToObject( buffer, chrCommand);

        // _wpCnrRefreshDetails(somSelf);
      }
    
    return (CWAudio_parent_CWMMDataFile_wpSetup(somSelf, pszSetupString));
}


ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView);

SOM_Scope HWND  SOMLINK cwaudio_wpOpen(CWAudio *somSelf, HWND hwndCnr, 
                                       ULONG ulView, ULONG param)
{
  ULONG ulRc;

  /*    CWAudioData *somThis = CWAudioGetData(somSelf);*/
    CWMMDataFileData *somThis = CWMMDataFileGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpOpen");

    switch(ulView)
      {
      case ID_MENU_START:
        {
          _ulPreviousView=_wpQueryDefaultView(somSelf);/* Save the view set by the user */
          _cwmmPlayTrack(somSelf, TRUE);
          _wpSetDefaultView(somSelf, ID_MENU_STOP);    /* Set new view so doubleclick stops the playing */
          return NULLHANDLE;
        }
      case ID_MENU_STOP:
        {
          _cwmmPlayTrack(somSelf, FALSE);
          _wpSetDefaultView(somSelf, _ulPreviousView);
          return NULLHANDLE;
        }
      case ID_MENU_PLAYER:
        /*case 0xbbe5:   Player */
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioplayer", "ab.exe", chrPlayer,sizeof(chrPlayer));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if((ulRc=launchPMProg("Spieler", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      case ID_MENU_EDITOR:
        /* case 0xbc0d:  Editor */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+10]="-e \"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioeditor", "ab.exe", chrPlayer,sizeof(chrPlayer));
          if((chrPtr=strchr(chrParams,0))!=NULLHANDLE) {
            ulSize=sizeof(chrParams)-2;
            _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
            strcat(chrPtr,"\"");
            if((ulRc=launchPMProg("Editor", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE)
              break;
            return NULLHANDLE;
          }
          break;
        }
      case 0xb4dd: /* Convert */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char *chrPtr=chrParams;
          ULONG ulSize;

          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "audioconverter", "", chrPlayer,sizeof(chrPlayer));
          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if((ulRc=launchPMProg("Spieler", chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      default:
        break;
      }
    return (CWAudio_parent_CWMMDataFile_wpOpen(somSelf, hwndCnr, ulView, 
                                          param));
}

SOM_Scope BOOL  SOMLINK cwaudio_wpSetTitle(CWAudio *somSelf, 
                                           PSZ pszNewTitle)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpSetTitle");
    //DosBeep(5000, 1000);

#if 0
    _pOrgTitle=NULLHANDLE;
#endif

    return (CWAudio_parent_CWMMDataFile_wpSetTitle(somSelf, pszNewTitle));
}


SOM_Scope BOOL  SOMLINK cwaudio_wpQueryRealName(CWAudio *somSelf, 
                                                PSZ pszFilename, 
                                                PULONG pcb, BOOL fQualified)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpQueryRealName");
    //    DosBeep(500, 1000);
    return (CWAudio_parent_CWMMDataFile_wpQueryRealName(somSelf, 
                                                        pszFilename, 
                                                        pcb, 
                                                        fQualified));
}


/*
 *    wpCreateShadowObject    : override;
 */

SOM_Scope PSZ  SOMLINK cwaudio_wpQueryTitle(CWAudio *somSelf)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpQueryTitle");
    //    DosBeep(1000, 500);

#if 0
    if(_pOrgTitle)
      return _pOrgTitle;
#endif

    return (CWAudio_parent_CWMMDataFile_wpQueryTitle(somSelf));
}

#if 0
SOM_Scope WPObject*  SOMLINK cwaudio_wpCreateShadowObject(CWAudio *somSelf, 
                                                          WPFolder* Folder, 
                                                          BOOL fLock)
{
  SOMClass*  scCWShadowClass;
      somId mySomId;

    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpCreateShadowObject");

    if((mySomId=somIdFromString("CWAudioShadow"))!=NULLHANDLE) {
      /* Get the CWAudioShadow class object */
      scCWShadowClass=_somClassFromId((SOMClass*)SOMClassMgrObject, mySomId);
      SOMFree(mySomId);
      DosBeep(5000,300);
      /* Check shadow class */
      if(somIsObj(scCWShadowClass)) {
        WPObject* wpObject;
        POINTL pointl;
        char chrSetup[50]={0};
        PPOINTL pptl;

        DosBeep(1000,300);
        if(WinQueryPointerPos(HWND_DESKTOP,&pointl))
          {
            HWND hwnd;
            if((hwnd=WinWindowFromPoint(HWND_DESKTOP,&pointl, TRUE))!=NULLHANDLE) {
              SWP swp;
              if(WinQueryWindowPos(hwnd, &swp)) {
                
                WinMapWindowPoints(HWND_DESKTOP, hwnd, &pointl, 1);

                HlpWriteToTrapLog("hwnd: %x cx: %d, cy: %d, x: %d, y: %d\n", hwnd,swp.cx, swp.cy, pointl.x, pointl.y);
                HlpWriteToTrapLog("%d %d\n", ((pointl.x-swp.x)*100)/swp.cx, ((pointl.y-swp.y)*100)/swp.cy);
                HlpWriteToTrapLog("ICONPOS=%d,%d;", ((pointl.x-swp.x)*100)/swp.cx, ((pointl.y-swp.y)*100)/swp.cy);
                sprintf(chrSetup, "ICONPOS=%d,%d;", ((pointl.x-swp.x)*100)/swp.cx, ((pointl.y-swp.y)*100)/swp.cy);
                ///pptl=_wpQueryNextIconPos(Folder);
                pptl->x=0;
                pptl->y=0;
                sprintf(chrSetup, "ICONPOS=0,0");
                _wpSetNextIconPos(Folder, &pointl);
                wpObject=_wpCreateShadowObjectExt(somSelf, Folder, fLock, chrSetup, (M_WPObject*)scCWShadowClass);

              }
            }
          }
        //            chrSetup[0]=0;
        if((wpObject)!=NULLHANDLE)
          return wpObject;
      }
    }

    return (CWAudio_parent_CWMMDataFile_wpCreateShadowObject(somSelf, 
                                                             Folder, 
                                                             fLock));
}
#endif

/*
 *    wpCreateShadowObject    : override;
 */

SOM_Scope void  SOMLINK cwaudio_wpInitData(CWAudio *somSelf)
{
    CWAudioData *somThis = CWAudioGetData(somSelf);
    CWAudioMethodDebug("CWAudio","cwaudio_wpInitData");

    CWAudio_parent_CWMMDataFile_wpInitData(somSelf);
    _ulFileSize=0;
    _cwmmSetObjWindowProc(somSelf, &playObjectProc);
}


SOM_Scope BOOL  SOMLINK cwaudioM_wpclsCreateDefaultTemplates(M_CWAudio *somSelf, 
                                                             WPObject* Folder)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsCreateDefaultTemplates");

    return TRUE;
}

SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryDetailsInfo(M_CWAudio *somSelf, 
                                                        PCLASSFIELDINFO* ppClassFieldInfo, 
                                                        PULONG pSize)
{
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;
  ULONG rc;


    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryDetailsInfo");

    cParentColumns= (M_CWAudio_parent_M_CWMMDataFile_wpclsQueryDetailsInfo(somSelf, 
                                                             ppClassFieldInfo, 
                                                             pSize));
  if(pSize)
    *pSize+=sizeof(AUDIODETAILS);

  if(ppClassFieldInfo)
    {
      if(*ppClassFieldInfo)
        {
          pCfi=*ppClassFieldInfo;
          for(i=0; i<cParentColumns;i++)
            pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);

          pCfi->pNextFieldInfo=cfiFieldInfo;
        }
      else
        *ppClassFieldInfo=cfiFieldInfo;
    }
    return (cParentColumns+NUM_AUDIO_FIELDS);
}

SOM_Scope PSZ  SOMLINK cwaudioM_wpclsQueryTitle(M_CWAudio *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_CWAUDIOTITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Digital audio");

    return chrTitle;
}

SOM_Scope void  SOMLINK cwaudioM_wpclsInitData(M_CWAudio *somSelf)
{
  PCLASSFIELDINFO pCfi;
  USHORT i;

  /*    M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsInitData");

    M_CWAudio_parent_M_CWMMDataFile_wpclsInitData(somSelf);

    /* Register mmedia class REXX functions */
    RexxRegisterFunctionExe("MMClsCallFunc", (PFN)rxCallCWMMFunc);

    if(getMessage(chrPlayTime, IDSTR_PLAYTIME, sizeof(chrPlayTime),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[0]=chrPlayTime;
    if(getMessage(chrSampleRate, IDSTR_SAMPLERATE, sizeof(chrSampleRate),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[1]=chrSampleRate;
    if(getMessage(chrChannels, IDSTR_CHANNELS, sizeof(chrChannels),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[2]=chrChannels;
    if(getMessage(chrBPS, IDSTR_BPS, sizeof(chrBPS),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[3]=chrBPS;

    if(getMessage(chrName, IDSTR_TITLE, sizeof(chrName),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[4]=chrName;
    if(getMessage(chrArtist, IDSTR_ARTIST, sizeof(chrArtist),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[5]=chrArtist;
    if(getMessage(chrAlbum, IDSTR_ALBUM, sizeof(chrAlbum),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[6]=chrAlbum;
    if(getMessage(chrYear, IDSTR_YEAR, sizeof(chrYear),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[7]=chrYear;
    if(getMessage(chrComment, IDSTR_COMMENT, sizeof(chrComment),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[8]=chrComment;
    if(getMessage(chrGenre, IDSTR_GENRE, sizeof(chrGenre),  queryModuleHandle(), HWND_DESKTOP))
      pszAudioColTitles[9]=chrGenre;


  /* Setup the static data for the details view */
  for(i=0,pCfi=cfiFieldInfo;i<NUM_AUDIO_FIELDS;i++,pCfi++)
    {
      memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));

      pCfi->cb=sizeof(CLASSFIELDINFO);
      pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
      pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
      pCfi->pNextFieldInfo=pCfi+1;
      pCfi->pTitleData=(PVOID)pszAudioColTitles[i];
      pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;

      switch(i)
        {
        case 0: /* Subject */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszPlayTime));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 1: /* From */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszSampleRate));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 2:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszChannels));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 3: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszBPS));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;

        case 4: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszName));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 5: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszArtist));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 6: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszAlbum));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 7: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszYear));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 8: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszComment));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 9: 
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(AUDIODETAILS,pszGenre));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;

        }/* switch(i) */
    }/* for() */
  cfiFieldInfo[NUM_AUDIO_FIELDS].pNextFieldInfo=NULL;

  /* Get name of help library from resource */
  if(!getMessage(chrHelpLibrary, IDSTR_HELPLIBRARY, sizeof(chrHelpLibrary), queryModuleHandle(), HWND_DESKTOP))
        strcpy(chrHelpLibrary,"MMPARTS.HLP");


}

SOM_Scope void  SOMLINK cwaudioM_wpclsUnInitData(M_CWAudio *somSelf)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsUnInitData");

    RexxDeregisterFunction("MMClsCallFunc");

    M_CWAudio_parent_M_CWMMDataFile_wpclsUnInitData(somSelf);
}


SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryDefaultView(M_CWAudio *somSelf)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryDefaultView");

    return ID_MENU_START;
    //    return (M_CWAudio_parent_M_MMAudio_wpclsQueryDefaultView(somSelf));
}


SOM_Scope ULONG  SOMLINK cwaudioM_wpclsQueryIconData(M_CWAudio *somSelf, 
                                                     PICONINFO pIconInfo)
{
    /* M_CWAudioData *somThis = M_CWAudioGetData(somSelf); */
    M_CWAudioMethodDebug("M_CWAudio","cwaudioM_wpclsQueryIconData");

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = queryModuleHandle();
      pIconInfo->resid   = ID_ICONCWAUDIOFILE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}

