
/*
 * (C) Chris Wohlgemuth 2002-2004
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwmmdisk_Source
#define SOM_Module_cwmmdisk_Source
#endif
#define CWMMDisk_Class_Source
#define M_CWMMDisk_Class_Source

#define INCL_PM
#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_WINWORKPLACE
#define INCL_DOSDEVIOCTL

#include "os2.h"
#include <stdio.h>
#include "cwmmdisk.ih"
#include "wpobject.h"
#include "wpfolder.h"

#include "sys_funcs.h"

HFILE openDrive(char* drive);
void closeDrive(HFILE hfDrive);
int CDQueryAudioCDTracks(HFILE hfDrive);

ULONG checkForCDDrive(ULONG ulDriveNum);
void invalidateDriveInList(ULONG ulDriveNum);

//#define OPEN_MMDISK  0x6500+0x400

/*
 *    wpInitData : override;
 *wpDelete : override;
 */

SOM_Scope HWND  SOMLINK cwmmdisk_wpViewObject(CWMMDisk *somSelf, 
                                              HWND hwndCnr, ULONG ulView, 
                                              ULONG param)
{
   /* CWMMDiskData *somThis = CWMMDiskGetData(somSelf); */
    CWMMDiskMethodDebug("CWMMDisk","cwmmdisk_wpViewObject");

    if(ulView == OPEN_DETAILS || ulView ==  OPEN_CONTENTS || ulView == OPEN_TREE || ulView == OPEN_DEFAULT) {
        int iDiskNum;
        
        if((iDiskNum=_wpQueryLogicalDrive(somSelf))!=0) {
          // if((iDiskNum>=iFirstCD && iDiskNum<=iFirstCD+iNumCD)) {
          //       SysWriteToTrapLog("Drive: %d, CD: %d\n", iDiskNum, checkForCDDrive(iDiskNum));
          if(checkForCDDrive(iDiskNum)==1) {
            /* It's a CD drive */
            HOBJECT hObject;
            char chrPlayerID[100];
            HFILE hFile;

            /* Check if it's an audio CD */
            sprintf(chrPlayerID, "%c:", 'A'+iDiskNum-1 );
            if((hFile=openDrive(chrPlayerID))!=NULLHANDLE) {
              int iNumTracks;

              iNumTracks=CDQueryAudioCDTracks( hFile);
              //         SysWriteToTrapLog("Drive %s opened. Num tracks: %d", chrPlayerID, iNumTracks);
              closeDrive(hFile);
              if(iNumTracks> 0) {
                sprintf(chrPlayerID, "<CWMM_CDPLAYER_%c>", 'A'+iDiskNum-1);
                if((hObject=WinQueryObject(chrPlayerID))!=NULLHANDLE) {
                  WPObject *wpObject;
                  HWND hwnd = 0;
                  wpObject=_wpclsQueryObject( _CWMMDisk , hObject);
                  if(somIsObj(wpObject)) {
                    hwnd=_wpViewObject(wpObject, NULLHANDLE, OPEN_DEFAULT, 0);
                    _wpUnlockObject(wpObject);
                  }
                  return hwnd;
                }
              }
            }
          }
        }
    }
    return (CWMMDisk_parent_WPDisk_wpViewObject(somSelf, hwndCnr, 
                                                ulView, param));
}

#if 0
/*
 *    wpInitData : override;
 *wpDelete : override;
 */

SOM_Scope HWND  SOMLINK cwmmdisk_wpViewObject(CWMMDisk *somSelf, 
                                              HWND hwndCnr, ULONG ulView, 
                                              ULONG param)
{
   /* CWMMDiskData *somThis = CWMMDiskGetData(somSelf); */
    CWMMDiskMethodDebug("CWMMDisk","cwmmdisk_wpViewObject");

    if(ulView == OPEN_DETAILS || ulView ==  OPEN_CONTENTS || ulView == OPEN_TREE || ulView == OPEN_DEFAULT) {
      if(bGotCD) {
        int iDiskNum;
        
        if((iDiskNum=_wpQueryLogicalDrive(somSelf))!=0) {
          if((iDiskNum>=iFirstCD && iDiskNum<=iFirstCD+iNumCD)) {
            /* It's a CD drive */
            HOBJECT hObject;
            char chrPlayerID[100];
            ULONG ulRC;
            HFILE hFile;

            /* Check if it's an audio CD */
            sprintf(chrPlayerID, "%c:", 'A'+iDiskNum-1 );
            if((hFile=openDrive(chrPlayerID))!=NULLHANDLE) {
              int iNumTracks;
              iNumTracks=CDQueryAudioCDTracks( hFile);
              closeDrive(hFile);
              if(iNumTracks> 0) {
                sprintf(chrPlayerID, "<CWMM_CDPLAYER_%c>", 'A'+iDiskNum-1);
                
                if((hObject=WinQueryObject(chrPlayerID))!=NULLHANDLE) {
                  if((ulRC=WinOpenObject(hObject, OPEN_DEFAULT, TRUE))!=NULLHANDLE) {
                    return NULLHANDLE;}
                }
                /* For some strange reason WinOpenObject() returns 0 when the folder was already openend
                   by the user. If it's reopened using WinOpenObject() from this method it returns 1!?
                   We found the handle and tried to open it. Normally this succeeds so we just
                   proceed as if everything is ok. The only thing we might loose if opening wasn't
                   successful is the error box saying the CD isn't formatted properly (because it's an
                   audio CD). Most users will even not notice this difference ;-) */ 
                return NULLHANDLE;
              }
            }
          }
        }
      }
    }
    return (CWMMDisk_parent_WPDisk_wpViewObject(somSelf, hwndCnr, 
                                                ulView, param));
}
#endif

#if 0
BOOL isCD(ULONG ulDriveNum)
{
  /* This may be a remote drive */
  char chrDev[8];
  ULONG cbBuf;
  ULONG rc;

  BYTE buf[sizeof(FSQBUFFER2)+3*CCHMAXPATH];
  PFSQBUFFER2 pBuf=(PFSQBUFFER2)buf;
  
  sprintf(chrDev, "%c:", 'a'+ulDriveNum-1);
  cbBuf=sizeof(buf);
  
  /* Check if local or remote (or anything else) */
  rc= DosQueryFSAttach(chrDev, 0, FSAIL_QUERYNAME,(PFSQBUFFER2) &buf, &cbBuf);
  if(!rc) {
    PSZ  pszFSDName;
    PSZ prgFSAData;

    pszFSDName=pBuf->szName+pBuf->cbName+1;
    prgFSAData=pszFSDName+pBuf->cbFSDName+1;
    SysWriteToTrapLog("  %s, %s\n", pBuf->szName, pszFSDName, prgFSAData);

    //    if(pBuf->iType==FSAT_REMOTEDRV)
    //     ulDisk=QDT_REMOTE_DRIVE;
  }
  return TRUE;
}
void isCD2(ULONG ulDriveNum) {
  char chrPlayerID[100];
  ULONG rc;
  HFILE hFile;
  
  /* Check if it's an audio CD */
  sprintf(chrPlayerID, "%c:", 'A'+ulDriveNum-1);
  if((hFile=openDrive(chrPlayerID))!=NULLHANDLE) {
    int iNumTracks;
	ULONG ulParamLen;
	ULONG ulDataLen;
    ULONG ulData;

	ulParamLen=4;
	ulDataLen=sizeof(ulData);
	rc = DosDevIOCtl(hFile, IOCTL_CDROMDISK, CDROMDISK_DEVICESTATUS,
						  "CD01", 4, &ulParamLen, &ulData,
						  sizeof(ulData), &ulDataLen);
    if(!rc)
      SysWriteToTrapLog("%d: NO_ERROR, ", ulDriveNum);
    else
      SysWriteToTrapLog("%d: ERROR, ", ulDriveNum);
    closeDrive(hFile);
    return;
  }
  SysWriteToTrapLog("%d: Open drive failed, ", ulDriveNum);
}
#endif

SOM_Scope BOOL  SOMLINK cwmmdisk_wpFree(CWMMDisk *somSelf)
{
    /* CWMMDiskData *somThis = CWMMDiskGetData(somSelf); */
    CWMMDiskMethodDebug("CWMMDisk","cwmmdisk_wpFree");

    invalidateDriveInList(_wpQueryLogicalDrive(somSelf));
    return (CWMMDisk_parent_WPDisk_wpFree(somSelf));
}

SOM_Scope void  SOMLINK cwmmdisk_wpObjectReady(CWMMDisk *somSelf, 
                                               ULONG ulCode, 
                                               WPObject* refObject)
{
  ULONG ulDrive;

    /* CWMMDiskData *somThis = CWMMDiskGetData(somSelf); */
    CWMMDiskMethodDebug("CWMMDisk","cwmmdisk_wpObjectReady");

    //SysWriteToTrapLog("\nLogical drive created: %d, Type is: %x\n",
    //                _wpQueryLogicalDrive(somSelf), SysQueryDriveType(_wpQueryLogicalDrive(somSelf)));

    //   isCD2(_wpQueryLogicalDrive(somSelf));
    //   isCD(_wpQueryLogicalDrive(somSelf));

    CWMMDisk_parent_WPDisk_wpObjectReady(somSelf, ulCode, refObject);

    /*
      @@CHANGE 0.2.8
      
      Insert CD drives into a global list whenever a drive object is created.
      Remove it on destruction. This was added to support LVM systems with
      dynamically attached USB CD-ROM drives.
      */
    ulDrive=_wpQueryLogicalDrive(somSelf);
    if(ulDrive>2) /* Don't check floppies */
      checkForCDDrive(ulDrive); /* This call inserts CD drives into a global list so
                                   the entry is cached. It will be removed during processing of wpFree(). */

}


SOM_Scope PSZ  SOMLINK cwmmdiskM_wpclsQueryTitle(M_CWMMDisk *somSelf)
{
    /* M_CWMMDiskData *somThis = M_CWMMDiskGetData(somSelf); */
    M_CWMMDiskMethodDebug("M_CWMMDisk","cwmmdiskM_wpclsQueryTitle");

    return "CWMMDisk";
    /*    return (M_CWMMDisk_parent_M_WPDisk_wpclsQueryTitle(somSelf));*/
}





