/*
 * (C) Chris Wohlgemuth 2002-2004
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */          
/*
 * If you need another license for your project/product (commercial,
 * noncommercial, whatever) contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 *
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwm3u_Source
#define SOM_Module_cwm3u_Source
#endif
#define MMM3U_Class_Source
#define M_MMM3U_Class_Source

#define INCL_PM

#define INCL_DOS
#define INCL_DOSERRORS

#include <os2.h>
#include <stdio.h>
#include "cwm3u.ih"
#include "cwaudioinc.h"
//#include "cwmmres.h"
#include "mmres.h"
#include "except.h"
#include "wpfolder.h"

#include "som_wps_funcs.h"

HMODULE queryResModuleHandle(void);
HMODULE queryModuleHandle(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView);
void HlpWriteToTrapLog(const char* chrFormat, ...);
BOOL mmclsCreateTheDefaultTemplate(M_WPObject *somSelf, 
                                   WPObject* Folder);
PSZ _queryMp3HelpLibraryName(void);


SOM_Scope BOOL  SOMLINK cwm3u_wpModifyPopupMenu(MMM3U *somSelf, 
                                                HWND hwndMenu, 
                                                HWND hwndCnr, 
                                                ULONG iPosition)
{
    /* MMM3UData *somThis = MMM3UGetData(somSelf); */
    MMM3UMethodDebug("MMM3U","cwm3u_wpModifyPopupMenu");

    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_M3UPLAYER, 1);
    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_M3UEDITOR, 1);
    return (MMM3U_parent_CWMMDataFile_wpModifyPopupMenu(somSelf, 
                                                      hwndMenu, 
                                                      hwndCnr, 
                                                      iPosition));
}

SOM_Scope BOOL  SOMLINK cwm3u_wpMenuItemSelected(MMM3U *somSelf, 
                                                 HWND hwndFrame, 
                                                 ULONG ulMenuId)
{
    /* MMM3UData *somThis = MMM3UGetData(somSelf); */
    MMM3UMethodDebug("MMM3U","cwm3u_wpMenuItemSelected");
    switch(ulMenuId)
      {
      case ID_MENU_M3UEDITOR:
        _wpViewObject(somSelf, NULLHANDLE, ulMenuId, 0);
        return TRUE;
      case ID_MENU_M3UPLAYER:
        _wpViewObject(somSelf, NULLHANDLE, ulMenuId, 0);
        return TRUE;
      default:
        break;
      }

    return (MMM3U_parent_CWMMDataFile_wpMenuItemSelected(somSelf, 
                                                       hwndFrame, 
                                                       ulMenuId));
}


MRESULT EXPENTRY m3uFolderCloseHandlerProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_TIMER:
      {
        MMDATAFILEVIEW *pParams=(MMDATAFILEVIEW*)WinQueryWindowULong(hwnd, QWL_USER);
        WPObject*somSelf;

        WinStopTimer(WinQueryAnchorBlock(HWND_DESKTOP), hwnd, 1);        
        somSelf=pParams->thisPtr;
        /* Destroy folder */
        _wpFree(pParams->wpObject);
        _wpFreeMem(somSelf, (PBYTE)pParams);
        WinDestroyWindow(hwnd);
      }
      return MRFALSE;
    case WM_APPTERMINATENOTIFY:
      {
        MMDATAFILEVIEW *pParams=(MMDATAFILEVIEW*)WinQueryWindowULong(hwnd, QWL_USER);
        WPObject*somSelf;
        
        somSelf=pParams->thisPtr;
        _wpDeleteFromObjUseList(somSelf, &pParams->useItem);
        WinStartTimer(WinQueryAnchorBlock(HWND_DESKTOP), hwnd, 1, 1000);
        return MRFALSE;
      }
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}


SOM_Scope HWND  SOMLINK cwm3u_wpOpen(MMM3U *somSelf, HWND hwndCnr, 
                                     ULONG ulView, ULONG param)
{
  ULONG ulRc;
    /* MMM3UData *somThis = MMM3UGetData(somSelf); */
    MMM3UMethodDebug("MMM3U","cwm3u_wpOpen");

    switch(ulView)
      {
      case ID_MENU_M3UEDITOR:
        /* case 0xbc2d:  Editor */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+10]="\"";
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;
          WPObject* wpObject;
          WPFolder *wpFolder;

          if(!getMessage(chrTitle, IDSTR_M3UEDITORTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Playlist editor");

          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");

          /* Check for user setting */
          if(PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "m3ueditor", NULLHANDLE, chrPlayer,sizeof(chrPlayer))) {
            if((ulRc=launchPMProg( chrTitle, chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE)
              break; /* Use System default (E.EXE) */
            return NULLHANDLE;
          }

          /* Create and open M3U folder */
          wpFolder=_wpclsQueryFolder(_WPFolder, "<WP_NOWHERE>", FALSE);
          if(somIsObj(wpFolder))
            {
              SOMClass* somClass;

              ulSize=sizeof(chrPlayer);
              /* Get name of M3U file */
              _wpQueryRealName(somSelf, chrPlayer, &ulSize, FALSE);
              somClass=somGetSomClass("CWM3UFolder");

              if(!somIsObj(somClass))
                somClass=somGetSomClass("CWM3UFolder");

              if(somIsObj(somClass))
                 wpObject=_wpclsNew(somClass, chrPlayer, "", 
                                    wpFolder,FALSE);
              else
                break;

              if(somIsObj(wpObject)) {
                 HWND hwnd;
                /* Send the handle of the M3U-File to the M3U folder. */
                sprintf(chrPlayer, "M3UOBJECTHANDLE=%ld;", somSelf);
                _wpSetup(wpObject, chrPlayer);

                if((hwnd=_wpViewObject(wpObject, NULLHANDLE, OPEN_DEFAULT, 0))!=NULLHANDLE) {
                  HWND hwndAppTerminateHandler;
                  /* Folder opened. Add the object to inuse list. */
                  ULONG ulError;
                  MMDATAFILEVIEW *pParams=(MMDATAFILEVIEW*)_wpAllocMem(somSelf,sizeof(MMDATAFILEVIEW), &ulError);
                  
                  if(pParams) {
                    /* Create an object window which will process the WM_APPTERMINATE message. While processing of this
                       message the view item (see below) will be removed from the inuse list thus removing the inuse emphasis. */
                    hwndAppTerminateHandler=WinCreateWindow(HWND_OBJECT,WC_STATIC,"CWMMAppTerminate",0,0,0,0,0,
                                                            NULLHANDLE,HWND_BOTTOM,13344,NULL,NULL);
                    if(hwndAppTerminateHandler) {
                      WinSubclassWindow(hwndAppTerminateHandler,&m3uFolderCloseHandlerProc);
                      sprintf(chrPlayer, "M3UOBJECTWINDOW=%ld;", 
                              hwndAppTerminateHandler);
                      _wpSetup(wpObject, chrPlayer);
                    }
                    /* We have memory */
                    memset((void*)pParams ,0, sizeof(MMDATAFILEVIEW));
                    pParams->pid=0;
                    pParams->thisPtr=somSelf; /* The object */
                    pParams->viewItem.view=ulView; /* The open view */
                    pParams->useItem.type=USAGE_OPENVIEW; /* We add a view item to the inus list */
                    pParams->viewItem.handle=hwnd; /* */
                    pParams->wpObject=wpObject;
                    _wpAddToObjUseList(somSelf, &pParams->useItem); /* add to inuse list */
                    WinSetWindowULong(hwndAppTerminateHandler, QWL_USER,(ULONG)pParams);
                    return hwnd;
                  }/* pParams */
                }/* wpViewObject() */
                _wpFree(wpObject);
              }/* somIsObj() */
            }/* somIsObj(wpFolder) */
          /* No M3U folder. Open E.EXE as fallback. */
          launchPMProg( chrTitle, "e.exe", chrParams, somSelf, ulView);
          break;
        }
      case ID_MENU_M3UPLAYER:
        /* case 0xbc2d:  player */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+10]="\"";
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;
          WPObject* wpObject;
          WPFolder *wpFolder;

          if(!getMessage(chrTitle, IDSTR_AUDPLAYERTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Player");

          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");

          /* Check for user setting */
          if(PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "m3uplayer", NULLHANDLE, chrPlayer,sizeof(chrPlayer))) {
            if((ulRc=launchPMProg( chrTitle, chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE)
              break; /* Use System default (E.EXE) */
            return NULLHANDLE;
          }

          /* Create and open M3U folder */
          wpFolder=_wpclsQueryFolder(_WPFolder, "<WP_NOWHERE>", FALSE);
          if(somIsObj(wpFolder))
            {
              SOMClass* somClass;

              ulSize=sizeof(chrPlayer);
              /* Get name of M3U file */
              _wpQueryRealName(somSelf, chrPlayer, &ulSize, FALSE);
              somClass=somGetSomClass("CWMediaFolder");

              if(!somIsObj(somClass))
                somClass=somGetSomClass("CWMediaFolder");

              if(somIsObj(somClass))
                 wpObject=_wpclsNew(somClass, chrPlayer, "", 
                                    wpFolder,FALSE);
              else
                break;

              if(somIsObj(wpObject)) {
                 HWND hwnd;
                /* Send the handle of the M3U-File to the M3U folder. */
                sprintf(chrPlayer, "M3UOBJECTHANDLE=%ld;", somSelf);
                _wpSetup(wpObject, chrPlayer);

                /* Open folder */
                if((hwnd=_wpViewObject(wpObject, NULLHANDLE, OPEN_DEFAULT, 0))!=NULLHANDLE) {
                  HWND hwndAppTerminateHandler;
                  /* Folder opened. Add the object to inuse list. */
                  ULONG ulError;
                  MMDATAFILEVIEW *pParams=(MMDATAFILEVIEW*)_wpAllocMem(somSelf,sizeof(MMDATAFILEVIEW), &ulError);
                  
                  if(pParams) {
                    /* Create an object window which will process the WM_APPTERMINATE message. While processing of this
                       message the view item (see below) will be removed from the inuse list thus removing the inuse emphasis. */
                    hwndAppTerminateHandler=WinCreateWindow(HWND_OBJECT,WC_STATIC,"CWMMAppTerminate",0,0,0,0,0,
                                                            NULLHANDLE,HWND_BOTTOM,13344,NULL,NULL);
                    if(hwndAppTerminateHandler) {
                      WinSubclassWindow(hwndAppTerminateHandler,&m3uFolderCloseHandlerProc);
                      sprintf(chrPlayer, "M3UOBJECTWINDOW=%ld;", 
                              hwndAppTerminateHandler);
                      _wpSetup(wpObject, chrPlayer);
                    }
                    /* We have memory */
                    memset((void*)pParams ,0, sizeof(MMDATAFILEVIEW));
                    pParams->pid=0;
                    pParams->thisPtr=somSelf; /* The object */
                    pParams->viewItem.view=ulView; /* The open view */
                    pParams->useItem.type=USAGE_OPENVIEW; /* We add a view item to the inus list */
                    pParams->viewItem.handle=hwnd; /* */
                    pParams->wpObject=wpObject;
                    _wpAddToObjUseList(somSelf, &pParams->useItem); /* add to inuse list */
                    WinSetWindowULong(hwndAppTerminateHandler, QWL_USER,(ULONG)pParams);
                    sprintf(chrPlayer, "INSERTTRACKS=1;");
                    _wpSetup(wpObject, chrPlayer);
                    return hwnd;
                  }/* pParams */
                }/* wpViewObject() */
                _wpFree(wpObject);
              }/* somIsObj() */
            }/* somIsObj(wpFolder) */
          /* No M3U folder. Open E.EXE as fallback. */
          launchPMProg( chrTitle, "e.exe", chrParams, somSelf, ulView);
          break;
        }

      default:
        break;
      }
    return (MMM3U_parent_CWMMDataFile_wpOpen(somSelf, hwndCnr, 
                                           ulView, param));
}


SOM_Scope void  SOMLINK cwm3u_wpCopiedFromTemplate(MMM3U *somSelf)
{
    /* MMM3UData *somThis = MMM3UGetData(somSelf); */
    MMM3UMethodDebug("MMM3U","cwm3u_wpCopiedFromTemplate");

    MMM3U_parent_CWMMDataFile_wpCopiedFromTemplate(somSelf);

    _wpViewObject(somSelf, NULLHANDLE, OPEN_DEFAULT, 0);
}


/*
 *    wpclsQueryInstanceFilter    : override;
 */
SOM_Scope PSZ  SOMLINK cwm3uM_wpclsQueryInstanceType(M_MMM3U *somSelf)
{
    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsQueryInstanceType");

    //    return "M3U,Plain Text";
    return TYPE_M3U;
}

SOM_Scope PSZ  SOMLINK cwm3uM_wpclsQueryInstanceFilter(M_MMM3U *somSelf)
{
    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsQueryInstanceFilter");

    return "*.M3U";
}

SOM_Scope BOOL  SOMLINK cwm3uM_wpclsQueryDefaultHelp(M_MMM3U *somSelf, 
                                                     PULONG pHelpPanelId, 
                                                     PSZ pszHelpLibrary)
{
  PSZ pszHelpLibName;

    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsQueryDefaultHelp");


    if((pszHelpLibName=_queryMp3HelpLibraryName())!=NULLHANDLE)
      {
        if(pHelpPanelId)
          *pHelpPanelId=M3UFILE_HELP_PANEL;
        if(pszHelpLibrary)
          strncpy(pszHelpLibrary, pszHelpLibName, CCHMAXPATH);
        return TRUE; 
      }

    return (M_MMM3U_parent_M_CWMMDataFile_wpclsQueryDefaultHelp(somSelf, 
                                                           pHelpPanelId, 
                                                           pszHelpLibrary));
}

SOM_Scope PSZ  SOMLINK cwm3uM_wpclsQueryTitle(M_MMM3U *somSelf)
{
  static char chrTitle[20]={0};
    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_M3UTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle, CLSTITLE_M3U);

    return chrTitle;
}

SOM_Scope ULONG  SOMLINK cwm3uM_wpclsQueryIconData(M_MMM3U *somSelf, 
                                                   PICONINFO pIconInfo)
{
  HMODULE hmod;
    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsQueryIconData");

    hmod=queryModuleHandle();
    if(!hmod)
      return M_MMM3U_parent_M_CWMMDataFile_wpclsQueryIconData(somSelf, pIconInfo);

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = hmod;
      pIconInfo->resid   = ID_ICONM3UFILE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}


SOM_Scope ULONG  SOMLINK cwm3uM_wpclsQueryDefaultView(M_MMM3U *somSelf)
{
    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsQueryDefaultView");

    return ID_MENU_M3UEDITOR;
}


SOM_Scope BOOL  SOMLINK cwm3uM_wpclsCreateDefaultTemplates(M_MMM3U *somSelf, 
                                                           WPObject* Folder)
{
    /* M_MMM3UData *somThis = M_MMM3UGetData(somSelf); */
    M_MMM3UMethodDebug("M_MMM3U","cwm3uM_wpclsCreateDefaultTemplates");

    mmclsCreateTheDefaultTemplate(somSelf, Folder);
    return TRUE;
}

