
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.47
 */


/*
 * (C) Chris Wohlgemuth 2002-2004
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */          
/*
 * If you need another license for your project/product (commercial,
 * noncommercial, whatever) contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 *
 */
/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwimage_Source
#define SOM_Module_cwimage_Source
#endif
#define CWImage_Class_Source
#define M_CWImage_Class_Source

#define INCL_DOS
#define INCL_DOSSEMAPHORES
#define INCL_DOSERRORS
#define INCL_GPI
#define INCL_PM
#define INCL_MMIOOS2
#include <os2.h>
#include <stdio.h>
#include "mmioos2.h"
#include "cwimage.ih"
#include "mmres.h"
#include "except.h"
#include "cwaudioinc.h"

#include "sys_funcs.h"

//#define DEBUG

char notImplementedMsg[]= {"\nMethod not available while processing file %s: %s, file %s, around line %d.\n"};

/* Set some default titles */
PSZ pszImageColTitles[NUM_IMAGE_DETAILS_FIELDS]= {"Width", "Height", "Depth", "Format"};

char chrWidth[SIZE_TITLE]="";
char chrHeight[SIZE_TITLE]="";
char chrDepth[SIZE_TITLE]="";
char chrFormat[SIZE_TITLE]="";

CLASSFIELDINFO cfiImageFieldInfo[NUM_IMAGE_DETAILS_FIELDS];

/* Some methods are not yet implemented */
#define NOT_IMPLEMENTED  DosBeep(1000, 100);\
                         DosBeep(2000, 100);\
                         DosBeep(3000, 100);\
                         DosBeep(4000, 100);\
                         DosBeep(3000, 100);\
                         DosBeep(2000, 100);\
                         DosBeep(1000, 100);\
                         SysWriteToTrapLog(notImplementedMsg,\
                                           _wpQueryTitle(somSelf), __FUNCTION__, __FILE__, __LINE__);


extern HAB globalHab;
HWND hwndCreateBMP; /* Object window for small bitmap creation */
HWND g_hwndDeleteBMP; /* Object window for bitmap deletion */

extern char classDLLPath[CCHMAXPATH];
extern char chrHelpLibrary[CCHMAXPATH];
PMMFORMATINFO g_pmmFormatInfoArray=NULLHANDLE;
LONG          lNumIOProcs=0;/* Needed to know how many convert menus we have */

char chrMMImageKnownExt[320]={0};/* Array holding the extensions we have a class for e.g. JPG. This
                                    array will be filled using an external REXX script. Space for
                                    80 ext should be enough for now (4 bytes per ext e.g.: "JPG "<- note the space) */
char chrMMImageExt[200]={0};/* Array holding the extensions for wpclsQueryInstanceFilter(). Will be
                               filled during processing of wpclsInitData() */


ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView);

BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
ULONG messageBox( char* text, ULONG ulTextID , LONG lSizeText,
                  char* title, ULONG ulTitleID, LONG lSizeTitle,
                  HMODULE hResource, HWND hwnd, ULONG ulFlags);

void writeLog(char* chrFormat, ...);
HMODULE queryResModuleHandle(void);
HMODULE queryModuleHandle(void);
PSZ queryModuleName(void);

BOOL getBmpInfoHeader(PBITMAPINFOHEADER2  bmpih2, PSZ pszFileName, char* procName, ULONG ulLength, BOOL * bNoIOProcAvailable);
HBITMAP loadBitmap ( PSZ pszFileName, PBITMAPINFOHEADER2 pBMPInfoHeader2);
HBITMAP createNewBitmap ( HBITMAP hbm,
                          PBITMAPINFOHEADER2 pBmpInfoHeader2,
                          ULONG ulWidth, 
                          ULONG ulHeight, 
                          BOOL* pbQuitEarly);

ULONG showMsgBox2(ULONG ulIDTitle, ULONG ulIDText, HMODULE hModule, ULONG ulFlag);
ULONG showMsgBox(ULONG ulIDTitle, ULONG ulIDText, HMODULE hModule);
BOOL cwObjectIsOnCD(WPObject * somSelf);
BOOL getStringFromRexxScript(PSZ rexxFile, char* chrResult, ULONG ulSize);

BOOL mmclsCreateTheDefaultTemplate(M_WPObject *somSelf, 
                                   WPObject* Folder);

MRESULT menuInsertMenuSeparator(HWND hwndMenu, HWND hwndSubMenu, SHORT sPosition );

/* 
   This Proc creates the small bitmaps for display on a separate thread.
   It's used indirectly used by the lighttable folder when an attempt to
   paint the bitmap is made. It will also generate bmps when WPS-wizard wants
   to paint icons in the container.
 */
MRESULT EXPENTRY createBMPObjectProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case WM_APPTERMINATENOTIFY:
      {
        switch(SHORT2FROMMP(mp2))
          {
          case ACKEY_CREATE_SMALLBITMAP:
            {
              BOOL bLoaded=FALSE;
              HBITMAP hbm;
              PCREATEBMPINFO pCreateBMP=PVOIDFROMMP(mp1);
              MMImageData *somThis;
              WPObject *wpObject;
              PMINIRECORDCORE pmrcToRefresh;

              if(!pCreateBMP)
                return (MRESULT) FALSE;
#ifdef DEBUG
              SysWriteToTrapLog("In %s, line %d\n", __FUNCTION__, __LINE__);
#endif

              if(!somIsObj(pCreateBMP->wpObject))
                return (MRESULT) FALSE;

              /* 
                 V0.2.8, CW 2004/11/01 
                 
                 It's possible that a lot of requests are issued to this thread while opening a folder.
                 These are qeued and in the meanwhile the user may have closed the folder.
                 */
              if(!WinIsWindow(globalHab, pCreateBMP->hwndCnr))
                return MRFALSE;


              TRY_LOUD(BITMAP_OBJECT) {
                somThis  = MMImageGetData(pCreateBMP->wpObject);
                pmrcToRefresh=pCreateBMP->pmrcToRefresh;
                for(;;) {
                  RECTL rectl, rectl2;
                  if(WinSendMsg(pCreateBMP->hwndCnr, CM_QUERYVIEWPORTRECT, MPFROMP(&rectl2), MPFROM2SHORT(CMA_WORKSPACE, FALSE))) {

                    /*
                      V0.2.8 CW 2004/11/01

                      Only create small bitmaps for icons currently visible in the container. This is useful if the
                      user scrolls a folder and not every small bitmap is yet created.
                     */
                    if(pmrcToRefresh->ptlIcon.y+40 < rectl2.yBottom || pmrcToRefresh->ptlIcon.y > rectl2.yTop)
                      break;
                    if(pmrcToRefresh->ptlIcon.x+40 < rectl2.xLeft || pmrcToRefresh->ptlIcon.x > rectl2.xRight)
                      break;
                  }/* WinSendMsg() */

                  _wpLockObject(pCreateBMP->wpObject);
                  
                  /* Check if in the meantime the bitmap was created */
                  if(!_hBitmapSmall) {
                    /* 
                       FIXME:
                       
                       Not threadsafe!!!
                       
                       Use a private work alike for wpQueryBitmapHandle instead???
                       
                       Check if bitmap data already loaded. Keep the info so we don't discard the bitmap later on. Another
                       function may have requested the bitmap before. During wpQueryBitmapHandle() a normal size bitmap
                       is always created. We don't want to have memory wasted by the big one so it's discarded afterwards.
                       Not perfect, but works at the moment. Will be revamped later with automatic bitmap deletion. */
                    if(_hBitmap)
                      bLoaded=TRUE;
                    
                    if(_wpQueryBitmapHandle(pCreateBMP->wpObject, 
                                            &hbm, 
                                            NULLHANDLE,
                                            pCreateBMP->ulWidth, 
                                            pCreateBMP->ulHeight, 
                                            0, /* ulFlags*/ 
                                            0, 
                                            NULLHANDLE)) {
                      _hBitmapSmall=hbm;
                      _ulSizeSmallBitmap=pCreateBMP->ulHeight;
                      if(!bLoaded) {
                        /* The bitmap wasn't loaded so discard it now, we don't need it any more as we have
                           the small one. */
                        GpiDeleteBitmap(_hBitmap);
                        _hBitmap=NULLHANDLE;
                      }
                    }/* _wpQueryBitmapHandle() */
                  }
                  if(WinIsWindow(globalHab, pCreateBMP->hwndCnr) && pmrcToRefresh)
                    //    WinPostMsg(pCreateBMP->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pmrcToRefresh),MPFROM2SHORT(1,CMA_NOREPOSITION));
                    WinSendMsg(pCreateBMP->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pmrcToRefresh),MPFROM2SHORT(1,CMA_NOREPOSITION));
                  
                  _wpUnlockObject(pCreateBMP->wpObject);
                  break;
                }/* for */
              }/* Try */
              CATCH(BITMAP_OBJECT)
                {
                  SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d.\n",
                                    __FUNCTION__, __FILE__, __LINE__);
                  _wpUnlockObject(pCreateBMP->wpObject); /* If we trapped in wpUnlockObject(), we will have a problem here... */
                } END_CATCH;
                //        WinSendMsg(pCreateBMP->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pmrcToRefresh),MPFROM2SHORT(1,CMA_NOREPOSITION));
                //   _wp_FreeMem(wpObject, (PBYTE)pCreateBMP);
                free((PBYTE)pCreateBMP);

                return (MRESULT) FALSE;
            }/* case ACKEY_CREATE_SMALLBITMAP */
          case ACKEY_QUERY_BITMAPINFO:
            {
              PCREATEBMPINFO pCreateBMP=PVOIDFROMMP(mp1);
              MMImageData *somThis;

              if(!pCreateBMP)
                return (MRESULT) FALSE;
              if(!somIsObj(pCreateBMP->wpObject))
                return (MRESULT) FALSE;

              TRY_LOUD(BITMAPIH_OBJECT) {          
                somThis  = MMImageGetData(pCreateBMP->wpObject);
                                
                /* Check if in the meantime the bitmap was created */
                if(!_pBmpInfoHeader2) {
                  _pBmpInfoHeader2=_wpQueryBitmapInfoHeader(pCreateBMP->wpObject);
                  /* Make sure the image size is cached in the EA */
                  if(_pBmpInfoHeader2)
                    _wpSaveDeferred(pCreateBMP->wpObject);
                }
              }/* Try */
              CATCH(BITMAPIH_OBJECT)
                {
                  SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while getting BMPINFOHEADER.\n",
                                    __FUNCTION__, __FILE__, __LINE__);
                } END_CATCH;
              return (MRESULT) FALSE;
            }
          default:
            break;
          }/* switch(SHORT2FROMMP(mp2)) */
        return (MRESULT) FALSE;
      }/* case WM_APPTERMINATENOTIFY */
    default:
      break;
    }
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

/*

  This thread is started in cwimgM_wpclsInitData(M_MMImage *somSelf). It will create small bitmaps and reads
  in the BITMAPINFOHEADER.

*/
void _Optlink createBMPThreadFunc (void *arg)
{

  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  
  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab, 50);
    if(hmq) {
      hwndCreateBMP=WinCreateWindow(HWND_OBJECT,WC_STATIC,"coverObj",0,0,0,0,0,NULLHANDLE,HWND_BOTTOM,13343,NULL,NULL);
      if(hwndCreateBMP) {
        WinSubclassWindow(hwndCreateBMP,&createBMPObjectProc);
        /* Window created. */
        while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))
          WinDispatchMsg(hab,&qmsg);
        WinDestroyWindow(hwndCreateBMP);
      }
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
}

ULONG ulNumBMPDelete=0;
#define IMGWM_DELETEBITMAP WM_USER+10

MRESULT EXPENTRY deleteBMPObjectProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{

  switch (msg)
    {
    case IMGWM_DELETEBITMAP:
      {
        MMImage* somSelf=PVOIDFROMMP(mp1);
        if(somIsObj(somSelf)) {
#if 0
          if(!_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE)) {
            _cwmmFreeBitmaps(somSelf);
            //DosBeep(5000, 20);
          }
#endif
          // DosBeep(5000, 10);
          _cwmmFreeBitmaps(somSelf);
          //SysWriteToTrapLog("Object is locked: %d\n", _wpIsLocked(somSelf));
          /* Decrease delete request count */
          ulNumBMPDelete--;
          //    SysWriteToTrapLog("Num requests left: %d\n", ulNumBMPDelete);
        }
        return FALSE;
        
      }
    default:
      break;
    } /* msg */
  return WinDefWindowProc( hwnd, msg, mp1, mp2);
}

#define BMP_QUEUE_SIZE 100
#define BMP_DEL_UPPER  80 /* If number of delete request reaches this the thread is unlocked */
#define BMP_DEL_LOWER  50 /* After reaching this number of requests the thread goes back to sleep until the timeout comes. */
#define BMP_DEL_WAITTIME 10000 /* Default sleeptime of the thread thus checking for new delete requests with this interval */
#define BMP_DEL_MINAGE   8000 /* Min age of message before bitmaps are actually destroyed in the background */

HEV hevDeleteBMP;

/*

  This thread is started in cwimgM_wpclsInitData(M_MMImage *somSelf).

  This is the poor man's bitmap deletion thread. It wakes up every BMP_DELWAITTIME ms and
  deletes bitmaps which are at least BMP_DELMINAGE ms not used.

  It will not reorder messages and will not remove duplicates (hence poor man's). So the
  oldest delete request will be fullfilled even if in the meantime the bitmap was used and
  a new request issued. Anyway bitmaps will NOT be destroyed, if the file is inserted into a
  container! But overall it's way better than immediately delete BMPs after use because when
  closing a folder maybe dozens of bitmaps must be removed at once.

*/
void _Optlink deleteBMPThreadFunc (void *arg)
{

  HAB  hab;
  HMQ  hmq;
  QMSG qmsg;
  BOOL bSemCreated;
  ULONG ulWaitTime=BMP_DEL_WAITTIME;

  hab=WinInitialize(0);
  if(hab) {
    hmq=WinCreateMsgQueue(hab, BMP_QUEUE_SIZE);
    if(hmq) {
      g_hwndDeleteBMP=WinCreateWindow(HWND_OBJECT,WC_STATIC,"delBMPObj",0,0,0,0,0,NULLHANDLE,HWND_BOTTOM,13343,NULL,NULL);
      if(g_hwndDeleteBMP) {
        WinSubclassWindow(g_hwndDeleteBMP,&deleteBMPObjectProc);
        /* Lower priority to idle -5. Memory clean up shouldn't disturb the user */
        //    DosSetPriority(PRTYS_THREAD, PRTYC_IDLETIME, -5, 0);

        /* Create event semaphore. This thread normally waits on this semaphore for several minutes. After the
           timeout it fetches a pending msg and deletes the bitmap. If a lot of deletion request are sent, the
           sending function posts the semaphore before the timeout and the oldest requests are handled immediately.

           The semaphore is reset when created.
           */
        bSemCreated=!DosCreateEventSem(NULL, &hevDeleteBMP, 0, FALSE);
        /* Window created. Wait for msg. */
        while(WinGetMsg(hab,&qmsg,(HWND)NULL,0,0)) {
          BOOL bQuit = FALSE;

          //    SysWriteToTrapLog("\n\nGot first msg...\n");

          /* First message is always dispatched no matter how old */
          WinDispatchMsg(hab,&qmsg);

          if(bSemCreated) {
            ULONG ulPostCount;
            BOOL bTimeError=FALSE;

            //SysWriteToTrapLog("Waiting on semaphore...\n");

            if(DosWaitEventSem(hevDeleteBMP, ulWaitTime)==ERROR_TIMEOUT) {
              ULONG ulTime=WinGetCurrentTime(hab);

              //SysWriteToTrapLog("Sem timeout\n");

              //ulPostCount=0; /* only debug */
              /* Check for pending messages */
              while(WinPeekMsg(hab,&qmsg,(HWND)NULL,0,0, PM_NOREMOVE)) {

                //ulPostCount++;
                //SysWriteToTrapLog("  Have msg %d\n", ulPostCount);
                
                /*
                  Check for system msgs and dispatch them.
                 */
                if(qmsg.msg!=IMGWM_DELETEBITMAP) {
                  /* Get the message and quit if it's WM_QUIT (shouldn't happen though) */
                  if((bQuit=!WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))==TRUE)
                    break;
                  /* else dispatch and continue loop */
                  WinDispatchMsg(hab,&qmsg);
                  continue;
                }
                bTimeError=FALSE;
                if(ulTime-qmsg.time > BMP_DEL_MINAGE) {
                  /* The message is old enough so get it and dispatch */
                  //  SysWriteToTrapLog("  time > BMP_DEL_MINAGE\n");
                  WinGetMsg(hab,&qmsg,(HWND)NULL,0,0);
                  WinDispatchMsg(hab,&qmsg);
                  //  SysWriteToTrapLog("Dispatched, next msg?\n");
                  ulWaitTime=BMP_DEL_WAITTIME;
                }
                else {
                  /* Message isn't old so wait until wait time is really over */
                  //  SysWriteToTrapLog("  time to short!!!\n");
                  ulWaitTime=BMP_DEL_WAITTIME-(ulTime-qmsg.time);
                  bTimeError=TRUE;
                  break;
                }
                //                SysWriteToTrapLog("Back to inner while...\n");
              }/* while */
              /*
                FIXME:

                Make ist right and robust!

                Set counter to 0 if all messages are handled. This isn't correct, because it's not thread safe
                but doesn't matter that much. In the worst case some messages are dispatched later but
                it's not system critical at all. In wpUninitData() the bitmaps are deleted anyway.
                */
              if(!bTimeError)
                ulNumBMPDelete=0; /* No messages in queue (but maybe another thread is just adding them...) */
            } /* semaphore timeout */
            else
              {
                /*
                  queue is almost full. The semaphore was posted by the function so
                  dispatch messages faster. 
                 */
                int a=0;
                //                SysWriteToTrapLog(" --Semaphore posted\n");
                while((bQuit=!WinGetMsg(hab,&qmsg,(HWND)NULL,0,0))==FALSE 
                      && a < BMP_DEL_UPPER-BMP_DEL_LOWER) {
                  //     SysWriteToTrapLog(" -- Got message, dispatching it...\n");
                  if(qmsg.msg==IMGWM_DELETEBITMAP)
                    a++;
                  WinDispatchMsg(hab,&qmsg);
                  //    SysWriteToTrapLog("--Dispatching msg %d\n", a);
                }/* while */
                ulWaitTime=BMP_DEL_WAITTIME;
              }
            //  if(WinQueryQueueInfo(hmq, &mqi, sizeof(MQINFO)))
            //     SysWriteToTrapLog("WinQueryQueueInfo succeeded.\n");
            //  if(!mqi.cmsgs)
            //  ulNumBMPDelete=mqi.cmsgs;
            //      SysWriteToTrapLog("Now resetting event semaphore\n");

            DosResetEventSem(hevDeleteBMP, &ulPostCount);
          }/* bSemCreated */
          if(bQuit)
            break;
        }/* while() */

        DosCloseEventSem(hevDeleteBMP);
        WinDestroyWindow(g_hwndDeleteBMP);
      }
      WinDestroyMsgQueue(hmq);
    }
    WinTerminate(hab);
  }
}

void sendDeleteBMPMsg(MMImage* somSelf)
{
  PUSEITEM pui;
  /*
    Unfortunately only bitmaps for real files are currently deleted. When using links in folders
    the lock counter isn't touched so we don't get a notification.
    _wpUnlockObject isn't called when links are going dormant (do they?) after closing the links folder.

    BTW XWorkplace (V1.0.0) keeps every object locked
    after first touching it and NEVER completely unlocks it!
    */
  //  SysWriteToTrapLog("Out side - %s %d\n", __FUNCTION__, ulNumBMPDelete);
  if((pui=_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE))==NULLHANDLE) {
    /* Check if queue is full. If yes post semaphore so the other thread cleans up. */
    if(ulNumBMPDelete> BMP_DEL_UPPER) {
      //        SysWriteToTrapLog("   ---> Posting semaphore...\n");
      DosPostEventSem(hevDeleteBMP);
      /* Yield cpu so the delete thread may run */
      DosSleep(20);
      /* Thread isn't fast enough so delete the bitmap directly */
      if(ulNumBMPDelete>BMP_QUEUE_SIZE-7) {
        _cwmmFreeBitmaps(somSelf);
        return;
      }
    }
    ulNumBMPDelete++;
    //    SysWriteToTrapLog("%s %d\n", __FUNCTION__, ulNumBMPDelete);
    WinPostMsg(g_hwndDeleteBMP, IMGWM_DELETEBITMAP, MPFROMP(somSelf), MPFROM2SHORT(0, ACKEY_CREATE_SMALLBITMAP));
  }
}

MRESULT EXPENTRY imageInfoDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MMImage *cwImage;

  switch(msg) {
  case WM_INITDLG :
    cwImage=(MMImage*)LONGFROMMP(mp2);
    if(somIsObj(cwImage)) {
      MMImageData *somThis = MMImageGetData(cwImage);

      PBITMAPINFOHEADER2 pbmpih2;

      if((pbmpih2=(PBITMAPINFOHEADER2)_wpQueryBitmapInfoHeader(cwImage))!=NULLHANDLE)
        {
          char fName[CCHMAXPATH];
          char chrTemplate[100];

          if(pbmpih2->cbFix==sizeof(BITMAPINFOHEADER2)) {
            if(!getMessage(chrTemplate, IDSTR_SPRINTFPIXEL, sizeof(chrTemplate), 
                       queryResModuleHandle(), hwnd))
              strcpy(chrTemplate, "%d Pixel");
            sprintf(fName, chrTemplate, pbmpih2->cx);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEWIDTH),fName);
            
            sprintf(fName, chrTemplate, pbmpih2->cy);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEHEIGHT),fName);

            if(!getMessage(chrTemplate, IDSTR_SPRINTFBIT, sizeof(chrTemplate), 
                           queryResModuleHandle(), hwnd))
              strcpy(chrTemplate, "%d Bit");            
            sprintf(fName, chrTemplate, pbmpih2->cBitCount);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_COLORDEPTH),fName);
          }
          else if(pbmpih2->cbFix==sizeof(BITMAPINFOHEADER)) {
            /* We shouldn't get a BITMAPINFOHEADER here but who knows...*/
            PBITMAPINFOHEADER pbmpih=(PBITMAPINFOHEADER)pbmpih2;
            if(!getMessage(chrTemplate, IDSTR_SPRINTFPIXEL, sizeof(chrTemplate), 
                           queryResModuleHandle(), hwnd))
              strcpy(chrTemplate, "%d Pixel");
            sprintf(fName, chrTemplate,pbmpih->cx);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEWIDTH),fName);
            
            sprintf(fName, chrTemplate, pbmpih->cy);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEHEIGHT),fName);

            if(!getMessage(chrTemplate, IDSTR_SPRINTFBIT, sizeof(chrTemplate), 
                           queryResModuleHandle(), hwnd))                        
              strcpy(chrTemplate, "%d Bit");
            sprintf(fName, chrTemplate, pbmpih->cBitCount);
            WinSetWindowText(WinWindowFromID(hwnd, IDST_COLORDEPTH),fName);
          }
          
          WinSetWindowText(WinWindowFromID(hwnd, IDST_IMAGEFORMAT),_chrIOProcName);
        }
    }/* somIsObj() */
    return (MRESULT)TRUE;
    /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), 
                       WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/*!*******************************************************/
/*                                                       */
/* @@DESC                                                */
/*                                                       */
/* This instance method is called to allow the object    */
/* to add the image information page to its Settings     */
/* notebook.                                             */
/*                                                       */
/* @@USAGE                                               */
/*                                                       */
/* This method must only be called from within an        */
/* override of wpAddSettingsPages().                     */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* MMImage *somSelf input                                */
/*                                                       */
/* Pointer to the object on which the method is being    */
/* invoked.                                              */
/* :p.                                                   */
/* Points to an object of class :hp2.MMImage:ehp2..      */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* HWND hwndNotebook input                               */
/*                                                       */
/* Settings notebook handle.                             */
/*                                                       */
/* @@OVERRIDE                                            */
/*                                                       */
/* This method should always be overridden in order to   */
/* remove or replace the image information page from     */
/* the object's Settings notbook.                        */
/* :p.                                                   */
/* To remove the page from the Settings notebook, the    */
/* override method should return                         */
/* :hp1.SETTINGS_PAGE_REMOVED:ehp1. without calling the  */
/* the parent method. To replace the page with another   */
/* page, the override method should call the             */
/* wpInsertSettingsPAge method without calling the       */
/* parent method.                                        */
/*                                                       */
/* @@RETURNS                                             */
/*                                                       */
/* ULONG rc                                              */
/*                                                       */
/* :parml compact tsize=15 break=none.                   */
/* :pt.0:pd.Error occurred                               */
/* :pt.PageId :pd.Identifier for the inserted page.      */
/* :eparml.                                              */
/*                                                       */
/*!!******************************************************/
SOM_Scope ULONG  SOMLINK cwimg_cwmmAddImageInformationPage(MMImage *somSelf, 
                                                           HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  /*    MMImageData *somThis = MMImageGetData(somSelf);*/
    MMImageMethodDebug("MMImage","cwimg_cwmmAddImageInformationPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = imageInfoDlgProc;
  //The resource DLL
  pageinfo.resid = queryResModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_IMAGEINFOPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = IDDLG_GENERAL2PAGE;

  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = NULLHANDLE;
  //We have a major tab so we need a name
  /* pageName: "ISO filesystem" */
  if(!getMessage(pageName, IDSTR_IMAGEINFOPAGENAME, sizeof(pageName),  queryResModuleHandle(), hwndNotebook))
    strcpy(pageName, "~Image information");
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook
  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);

}

/*!*******************************************************/
/*                                                       */
/* @@DESC                                                */
/*                                                       */
/* This instance method is called to get a small bitmap  */
/* representing the image of this object.                */
/*                                                       */
/* @@USAGE                                               */
/*                                                       */
/* This method is called by a folder painting procedure  */
/* when the objects image must be drawn as an icon in    */
/* a folder. For example the lighttable folder uses this */
/* to get the bitmaps of image files.                    */
/* :p.                                                   */
/* This method is specifically designed for the mentioned*/
/* purpose. It is called with a pointer to the objects   */
/* container record and the container handle. If the     */
/* needed bitmap handle isn't already created, this      */
/* will be done on a separate thread and afterwards the  */
/* objects record will automatically updated with the    */
/* new image. The caller doesn't has to wait for this and*/
/* has not to repeat the call if a NULLHANDLE is         */
/* returned.                                             */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* MMImage *somSelf input                                */
/*                                                       */
/* Pointer to the object on which the method is being    */
/* invoked.                                              */
/* :p.                                                   */
/* Points to an object of class :hp2.MMImage:ehp2..      */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* ULONG ulSize      input                               */
/*                                                       */
/* Size of the bitmap.                                   */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* PMINIRECORDCORE pmrcToRefresh input                   */
/*                                                       */
/* The objects container record. This record will        */
/* automatically be refreshed when the bitmap            */
/* isn't already created.                                */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* HWND hwndCnr input                                    */
/*                                                       */
/* The container holding the object. After creating the  */
/* bitmap the icon of the object in this container will  */
/* be redrawn.                                           */
/*                                                       */
/* @@OVERRIDE                                            */
/*                                                       */
/* This method is generally not overridden.              */
/*                                                       */
/* @@RETURNS                                             */
/*                                                       */
/* HBITMAP hBitmap                                       */
/*                                                       */
/* A bitmap handle of a small bitmap usable to be drawn  */
/* as an objects representation in a folder.             */
/*                                                       */
/*!!******************************************************/
SOM_Scope HBITMAP  SOMLINK cwimg_cwmmQuerySmallBitmapHandle(MMImage *somSelf, 
                                                            ULONG ulSize, 
                                                            PMINIRECORDCORE pmrcToRefresh, 
                                                            HWND hwndCnr)
{
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_cwmmQuerySmallBitmap");

    //      SysWriteToTrapLog("In %s, line %d. ulSize: %d\n", __FUNCTION__, __LINE__, ulSize);


#ifdef DEBUG
      SysWriteToTrapLog("In %s, line %d. somself: 0x%x, ulSize: 0x%x, mrc: 0x%x, hwndCnr: 0x%x.\n",
                        __FUNCTION__, __LINE__, somSelf, ulSize, pmrcToRefresh, hwndCnr);


      //SysWriteToTrapLog("In %s, line %d. ulSize: 0x%x, mrc: 0x%x, hwndCnr: 0x%x, _bNoIOProcAvailable: 0x%x, somSelf: 0x%x,  somThis: 0x%x.\n",
      //                __FUNCTION__, __LINE__, ulSize, pmrcToRefresh, hwndCnr, _bNoIOProcAvailable, somSelf, somThis);
#endif

      if(_bNoIOProcAvailable)
        return NULLHANDLE; /* No IO-proc for this image format. Don't try again in the future. 
                            This var is set if we trapped during reading. */

      if(!_wpIsObjectInitialized(somSelf)) {
#ifdef DEBUG
      SysWriteToTrapLog("In %s, line %d Object is not initialized\n", __FUNCTION__, __LINE__);
#endif
      return NULLHANDLE;
      }
#ifdef DEBUG
      SysWriteToTrapLog("In %s, line %d\n", __FUNCTION__, __LINE__);
#endif

    if(ulSize<MAX_SIZE_SMALLBITMAP)
      ulSize=MAX_SIZE_SMALLBITMAP;

    if(ulSize>_ulSizeSmallBitmap)
      {
        if(_hBitmapSmall) {
          GpiDeleteBitmap(_hBitmapSmall);
          _hBitmapSmall=NULLHANDLE;
        }
      }

    /* 
       FIXME: use WinIsWindow() here?? 
     */
    if(!_hBitmapSmall && hwndCreateBMP) {
      ULONG ulError;
      PCREATEBMPINFO pCreateBMP;
      _ulSizeSmallBitmap=0;

      /* Allocate memory for small bitmap info for the thread */
      //      if((pCreateBMP=(PCREATEBMPINFO)_wp_AllocMem(somSelf, sizeof(CREATEBMPINFO),&ulError))==NULLHANDLE)
      if((pCreateBMP=(PCREATEBMPINFO)malloc( sizeof(CREATEBMPINFO)))==NULL)
        return NULLHANDLE;

      pCreateBMP->ulWidth=ulSize;
      pCreateBMP->ulHeight=ulSize;
      pCreateBMP->wpObject=somSelf;
      pCreateBMP->pmrcToRefresh=pmrcToRefresh;
      pCreateBMP->hwndCnr=hwndCnr;

#ifdef DEBUG
      SysWriteToTrapLog("In %s, line %d. Sending msg to create thread.\n", __FUNCTION__, __LINE__);
#endif

      WinPostMsg(hwndCreateBMP, WM_APPTERMINATENOTIFY,MPFROMP(pCreateBMP), MPFROM2SHORT(0, ACKEY_CREATE_SMALLBITMAP));
      free(pCreateBMP);
      return NULLHANDLE;
    }
    /* Return statement to be customized: */
    return _hBitmapSmall;
}


SOM_Scope void  SOMLINK cwimg_cwmmFreeBitmaps(MMImage *somSelf)
{
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_cwmmFreeBitmaps");


    if(_pBmpInfoHeader2) {
      free(_pBmpInfoHeader2);
      //  _wp_FreeMem(somSelf, _pBmpInfoHeader2);
      _pBmpInfoHeader2=NULLHANDLE;
      _chrIOProcName[0]=0;
    }

    if(_hBitmap) {
      GpiDeleteBitmap(_hBitmap);
      _hBitmap=NULLHANDLE;
    }

    _cwmmFreeSmallBitmap(somSelf);
}

/*
 * The prototype for cwimg_cwmmFreeSmallBitmap was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwimg_cwmmFreeSmallBitmap(MMImage *somSelf)
{
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_cwmmFreeSmallBitmap");

    /*
      V0.2.8 CW 2004/11/01

      Added serialization using the object semaphore


    if(!_wpRequestObjectMutexSem(somSelf, 2000))
      return;
     */
    if(_hBitmapSmall) {

      GpiDeleteBitmap(_hBitmapSmall);
      _hBitmapSmall=NULLHANDLE;
      _ulSizeSmallBitmap=0;
    }
    //    _wpReleaseObjectMutexSem(somSelf);
}

/* New with V0.2.5, CW 2003/01/02 */

/*
 * SOM_Scope ULONG  SOMLINK cwimg_cwmmQueryImageInfo(MMImage *somSelf, 
 *                                                   char** chrString, 
 *                                                   ULONG ulSize, 
 *                                                   int iWhich)
 */

/*
 * The prototype for cwimg_cwmmQueryImageInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwimg_cwmmQueryImageInfo(MMImage *somSelf, 
                                                  char** chrString, 
                                                  ULONG ulSize, 
                                                  long iWhich)
{
  PBITMAPINFOHEADER2 pBmpInfoHdr2=NULLHANDLE;       
  ULONG ulWidth, ulHeight, ulDepth;
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_cwmmQueryImageInfo");

    pBmpInfoHdr2=(PBITMAPINFOHEADER2) _wpQueryBitmapInfoHeader(somSelf);

    if(!pBmpInfoHdr2)
      return 0;

    if(pBmpInfoHdr2->cbFix==sizeof(BITMAPINFOHEADER2)) {
      ulWidth=pBmpInfoHdr2->cx;
      ulHeight=pBmpInfoHdr2->cy;
      ulDepth=pBmpInfoHdr2->cBitCount;
    }
    else {
      PBITMAPINFOHEADER pBmpInfoHdr=(PBITMAPINFOHEADER)pBmpInfoHdr2;
          ulWidth=pBmpInfoHdr->cx;
          ulHeight=pBmpInfoHdr->cy;
          ulDepth=pBmpInfoHdr->cBitCount;
    }
    switch(iWhich)
      {
      case IDINFO_WIDTH:
        return ulWidth;
      case IDINFO_HEIGHT:
        return ulHeight;
      case IDINFO_BPP:
        return ulDepth;
      case IDINFO_FORMAT:
        {
          char *chr;
          /* Image format */
          if(!chrString)
            return 0;
          chr=*chrString;
          strncpy(chr, _chrIOProcName, ulSize);
          chr[ulSize-1]=0;
          if(chr[0]==0)
            return 0;
          else
            return 1;
        }
      default:
        break;
      }
    return 0;
}

SOM_Scope void  SOMLINK cwimg_cwmmRequestBmpDeletion(MMImage *somSelf, 
                                                     ULONG ulFlags)
{
  PUSEITEM pui;
  BOOL bDeleteBmp=FALSE;

    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_cwmmRequestBmpDeletion");


  /*
    Unfortunately only bitmaps for real files are currently deleted. When using links in folders
    the lock counter isn't touched so we don't get a notification.
    _wpUnlockObject isn't called when links are going dormant (do they?) after closing the links folder.

    BTW XWorkplace (V1.0.0) keeps every object locked
    after first touching it and NEVER completely unlocks it!
   */
    TRY_LOUD(BITMAP_DELETION) {
      if((pui=_wpFindUseItem(somSelf, USAGE_RECORD, NULLHANDLE))==NULLHANDLE) {
        bDeleteBmp=TRUE;
      }
      else {
        /* There's at least one usage record. Check if the icon is visible */
        RECTL rectl2;
        PRECORDITEM pri=(PRECORDITEM)(++pui);
        
        /*
          V0.2.9 CW 2004/11/12
          
          Check if small bitmaps for icons are currently visible in any container. This is useful if the
          user scrolls a folder with a lot of pictures.
          */
        pui--;
        bDeleteBmp=TRUE;
        for(;pui ; pui=_wpFindUseItem(somSelf, USAGE_RECORD, pui)) {
          pri=(PRECORDITEM)(++pui);
          pui--;
          if(WinSendMsg(pri->hwndCnr, CM_QUERYVIEWPORTRECT, MPFROMP(&rectl2), MPFROM2SHORT(CMA_WORKSPACE, FALSE))) {
            
            if(pri->pRecord->ptlIcon.y >= rectl2.yBottom  && pri->pRecord->ptlIcon.y <= rectl2.yTop &&
               pri->pRecord->ptlIcon.x >= rectl2.xLeft && pri->pRecord->ptlIcon.x < rectl2.xRight)
              bDeleteBmp=FALSE;
            
          }/* WinSendMsg() */   
        }
      }/* else */
    }/* Try */
    CATCH(BITMAP_DELETION)
      {
        SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d.\n",
                          __FUNCTION__, __FILE__, __LINE__);
      } END_CATCH;

    if(bDeleteBmp) {
      /* Check if queue is full. If yes post semaphore so the other thread cleans up. */
      if(ulNumBMPDelete> BMP_DEL_UPPER) {
        DosPostEventSem(hevDeleteBMP);
        /* Yield cpu so the delete thread may run */
        DosSleep(20);
        /* Thread isn't fast enough so delete the bitmap directly */
        if(ulNumBMPDelete>BMP_QUEUE_SIZE-7) {
          _cwmmFreeBitmaps(somSelf);
          return;
        }
      }
      ulNumBMPDelete++;
      WinPostMsg(g_hwndDeleteBMP, IMGWM_DELETEBITMAP, MPFROMP(somSelf), MPFROM2SHORT(0, ACKEY_CREATE_SMALLBITMAP));
    }
}

/*
 * The prototype for cwimg_wpQueryBitmapHandle was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpQueryBitmapHandle(MMImage *somSelf, 
                                                  HBITMAP* phBitmap, 
                                                  HPAL* phPalette, 
                                                  ULONG ulWidth, 
                                                  ULONG ulHeight, 
                                                  ULONG ulFlags, 
                                                  long lBackgroundColor, 
                                                  BOOL* pbQuitEarly)
{
  ULONG ulSize;
  char chrName[CCHMAXPATH];

    MMImageData *somThis = MMImageGetData(somSelf); 
    MMImageMethodDebug("MMImage","cwimg_wpQueryBitmapHandle");

    /* Check parameter */
    if(!phBitmap)
      return FALSE;

    if(!_wpReadImageFile(somSelf))
      return FALSE;

    *phBitmap=NULLHANDLE;
    if(phPalette)
      *phPalette=NULLHANDLE;

    ulSize=sizeof(chrName);
    if(!_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      return FALSE;

    
    TRY_LOUD(QRY_HBM) {
      /* Create a new (maybe smaller) bitmap from the normal size bitmap */
      *phBitmap=createNewBitmap ( _hBitmap, (PBITMAPINFOHEADER2) _pBmpInfoHeader2, 
                                  ulWidth, ulHeight , pbQuitEarly);
    }
    CATCH(QRY_HBM)
      {
        *phBitmap=NULLHANDLE;

        SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while calling createNewBitmap().\n",
                          __FUNCTION__, __FILE__, __LINE__);
        SysWriteToTrapLog("Image file: %s\n\n",
                          chrName);
      } END_CATCH;
      
      if(!*phBitmap)
        return FALSE;

    return TRUE;
}

/*
 * The prototype for cwimg_wpQueryBitmapInfoHeader was replaced by the following prototype:
 */
SOM_Scope PBYTE  SOMLINK cwimg_wpQueryBitmapInfoHeader(MMImage *somSelf)
{
  ULONG ulSize;
  char chrName[CCHMAXPATH];
  PBYTE pByte=NULLHANDLE;
  BOOL bGotHeader=FALSE;
  BOOL bSem;

  MMImageData *somThis = MMImageGetData(somSelf); 
    MMImageMethodDebug("MMImage","cwimg_wpQueryBitmapInfoHeader");

#ifdef DEBUG
      SysWriteToTrapLog("In _wpQueryBitmapInfoHeader(), line %d\n", __LINE__);
#endif

    /* This is necessary for newly created files. */
    if(!_wpIsObjectInitialized(somSelf))
      return NULLHANDLE;


#ifdef DEBUG
    ulSize=sizeof(chrName);
    if(_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      SysWriteToTrapLog("In _wpQueryBitmapInfoHeader() for %s\n", chrName);
    else
      SysWriteToTrapLog("In _wpQueryBitmapInfoHeader(), filename unknown\n");
#endif

    if(_pBmpInfoHeader2)
      return _pBmpInfoHeader2;

    if(_bNoIOProcAvailable)
      return NULL; /* No IO-proc for this image format. Don't try again in the future. */

    /*
      Don't request the object sem here. The call may block at least when a light table
      folder tries to show the object.
      Problem is that there's a race condition with the code in the light table frame proc trying
      to get the bitmap header (now disabled if small bitmap can't be loaded) for newly inserted
      objects. As soon as _wpAllocMem() is called in the code below the WPS blocks. Probably there's
      a problem with inserting the USAGE_MEMORY item in the in use list while the folder is inserting
      a USAGE_RECORD item. One would assume requesting the mutex solves this but no go... The call
      to _wpRequestObjectMutexSem() just blocks for the specified timeout without returning the semaphor.
      Probably that's exactly what's happening in _wpAllocMem().

      bSem=_wpRequestObjectMutexSem(somSelf, 3000);//SEM_INDEFINITE_WAIT);

      */

#if 0
    if(!_wpAssertObjectMutexSem(somSelf))
      {
        DosBeep(500, 130);
#if 0
        //        bSem=_wpRequestObjectMutexSem(somSelf, 3000);
        if(bSem)
          {
            DosBeep(5000, 130);
            _wpReleaseObjectMutexSem(somSelf);
            //return NULLHANDLE;
          }
#endif
      }
#endif

    TRY_LOUD(GET_BMPIH) {
      for(;;)
        {

          ulSize=sizeof(chrName);
          if(!_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
            break;

          //          if((pByte=_wp_AllocMem(somSelf, sizeof(BITMAPINFOHEADER2)+256*sizeof(RGB2), &ulSize))==NULLHANDLE)
          if((pByte=malloc(sizeof(BITMAPINFOHEADER2)+256*sizeof(RGB2)))==NULLHANDLE)
            break;

          bGotHeader=getBmpInfoHeader( (PBITMAPINFOHEADER2) pByte, chrName, _chrIOProcName, 
                                       sizeof(_chrIOProcName), &_bNoIOProcAvailable);
          break;
        }
    }
    CATCH(GET_BMPIH)
      {
#if 0
        if(MBID_YES==showMsgBoxFlag(IDSTR_CWIMAGETITLE, IDSTR_IMGIOPROCCRASH, queryModuleHandle(),
                             MB_YESNO | MB_MOVEABLE | MB_WARNING))
          exit(0);
#endif
        SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while calling getBmpInfoHeader().\n",
                          __FUNCTION__, __FILE__, __LINE__);
        SysWriteToTrapLog("Image file: %s\n\n",
                          chrName);
      } END_CATCH;

#if 0
      if(bSem) {
        //DosBeep(5000, 50);
      _wpReleaseObjectMutexSem(somSelf);
      }
#endif

#ifdef DEBUG
      if(bGotHeader)
        SysWriteToTrapLog("%s Got header...\n", __FUNCTION__);
      else
        SysWriteToTrapLog("Error with header...\n");
#endif

    if(!bGotHeader) {
      if(pByte)
        free(pByte);
        //        _wp_FreeMem(somSelf, pByte);
      _pBmpInfoHeader2=NULLHANDLE;
      _chrIOProcName[0]=0;
      return NULL;
    }
    _pBmpInfoHeader2=pByte;
    /* Update instance data */
    if(((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cbFix==sizeof(BITMAPINFOHEADER2)) {
      _ulWidth=((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cx;
      _ulHeight=((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cy;
      _ulDepth=((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cBitCount;
    }
    else {
      PBITMAPINFOHEADER pBmpInfoHdr=(PBITMAPINFOHEADER)_pBmpInfoHeader2;
      _ulWidth=pBmpInfoHdr->cx;
      _ulHeight=pBmpInfoHdr->cy;
      _ulDepth=pBmpInfoHdr->cBitCount;
    }

    return (PBYTE) _pBmpInfoHeader2;
}

/*
 * The prototype for cwimg_wpQueryBitmapData was replaced by the following prototype:
 */
SOM_Scope PBYTE  SOMLINK cwimg_wpQueryBitmapData(MMImage *somSelf, 
                                                 ULONG* pulSize)
{
    /* CWImageData *somThis = CWImageGetData(somSelf); */
    MMImageMethodDebug("MMImage","cwimg_wpQueryBitmapData");

    NOT_IMPLEMENTED

    return (MMImage_parent_WPImageFile_wpQueryBitmapData(somSelf, 
                                                         pulSize));
}

/*
 * The prototype for cwimg_wpSetBitmapData was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpSetBitmapData(MMImage *somSelf, 
                                              PBYTE pBitmapData, 
                                              ULONG ulSize)
{
    /* CWImageData *somThis = CWImageGetData(somSelf); */
    MMImageMethodDebug("MMImage","cwimg_wpSetBitmapData");

    NOT_IMPLEMENTED

#if 0
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                  "This function is not available. Please tell the author the steps causing this message box so the function may be implemented.",
                  "cwimg_wpSetBitmapData",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );
#endif

    return (MMImage_parent_WPImageFile_wpSetBitmapData(somSelf, 
                                                       pBitmapData, 
                                                       ulSize));
}

/*
 * The prototype for cwimg_wpReadImageFile was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpReadImageFile(MMImage *somSelf)
{
  char chrName[CCHMAXPATH];
  ULONG ulSize;
  BOOL bGotHeader=FALSE;

  MMImageData *somThis = MMImageGetData(somSelf); 
    MMImageMethodDebug("MMImage","cwimg_wpReadImageFile");

    if(!_wpIsObjectInitialized(somSelf))
      return NULLHANDLE;

    if(_hBitmap)
      return TRUE;

    ulSize=sizeof(chrName);
    if(!_wpQueryRealName(somSelf, chrName, &ulSize,TRUE))
      return FALSE;

#ifdef DEBUG
    SysWriteToTrapLog("In _wpReadImageFile(), file: %s \n",
             chrName);
#endif

    TRY_LOUD(LOAD_BMP) {
      if(_wpQueryBitmapInfoHeader(somSelf))
        bGotHeader=TRUE;
    }
    CATCH(LOAD_BMP)
      {
        SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d while calling _wpQueryBitmapInfoHeader().\n",
                          __FUNCTION__, __FILE__, __LINE__);
        SysWriteToTrapLog("Image file: %s\n",
                          chrName);
      }END_CATCH;
      
      if(!bGotHeader)
        return FALSE;
      _hBitmap=NULLHANDLE;

      TRY_LOUD(LOAD_BMP2) {
        _hBitmap=loadBitmap ( chrName , (PBITMAPINFOHEADER2) _pBmpInfoHeader2);
      }
      CATCH(LOAD_BMP2)
        {
          SysWriteToTrapLog("\nTrap occured in %s (LOAD_BMP2), file %s, around line %d while calling _wpQueryBitmapInfoHeader()\nwith image file %s.\n",
                            __FUNCTION__, __FILE__, __LINE__, chrName);
          SysWriteToTrapLog("Remembering file as invalid.\n");
          /*
            V0.2.8 CW 2004/11/01

            Mark file which caused a trap as invalid.
           */
          _bNoIOProcAvailable=TRUE;
        } END_CATCH;
        
        if(!_hBitmap) {
          return FALSE;
        }
        
        return TRUE;
}


SOM_Scope BOOL  SOMLINK cwimg_wpWriteImageFile(MMImage *somSelf)
{
    /* CWImageData *somThis = CWImageGetData(somSelf); */
    MMImageMethodDebug("MMImage","cwimg_wpWriteImageFile");

    NOT_IMPLEMENTED

#if 0
    WinMessageBox(HWND_DESKTOP, HWND_DESKTOP,
                  "This function is not available. Please tell the author the steps causing this message box so the function may be implemented.",
                  "cwimg_wpWriteImageFile",
                  0UL, MB_OK | MB_ICONEXCLAMATION|MB_MOVEABLE );
#endif

    return (MMImage_parent_WPImageFile_wpWriteImageFile(somSelf));
}

/*
 * wpInitData:   override; Not used. Default is instance var initializing to zero and that's what we need.
 */


SOM_Scope void  SOMLINK cwimg_wpUnInitData(MMImage *somSelf)
{
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpUnInitData");

    if(_pBmpInfoHeader2) {
      free(_pBmpInfoHeader2);
      //  _wp_FreeMem(somSelf, _pBmpInfoHeader2);
      _pBmpInfoHeader2=NULLHANDLE;
    }
    /* This frees all bitmaps. Small for icons and the normal size one */
    _cwmmFreeBitmaps(somSelf);
    MMImage_parent_WPImageFile_wpUnInitData(somSelf);
}

/*
  FIXME:

  This function isn't thread safe because of one global memory area. It is supposed to be
  called from the wpPopupMenu() method. This method can only be called once at
  a time, so that's not a problem. It may become a problem if this function is also
  called from somewhere else. The global mem pointer is used by the image class and the
  audio class.
*/
BOOL insertIOProcMenuItems( HWND hwndMenu )
{
    CHAR          szBuffer[ sizeof( FOURCC ) + CCHMAXPATH + 4 ];
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;
    LONG          lBytesRead;
    HWND hwndSubMenu;
    MENUITEM mi;
    
    if(g_pmmFormatInfoArray)
      free(g_pmmFormatInfoArray);
    g_pmmFormatInfoArray=NULLHANDLE;

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_IMAGE;
    mmFormatInfo.ulFlags|=MMIO_CANWRITETRANSLATED;    
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /* Error - mmioQueryFormatCount failed. */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    g_pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    if( g_pmmFormatInfoArray == NULL )
      {
        /* Could not allocate enough memory for mmFormatInfo array. */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   g_pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(g_pmmFormatInfoArray);
        g_pmmFormatInfoArray=NULLHANDLE;
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(g_pmmFormatInfoArray);
        g_pmmFormatInfoArray=NULLHANDLE;
        return FALSE;
      }

    // Create Empty Submenu //
    hwndSubMenu=WinCreateWindow(hwndMenu,WC_MENU,"",0,
                                0,0,0,0,
                                hwndMenu,//Owner. If set, this window 
                                //is destroyed if owner is destroyed
                                HWND_TOP,
                                ID_MENU_CONVERT,//menuid
                                NULL,NULL);

    mi.iPosition=MIT_END;
    mi.afStyle=MIS_TEXT;//|MIS_SUBMENU;
    mi.id=ID_MENU_CONVERT;
    mi.afAttribute=NULLHANDLE;    
    mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
    mi.hItem=NULLHANDLE;
    mi.hwndSubMenu=hwndSubMenu;

    if(!getMessage(szBuffer, IDSTR_MENU_CONVERT, sizeof(szBuffer), queryResModuleHandle(), HWND_DESKTOP))
       sprintf(szBuffer,"~Convert to");
    WinSendMsg(hwndMenu,MM_INSERTITEM,(MPARAM)&mi,
               (MPARAM)szBuffer);

    pmmFormatInfoArray=g_pmmFormatInfoArray;
    for ( index = 0; index <lNumIOProcs; index++ )
      {
        mmioGetFormatName(pmmFormatInfoArray, szBuffer, &lBytesRead, 0L, 0L);
        
        /* Insert NULL string terminator */
        *( szBuffer + lBytesRead ) = (CHAR)NULL;

        /* Compressed TIF is not supported because the Warp 4 IO-Procs are
           broken. */
        //        HlpWriteToTrapLog("---------  IO-Proc: %s, Name: %s\n",  pmmFormatInfoArray->szDefaultFormatExt,
        //                szBuffer);

        if(pmmFormatInfoArray->fccIOProc!=mmioStringToFOURCC("TFMC",MMIO_TOUPPER) &&
           pmmFormatInfoArray->fccIOProc!=mmioStringToFOURCC("TFIC",MMIO_TOUPPER) &&
           (pmmFormatInfoArray->ulFlags & MMIO_CANWRITETRANSLATED))
          {
            /* Add menu item */
            /* Fill the MENUITEM structure */
            mi.iPosition=MIT_END;
            mi.afStyle=MIS_TEXT|MIS_SUBMENU;
            mi.id=ID_ITEM_FIRSTCONVERT+index;/* Create menu id */
            mi.afAttribute=NULLHANDLE;    
            mi.hwndSubMenu=NULLHANDLE;//hwndSubMenu;
            mi.hItem=NULLHANDLE;
            WinSendMsg(hwndSubMenu, MM_INSERTITEM,(MPARAM)&mi,
                       (MPARAM)szBuffer);
          }
        /*
         *  advance to next entry in mmFormatInfo array
         */        
        pmmFormatInfoArray++;
      }
    return TRUE;
}



/*
 * wpInitData:   override; Not used. Default is instance var initializing to zero and that's what we need.
 */

SOM_Scope ULONG  SOMLINK cwimg_wpQueryDefaultView(MMImage *somSelf)
{
  ULONG ulReturn;

  /*    MMImageData *somThis = MMImageGetData(somSelf);*/
    MMImageMethodDebug("MMImage","cwimg_wpQueryDefaultView");

    ulReturn=(MMImage_parent_WPImageFile_wpQueryDefaultView(somSelf));

    if(ulReturn==OPEN_RUNNING)
      {
        ULONG ulHowMatched=1;
        char chrID[100];
        /* Check if associated program is still available */
        if(!_wpQueryAssociatedProgram(somSelf, OPEN_RUNNING, &ulHowMatched,
                                      chrID, sizeof(chrID),(PSZ)-1))
          return ID_MENU_IMGEDITOR; /* The associated progarm is lost */
      }
    return ulReturn;
}

/*
 * The prototype for cwimg_wpModifyPopupMenu was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpModifyPopupMenu(MMImage *somSelf, 
                                                HWND hwndMenu, 
                                                HWND hwndCnr, 
                                                ULONG iPosition)
{
  MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpModifyPopupMenu");
    _wpInsertPopupMenuItems(somSelf, hwndMenu, 1, queryResModuleHandle(), ID_MENU_IMGEDITOR, 1);

    TRY_LOUD(IMAGE_INSERTPOPUPMENU) {
      /* Insert image info */
      if(_ulWidth!=0 && _ulHeight!=0 && _ulDepth!=0)
        {
          char text[120];
          char menuText[200];
          MENUITEM menuItem;

          if(!getMessage(text, IDSTR_MENU_IMAGEINFO, sizeof(text), queryResModuleHandle(), hwndMenu))
            strcpy(text, "Image information: %d x %d x %d");
          
          sprintf(menuText, text, _ulWidth, _ulHeight, _ulDepth);//create menuitem
          
          //insert size menuitem in popupmenu

          menuItem.iPosition=MIT_END;
          menuItem.afStyle=MIS_TEXT|MIS_STATIC;
          menuItem.afAttribute=0;
          menuItem.id=ID_MENU_IMAGEINFO;
          menuItem.hwndSubMenu=NULLHANDLE;
          menuItem.hItem=0;
          WinSendMsg(hwndMenu,MM_INSERTITEM,(MPARAM)&menuItem,(MPARAM)&menuText);
        }
      /* Insert all known image I/O procs */
      insertIOProcMenuItems( hwndMenu );
      menuInsertMenuSeparator(hwndMenu, NULLHANDLE, MIT_END );
      
    }/* TRY_LOUD */
    CATCH(IMAGE_INSERTPOPUPMENU)
      {
        SysWriteToTrapLog("\nTrap occured in %s, file %s, around line %d.\n",
                          __FUNCTION__, __FILE__, __LINE__);
      } END_CATCH;

    return (MMImage_parent_WPImageFile_wpModifyPopupMenu(somSelf, 
                                                         hwndMenu, 
                                                         hwndCnr, 
                                                         iPosition));
}


/*
 * The prototype for cwimg_wpMenuItemSelected was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpMenuItemSelected(MMImage *somSelf, 
                                                 HWND hwndFrame, 
                                                 ULONG ulMenuId)
{
  /*    MMImageData *somThis = MMImageGetData(somSelf);*/
    MMImageMethodDebug("MMImage","cwimg_wpMenuItemSelected");

    if(ulMenuId>=ID_ITEM_FIRSTCONVERT && ulMenuId<=ID_ITEM_FIRSTCONVERT+lNumIOProcs-1)
      {
        char chrEditor[CCHMAXPATH]={0};
        char chrParams[2*CCHMAXPATH]="\"";
        char *chrPtr=chrParams;
        ULONG ulSize;
        ULONG ulRc;
        
        PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "imageconverter", "", chrEditor,
                              sizeof(chrEditor));
        chrPtr++;
        ulSize=sizeof(chrParams);
        _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
        strcat(chrPtr,"\" \"");
        chrPtr=strrchr(chrPtr, 0);
        mmioGetFormatName(&g_pmmFormatInfoArray[ulMenuId-ID_ITEM_FIRSTCONVERT], chrPtr,(LONG*) &ulSize, 0L, 0L);
        *( chrPtr + ulSize ) = (CHAR)NULL;
        strcat(chrPtr,"\"");

        if((ulRc=launchPMProg("", chrEditor, chrParams, somSelf, ulMenuId-ID_ITEM_FIRSTCONVERT))==NULLHANDLE) {
          /* Error */
          return TRUE;
        }
        return TRUE;
      }

    switch(ulMenuId)
      {
      case ID_MENU_IMGEDITOR:
        _wpViewObject(somSelf, NULLHANDLE, ulMenuId, 0);
        return TRUE;
      default:
        break;
      }

    return (MMImage_parent_WPImageFile_wpMenuItemSelected(somSelf, 
                                                          hwndFrame, 
                                                          ulMenuId));
}

/*
 * The prototype for cwimg_wpOpen was replaced by the following prototype:
 */
SOM_Scope HWND  SOMLINK cwimg_wpOpen(MMImage *somSelf, HWND hwndCnr, 
                                     ULONG ulView, ULONG param)
{
  /*    CWImageData *somThis = CWImageGetData(somSelf); */
    MMImageMethodDebug("MMImage","cwimg_wpOpen");

   switch(ulView)
     {
     case ID_MENU_IMGEDITOR:
        /*case 0xbc2b:   editor */
        {
          char chrEditor[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;
          ULONG ulRc;

          //          PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "imageeditor", "ib.exe", chrEditor,
          //                    sizeof(chrEditor)); /* Default is ib.exe */
          if(!PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "imageeditor", NULLHANDLE, chrEditor,
                                    sizeof(chrEditor)))
            /* No user setting. Use default ib.exe copied by the installation program to another location. IF this setting is missing
               try the app from the path. */
            PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "ib", "ib.exe", chrEditor,
                                  sizeof(chrEditor));


          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");
          if(!getMessage(chrTitle, IDSTR_IMGEDITORTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Editor");

          if((ulRc=launchPMProg( chrTitle, chrEditor, chrParams, somSelf, ulView))==NULLHANDLE) {
            return NULLHANDLE;
          }
          return NULLHANDLE;
        }
     default:
       break;
     }

    return (MMImage_parent_WPImageFile_wpOpen(somSelf, hwndCnr, 
                                              ulView, param));
}


/*
 * The prototype for cwimg_wpAddSettingsPages was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpAddSettingsPages(MMImage *somSelf, 
                                                 HWND hwndNotebook)
{
  BOOL rc;
  /*    MMImageData *somThis = MMImageGetData(somSelf);*/
    MMImageMethodDebug("MMImage","cwimg_wpAddSettingsPages");

    rc=(MMImage_parent_WPImageFile_wpAddSettingsPages(somSelf, 
                                                          hwndNotebook));
    return rc | (_cwmmAddImageInformationPage(somSelf, hwndNotebook));
}


/*
 * The prototype for cwimg_wpQueryDetailsData was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwimg_wpQueryDetailsData(MMImage *somSelf, 
                                                  PVOID* ppDetailsData, 
                                                  PULONG pcp)
{
    BOOL rcParent;
    PIMAGEDETAILS pImageDetails;

    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpQueryDetailsData");

    /* Fill parent info */
    rcParent=(MMImage_parent_WPImageFile_wpQueryDetailsData(somSelf, 
                                                          ppDetailsData, 
                                                          pcp));

    /* The WPS asks for data to be displayed */
    if(ppDetailsData)
      {
        ULONG ulWidth, ulHeight, ulDepth;
      
        PBITMAPINFOHEADER2 pBmpInfoHeader2=NULLHANDLE;       

#if 0
        if(_bUseNewClsFeatures) /* Read info from CD only if allowed. The check if the object
                                   is on CD is done in wpRestore() */
          pBmpInfoHeader2=(PBITMAPINFOHEADER2) _wpQueryBitmapInfoHeader(somSelf);
#endif   

        pBmpInfoHeader2=(PBITMAPINFOHEADER2)_pBmpInfoHeader2;

        if(pBmpInfoHeader2) {
          //DosBeep(1500,200);
          if(pBmpInfoHeader2->cbFix==sizeof(BITMAPINFOHEADER2)) {
            ulWidth=pBmpInfoHeader2->cx;
            ulHeight=pBmpInfoHeader2->cy;
            ulDepth=pBmpInfoHeader2->cBitCount;
          }
          else {
            PBITMAPINFOHEADER pBmpInfoHeader=(PBITMAPINFOHEADER)pBmpInfoHeader2;
            ulWidth=pBmpInfoHeader->cx;
            ulHeight=pBmpInfoHeader->cy;
            ulDepth=pBmpInfoHeader->cBitCount;
          }
        }
        else
          {
            ulWidth=_ulWidth;
            ulHeight=_ulHeight;
            ulDepth=_ulDepth;
          }
        /* Fill the structure with the info to be displayed */      
        pImageDetails=(PIMAGEDETAILS)*ppDetailsData;  
        pImageDetails->ulWidth=ulWidth;
        pImageDetails->ulHeight=ulHeight;
        pImageDetails->ulDepth=ulDepth;
        pImageDetails->pszFormat=_chrIOProcName;
        
        *ppDetailsData=((PBYTE) (*ppDetailsData))+sizeof(*pImageDetails);          
      }
    else
      {
        /* Buffer size is queried */
        if(pcp)
          *pcp+=sizeof(*pImageDetails);
      }
    return rcParent;
}

/*
 * The prototype for cwimg_wpRestoreState was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwimg_wpRestoreState(MMImage *somSelf, 
                                             ULONG ulReserved)
{
    BOOL bReRead=FALSE;

    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpRestoreState");
    
    _bUseNewClsFeatures=TRUE;
    
    if(cwObjectIsOnCD(somSelf)) {
      /* The object is on CD. Check if we should use the new class features */
      if(!PrfQueryProfileInt(HINI_USERPROFILE, "CWMM", IMAGECLS_FEATURES_ON_CD_KEY, 0))
        _bUseNewClsFeatures=FALSE;
    }

    /* Use cached image size so the values are shown in details view on first opening of a folder. The problem is that
       wpQueryDetailsData() is called before the object data is fully initialized. wpIsObjectInitialized() returns
       TRUE but wpQueryRealName() fails at that early stage so it's impossible to read the image data from the file (because
       the filename is unknown). Querying the image data in wpObjectReady() is to late because that method is called after
       wpQueryDetailsData(). In wpObjectReady the image header will be read in. */
    
    /* Query the image info */
    if(!_wpRestoreLong(somSelf, "CWImage", KEY_FILESIZE, &_ulFileSize))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWImage", KEY_WIDTH, &_ulWidth))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWImage", KEY_HEIGHT, &_ulHeight))
      bReRead=TRUE;
    if(!_wpRestoreLong(somSelf, "CWImage", KEY_DEPTH, &_ulDepth))
      bReRead=TRUE;
    if(_ulWidth==0 || _ulHeight==0 || _ulDepth!=0)
      bReRead=TRUE;
    //    if(_bUseNewClsFeatures) /* Read info from CD only if allowed. The check if the object
    //                         is on CD is done in wpRestore() */
    //      _wpQueryBitmapInfoHeader(somSelf);

    return (MMImage_parent_WPImageFile_wpRestoreState(somSelf, 
                                                      ulReserved));
}

void mmRefreshRecords(MMImage *somSelf)
{
  PUSEITEM pUse;

    for(pUse=_wpFindUseItem(somSelf, USAGE_RECORD/*VIEW_CONTENTS|VIEW_DETAILS|VIEW_TREE*/, NULL );pUse;
        pUse=_wpFindUseItem(somSelf, USAGE_RECORD/* VIEW_CONTENTS|VIEW_DETAILS|VIEW_TREE*/, pUse ))
      {
        PRECORDITEM pRecordItem=(PRECORDITEM)++pUse;
        WinPostMsg(pRecordItem->hwndCnr, CM_INVALIDATERECORD,MPFROMP(&pRecordItem->pRecord),
                   MPFROM2SHORT(1,CMA_NOREPOSITION));
      }/* for() */
}

SOM_Scope BOOL  SOMLINK cwimg_wpSetup(MMImage *somSelf, PSZ pszSetupString)
{
  char buffer[CCHMAXPATH];
  ULONG bufferSize;

  /*    MMImageData *somThis = MMImageGetData(somSelf);*/
    MMImageMethodDebug("MMImage","cwimg_wpSetup");


    /* Refresh */
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMREFRESH, buffer,&bufferSize))
      {
        _cwmmFreeBitmaps(somSelf);
#if 0
        _cwmmQuerySmallBitmapHandle(somSelf, 
                                    0, 
                                    NULLHANDLE, 
                                    0);
#endif
        mmRefreshRecords(somSelf);
        //        _wpCnrRefreshDetails(somSelf);
      }
    
    return (MMImage_parent_WPImageFile_wpSetup(somSelf, pszSetupString));
}


SOM_Scope void  SOMLINK cwimg_wpObjectReady(MMImage *somSelf, 
                                            ULONG ulCode, WPObject* refObject)
{  
  PCREATEBMPINFO pCreateBMP;
  ULONG ulError;
  MMImageData *somThis = MMImageGetData(somSelf);
  MMImageMethodDebug("MMImage","cwimg_wpObjectReady");
  
  MMImage_parent_WPImageFile_wpObjectReady(somSelf, ulCode, 
                                           refObject);
  /* Get image info asynchronous to replace cached image size read in from EA  which
     may not be accurate. */
  /* Allocate memory for small bitmap info for the thread */
#if 0
  if(hwndCreateBMP && (pCreateBMP=(PCREATEBMPINFO)_wpAllocMem(somSelf, sizeof(CREATEBMPINFO),&ulError))!=NULLHANDLE)
    {
      /* Only the object pointer is used */
      pCreateBMP->wpObject=somSelf;
      
      //      WinPostMsg(hwndCreateBMP, WM_APPTERMINATENOTIFY,MPFROMP(pCreateBMP), MPFROM2SHORT(0, ACKEY_QUERY_BITMAPINFO));      
    }
#endif
    /* Refresh records in all views */
    //mmRefreshRecords(somSelf);

}

static BOOL _getMissingExtFromImageIOProc(void)
{
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    void * memPtr;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_IMAGE;
    mmFormatInfo.ulFlags|=MMIO_CANREADTRANSLATED;/* Read !!!*/    
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         * Error - mmioQueryFormatCount failed.
         */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    memPtr=pmmFormatInfoArray;
    if( pmmFormatInfoArray == NULL )
      {
        /*
         * Could not allocate enough memory for mmFormatInfo array.
         */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }


    for ( index = 0; index <lNumIOProcs; index++ )
      {
        /* Now scan the whole image proc array */

        if(!strstr(chrMMImageKnownExt, pmmFormatInfoArray->szDefaultFormatExt)) {
          /* This extension is yet unknown */
          if(chrMMImageExt[0]==0) {
            /* It's the first one */
            sprintf(chrMMImageExt,"*.%s", pmmFormatInfoArray->szDefaultFormatExt);
          }
          else {
            /* Check if the extension is not already added (e.g. TIF has a lot of subformats) */
            if(!strstr(chrMMImageExt, pmmFormatInfoArray->szDefaultFormatExt)) {
              strncat(chrMMImageExt,",*.",sizeof(chrMMImageExt)-1-strlen(chrMMImageExt));
              strncat(chrMMImageExt, pmmFormatInfoArray->szDefaultFormatExt, sizeof(chrMMImageExt)-1-strlen(chrMMImageExt));
            }
          }
          //          HlpWriteToTrapLog("Known Extension: %s\n", chrMMImageKnownExt);
          //          HlpWriteToTrapLog("Extension: %s\n", chrMMImageExt);
        }  
        /*
         *  advance to next entry in mmFormatInfo array
         */        
        pmmFormatInfoArray++;
      }
    free(memPtr);

    return FALSE;
}

/*
 *    wpCnrRemoveObject          : override;
 */

/*
 *    wpFormatDragItem           : override;
 */

SOM_Scope BOOL  SOMLINK cwimg_wpSaveState(MMImage *somSelf)
{
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpSaveState");

    /* Cache the image size so the values are shown in details view on first opening of a folder. The problem is that
     wpQueryDetailsData() is called before the object data is fully initialized. wpIsObjectInitialized() returns
     TRUE but wpQueryRealName() fails at that early stage so it's impossible to read the image data from the file (because
     the filename is unknown). Querying the image data in wpObjectReady() is to late because this method is called after
     wpQueryDetailsData(). */
    if(_pBmpInfoHeader2) {
      if(((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cbFix==sizeof(BITMAPINFOHEADER2)) {
        _wpSaveLong(somSelf, "CWImage", KEY_WIDTH, ((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cx);    
        _wpSaveLong(somSelf, "CWImage", KEY_HEIGHT, ((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cy);
        _wpSaveLong(somSelf, "CWImage", KEY_DEPTH, ((PBITMAPINFOHEADER2)_pBmpInfoHeader2)->cBitCount);
      }
      else {
        PBITMAPINFOHEADER pBmpInfoHeader=(PBITMAPINFOHEADER)_pBmpInfoHeader2;

        _wpSaveLong(somSelf, "CWImage", KEY_WIDTH, pBmpInfoHeader->cx);    
        _wpSaveLong(somSelf, "CWImage", KEY_HEIGHT, pBmpInfoHeader->cy);
        _wpSaveLong(somSelf, "CWImage", KEY_DEPTH, pBmpInfoHeader->cBitCount);
      }
    }
    return (MMImage_parent_WPImageFile_wpSaveState(somSelf));
}

#if 0
SOM_Scope BOOL  SOMLINK cwimg_wpFormatDragItem(MMImage *somSelf, 
                                               PDRAGITEM pdrgItem)
{
  BOOL rc;

    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpFormatDragItem");

    rc= (MMImage_parent_WPImageFile_wpFormatDragItem(somSelf, 
                                                        pdrgItem));
DosBeep(500,10);
SysWriteToTrapLog("%d\n",pdrgItem->cxOffset);
    pdrgItem->cxOffset+=60;
    return rc;
}
#endif

SOM_Scope BOOL  SOMLINK cwimg_wpUnlockObject(MMImage *somSelf)
{
    MMImageData *somThis = MMImageGetData(somSelf);
    MMImageMethodDebug("MMImage","cwimg_wpUnlockObject");

    /*
      Call a function which checks if the bitmaps of this object may be deleted in the background.
      The call is here because this method is called for every object in a folder whenever a folder
      is closed.
      If the folder is closed it's likely the bitmaps may be obsolete. A check for USAGE_RECORD items
      will be done on another thread.
 
      wpDeleteFromObjUseList() seems to be the more natural place to do this but the method is not called
      when an object is removed from a container. Also wpCnrRemoveObject() doesn't work because the WPS seems
      to use wpclsRemoveObjects() to remove all objects when closing folders.

      XWP (at least up to 1.02) keeps every object locked, so we can't just check the lock state by
      querying wpIsObjectLocked(). That's the reason we jump through loops here :-(.

     */
    if(_hBitmap || _hBitmapSmall) 
      sendDeleteBMPMsg(somSelf);

    return (MMImage_parent_WPImageFile_wpUnlockObject(somSelf));
}








/*
 * The prototype for cwimgM_wpclsInitData was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwimgM_wpclsInitData(M_MMImage *somSelf)
{
  PCLASSFIELDINFO pCfi;
  USHORT i;
  static BOOL bGotImgExt=FALSE;

    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsInitData");

    /* Get extensions of additional image procs not represented by a class.
       Strangely enough wpclsQueryInstanceFilter() is called during wpclsInitData() so
       we query the extensions here before calling the parent so we have the information. */
    if(!bGotImgExt)
      {
        /* Get user supplied extensions e.g. *.JPE*/
        getStringFromRexxScript("imageadd.rx", chrMMImageExt, sizeof(chrMMImageExt));

        /* Get all already handled extensions */
        getStringFromRexxScript("imageext.rx", chrMMImageKnownExt, sizeof(chrMMImageKnownExt));
        /* Now check installed IO procs for other exts and add them to the filter list */
        _getMissingExtFromImageIOProc();
        bGotImgExt=TRUE; 
      }

    M_MMImage_parent_M_WPImageFile_wpclsInitData(somSelf);

    if(!globalHab)
      globalHab=WinQueryAnchorBlock(HWND_DESKTOP);

    if(!getMessage(chrHelpLibrary, IDSTR_HELPLIBRARY, sizeof(chrHelpLibrary), 
                   queryModuleHandle(), HWND_DESKTOP))
      strcpy(chrHelpLibrary,"MMPARTS.HLP");

    /* Load strings for details titles */
    if(getMessage(chrWidth, IDSTR_IMAGEDETAIL_WIDTH, sizeof(chrWidth), queryResModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[0]=chrWidth;
    if(getMessage(chrHeight, IDSTR_IMAGEDETAIL_HEIGHT, sizeof(chrHeight), queryResModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[1]=chrHeight;
    if(getMessage(chrDepth, IDSTR_IMAGEDETAIL_DEPTH, sizeof(chrDepth), queryResModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[2]=chrDepth;
    if(getMessage(chrFormat, IDSTR_IMAGEDETAIL_FORMAT, sizeof(chrFormat), queryResModuleHandle(), HWND_DESKTOP))
      pszImageColTitles[3]=chrFormat;

    /* Setup the static data for the details view */
    for(i=0,pCfi=cfiImageFieldInfo;i<NUM_IMAGE_DETAILS_FIELDS;i++,pCfi++)
      {
        memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));
        
        pCfi->cb=sizeof(CLASSFIELDINFO);
        pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
        pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
        pCfi->pNextFieldInfo=pCfi+1;
        pCfi->pTitleData=(PVOID)pszImageColTitles[i];
        pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;
        
        switch(i)
          {
          case 0: /* Width */
            pCfi->flData|=CFA_ULONG;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS, ulWidth));
            pCfi->ulLenFieldData=sizeof(ULONG);
            pCfi->ulLenCompareValue=sizeof(ULONG);
            pCfi->DefaultComparison=CMP_GREATER;
            break;
          case 1: /* Height */
            pCfi->flData|=CFA_ULONG;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS,ulHeight));
            pCfi->ulLenFieldData=sizeof(ULONG);
            pCfi->ulLenCompareValue=sizeof(ULONG);
            pCfi->DefaultComparison=CMP_GREATER;
            break;
          case 2: /* Depth */
            pCfi->flData|=CFA_ULONG;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS,ulDepth));
            pCfi->ulLenFieldData=sizeof(ULONG);
            pCfi->ulLenCompareValue=sizeof(ULONG);
            pCfi->DefaultComparison=CMP_GREATER;
            break;
          case 3: /* Format */
            pCfi->flData|=CFA_STRING;
            pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(IMAGEDETAILS,pszFormat));
            pCfi->ulLenFieldData=sizeof(PSZ);
            pCfi->DefaultComparison=CMP_EQUAL;
            break;
          }/* switch(i) */
      }/* for() */
    cfiImageFieldInfo[NUM_IMAGE_DETAILS_FIELDS].pNextFieldInfo=NULL;    
    if(!hwndCreateBMP)
      _beginthread(createBMPThreadFunc,NULL,8192*20, NULLHANDLE); //Fehlerbehandlung fehlt

    if(!g_hwndDeleteBMP)
      _beginthread(deleteBMPThreadFunc,NULL,8192*10, NULLHANDLE); //Fehlerbehandlung fehlt

}


/*
 * The prototype for cwimgM_wpclsQueryDefaultView was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryDefaultView(M_MMImage *somSelf)
{
#if 0
  char chrID[120];
  WPObject *wpObject;
  HOBJECT hObject;
#endif
    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsQueryDefaultView");

    //    sprintf(chrID, "<MMPM2_MM%sTEMPLATE>", _wpclsQueryInstanceType(somSelf));
    //HlpWriteToTrapLog("%s\n", chrID);
#if 0
    if((hObject=WinQueryObject(chrID))!=NULLHANDLE)
      DosBeep(5000, 500);
      //      _wpclsQueryObject(somSelf, hObject);
    if((wpObject=_wpclsQueryObjectFromPath(somSelf, chrID))!=NULLHANDLE)
      {
        ULONG ulHowMatched=1;
        
        DosBeep(5000, 1000);
        /* Template found. Now query associated program */
        if(_wpQueryAssociatedProgram(wpObject, VIEW_RUNNING, &ulHowMatched,
                                  chrID, sizeof(chrID),(PSZ)-1))
          DosBeep(500, 1000);
      }
#endif        
    /* Create default templates. We do it here because we need an object to query the associated
       program (if any) when the system asks for the default view. */
return OPEN_RUNNING;
//    return ID_MENU_IMGEDITOR;
}


BOOL checkImageIOProc(char * chrExt)
{
    CHAR          szBuffer[ sizeof( FOURCC ) + CCHMAXPATH + 4 ];
    MMFORMATINFO  mmFormatInfo;
    PMMFORMATINFO pmmFormatInfoArray;
    void * memPtr;
    ULONG         ulReturnCode;
    LONG          lFormatsRead;
    LONG          index;
    LONG          lBytesRead;

    memset( &mmFormatInfo,
            '\0',
            sizeof(MMFORMATINFO) );
    
    mmFormatInfo.ulMediaType |= MMIO_MEDIATYPE_IMAGE;
    mmFormatInfo.ulFlags|=MMIO_CANWRITETRANSLATED;    
    ulReturnCode = mmioQueryFormatCount ( &mmFormatInfo,
                                          &lNumIOProcs,
                                          0,
                                          0 );
    
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         * Error - mmioQueryFormatCount failed.
         */
        return FALSE;
      }

    /*
     * Allocate enough memory for n number of FormatInfo blocks
     */
    pmmFormatInfoArray = malloc (lNumIOProcs * sizeof( MMFORMATINFO ) );
    memPtr=pmmFormatInfoArray;
    if( pmmFormatInfoArray == NULL )
      {
        /*
         * Could not allocate enough memory for mmFormatInfo array.
         */
        return FALSE;
      }
    
    /*
     * call mmioGetFormats to get info on the formats supported.
     */
    ulReturnCode = mmioGetFormats( &mmFormatInfo,
                                   lNumIOProcs,
                                   pmmFormatInfoArray,
                                   &lFormatsRead,
                                   0,
                                   0 );
    if( ulReturnCode != MMIO_SUCCESS )
      {
        /*
         *  mmioGetFormats failed.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }
    
    if( lFormatsRead != lNumIOProcs )
      {
        /*
         * Error in MMIO - number of formats read in by
         * mmioGetFormats is not equal to number of formats
         * found by mmioQueryFormatCount.
         */
        free(pmmFormatInfoArray);
        return FALSE;
      }


    for ( index = 0; index <lNumIOProcs; index++ )
      {
        mmioGetFormatName(pmmFormatInfoArray, szBuffer, &lBytesRead, 0L, 0L);
        
        /* Insert NULL string terminator */
        *( szBuffer + lBytesRead ) = (CHAR)NULL;

        /* Compressed TIF is not supported because the Warp 4 IO-Procs are
           broken. */
        //HlpWriteToTrapLog("---------  Ext: %s, IO-Proc: %s, Name: %s\n", 
        //chrExt,  pmmFormatInfoArray->szDefaultFormatExt,
        //                szBuffer);

        if(pmmFormatInfoArray->fccIOProc!=mmioStringToFOURCC("TFMC",MMIO_TOUPPER) &&
           pmmFormatInfoArray->fccIOProc!=mmioStringToFOURCC("TFIC",MMIO_TOUPPER) &&
           (pmmFormatInfoArray->ulFlags & MMIO_CANWRITETRANSLATED))
          {
            if(strstr(chrExt, pmmFormatInfoArray->szDefaultFormatExt)) {
              //HlpWriteToTrapLog("******* Ext given: %s  IO-Proc: %s\n", chrExt, pmmFormatInfoArray->szDefaultFormatExt);
              free(memPtr);
              return TRUE;
            }
          }
        /*
         *  advance to next entry in mmFormatInfo array
         */        
        pmmFormatInfoArray++;
      }
    free(memPtr);

    return FALSE;
}

SOM_Scope BOOL  SOMLINK cwimgM_wpclsCreateDefaultTemplates(M_MMImage *somSelf, 
                                                           WPObject* Folder)
{
    /* M_MMImageData *somThis = M_MMImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsCreateDefaultTemplates");

    //HlpWriteToTrapLog("Class title: %s\n", _wpclsQueryTitle(somSelf));

    /* The FOURCC of the JPEG-IO proc is JPEG so we have to create that template
       in the JPG class. */
    
    if(checkImageIOProc( _wpclsQueryInstanceFilter(somSelf))) {
      //   WPFolder* wpFolder;
      //  wpFolder=_wpclsQueryFolder(somSelf, "<MMPM2_MMTEMPLATEFOLDER>", FALSE);
      // return M_MMAudio_parent_M_MMDataFile_wpclsCreateDefaultTemplates(somSelf, wpFolder);
      //            HlpWriteToTrapLog("Create template for: %s\n", _wpclsQueryTitle(somSelf));
      //     HlpWriteToTrapLog("Create template for: %s\n", _somGetClassName(somSelf) );
      mmclsCreateTheDefaultTemplate(somSelf, Folder);
      return TRUE;
    }

    return TRUE;
}

SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryStyle(M_MMImage *somSelf)
{
    /* M_MMImageData *somThis = M_MMImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsQueryStyle");

    return CLSSTYLE_NEVERPRINT;
    //    return (M_MMImage_parent_M_WPImageFile_wpclsQueryStyle(somSelf));
}

/*
 * The prototype for cwimgM_wpclsQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwimgM_wpclsQueryTitle(M_MMImage *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_CWIMAGETITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"Digital Image");

    return chrTitle;
}

/*
 * The prototype for cwimgM_wpclsQueryIconData was replaced by the following prototype:
 */
/*
 *    wpclsQueryDefaultHelp: override;
 */

SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryIconData(M_MMImage *somSelf, 
                                                   PICONINFO pIconInfo)
{
  HMODULE hmod;

    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsQueryIconData");

    hmod=queryModuleHandle();
    if(!hmod)
      return M_MMImage_parent_M_WPImageFile_wpclsQueryIconData(somSelf, pIconInfo);

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = hmod;
      pIconInfo->resid   = ID_ICONCWIMAGEFILE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}

/*
 * The prototype for cwimgM_wpclsQueryDetailsInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwimgM_wpclsQueryDetailsInfo(M_MMImage *somSelf, 
                                                      PCLASSFIELDINFO* ppClassFieldInfo, 
                                                      PULONG pSize)
{
  ULONG cParentColumns;
  PCLASSFIELDINFO pCfi;
  int i;

    /* M_CWImageData *somThis = M_CWImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsQueryDetailsInfo");

    cParentColumns= (M_MMImage_parent_M_WPImageFile_wpclsQueryDetailsInfo(somSelf, 
                                                                 ppClassFieldInfo, 
                                                                 pSize));
  if(pSize)
    *pSize+=sizeof(IMAGEDETAILS);

  if(ppClassFieldInfo)
    {
      if(*ppClassFieldInfo)
        {
          pCfi=*ppClassFieldInfo;
          for(i=0; i<cParentColumns;i++)
            pCfi=(pCfi->pNextFieldInfo ? pCfi->pNextFieldInfo: pCfi);

          pCfi->pNextFieldInfo=cfiImageFieldInfo;
        }
      else
        *ppClassFieldInfo=cfiImageFieldInfo;
    }
    return (cParentColumns+NUM_IMAGE_DETAILS_FIELDS);
}



SOM_Scope PSZ  SOMLINK cwimgM_wpclsQueryInstanceFilter(M_MMImage *somSelf)
{
    /* M_MMImageData *somThis = M_MMImageGetData(somSelf); */
    M_MMImageMethodDebug("M_MMImage","cwimgM_wpclsQueryInstanceFilter");

    //return "*.png,*.sdf,*.klj,*jpe,*.zui";
    return chrMMImageExt;
    /*    return (M_MMImage_parent_M_WPImageFile_wpclsQueryInstanceFilter(somSelf));*/
}

