
/*
 *  This file was generated by the SOM Compiler.
 *  Generated using:
 *     SOM incremental update: 2.47
 */


/*
 * (C) Chris Wohlgemuth 2002-2004
 *
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
 * If you need another license for your project/product contact me at
 * 
 * http://www.os2world.com/cdwriting
 * http://www.geocities.com/SiliconValley/Sector/5785/
 */

/*
 *  This file was generated by the SOM Compiler and Emitter Framework.
 *  Generated using: 
 *      SOM Emitter emitctm: 2.42
 */

#ifndef SOM_Module_cwmp3_Source
#define SOM_Module_cwmp3_Source
#endif
#define CWMP3_Class_Source
#define M_CWMP3_Class_Source


#define INCL_PM
#define INCL_DOS
#define INCL_DOSERRORS

#include "os2.h"
#include <stdio.h>
#include <wpdisk.h>
#include "cwaudio.h"
#include "cwaudio.h"
#include "cwmp3.ih"

#include "cwaudioinc.h"
#include "sys_funcs.h"

#define ID3TAGVALUE_BUFFER_SIZE 31

extern char classDLLPath[CCHMAXPATH];

int iGenreLast=191;
char *genreList[]={
	"Blues", "Classic Rock", "Country", "Dance", "Disco", "Funk",
	"Grunge", "Hip-Hop", "Jazz", "Metal", "New Age", "Oldies",
	"Other", "Pop", "R&B", "Rap", "Reggae", "Rock",
	"Techno", "Industrial", "Alternative", "Ska", "Death Metal", "Pranks",
	"Soundtrack", "Euro-Techno", "Ambient", "Trip-Hop", "Vocal", "Jazz+Funk",
	"Fusion", "Trance", "Classical", "Instrumental", "Acid", "House",
	"Game", "Sound Clip", "Gospel", "Noise", "AlternRock", "Bass",
	"Soul", "Punk", "Space", "Meditative", "Instrumental Pop", "Instrumental Rock",
	"Ethnic", "Gothic", "Darkwave", "Techno-Industrial", "Electronic", "Pop-Folk",
	"Eurodance", "Dream", "Southern Rock", "Comedy", "Cult", "Gangsta",
	"Top 40", "Christian Rap", "Pop/Funk", "Jungle", "Native American", "Cabaret",
	"New Wave", "Psychadelic", "Rave", "Showtunes", "Trailer", "Lo-Fi",
	"Tribal", "Acid Punk", "Acid Jazz", "Polka", "Retro", "Musical",
	"Rock & Roll", "Hard Rock", "Folk", "Folk/Rock", "National Folk", "Swing",
	"Fast-Fusion", "Bebob", "Latin", "Revival", "Celtic", "Bluegrass", "Avantgarde",
	"Gothic Rock", "Progressive Rock", "Psychedelic Rock", "Symphonic Rock", "Slow Rock", "Big Band",
	"Chorus", "Easy Listening", "Acoustic", "Humour", "Speech", "Chanson",
	"Opera", "Chamber Music", "Sonata", "Symphony", "Booty Bass", "Primus",
	"Porn Groove", "Satire", "Slow Jam", "Club", "Tango", "Samba",
	"Folklore", "Ballad", "Power Ballad", "Rhythmic Soul", "Freestyle", "Duet",
	"Punk Rock", "Drum Solo", "A capella", "Euro-House", "Dance Hall",
	"Goa", "Drum & Bass", "Club House", "Hardcore", "Terror",
	"Indie", "BritPop", "NegerPunk", "Polsk Punk", "Beat",
	"Christian Gangsta", "Heavy Metal", "Black Metal", "Crossover", "Contemporary C",
	"Christian Rock", "Merengue", "Salsa", "Thrash Metal", "Anime", "JPop",
        "SynthPop", "Christmas", "Art rock", "Baroque",	"Bhangra", "Big beat", "Breakbeat",
        "Chillout", "Downtempo", "Dub",	"EBM", "Eclectic", "Electro", "Electroclash", "Emo",
        "Experimental",	"Garage", "Global", "IDM", "Illbient", "Industro-Goth",	"Jam Band",
        "Krautrock", "Leftfield", "Lounge", "Math rock", "New romantic", "Nu-breakz", "Post-punk",
        "Post-rock", "Psytrance", "Shoegaze", "Space rock", "Trop rock", "World music", "Neoclassical",
        "Audiobook", "Audio theatre", "Neue Deutsche Welle", "Podcast", "Indie-rock", "G-Funk",
        "Dubstep", "Garage rock", "Psybient"
};

HMODULE queryResModuleHandle(void);
HMODULE queryModuleHandle(void);
PSZ queryModuleName(void);
BOOL getMessage(char* text,ULONG ulID, LONG lSizeText, HMODULE hResource,HWND hwnd);
void _removeTrailingSpaces(char * chrString);

/* In som_and_wps.c */
BOOL cwObjectIsOnCD(WPObject * somSelf);
BOOL cwObjectIsOnInvalidDrive(WPObject * somSelf);
BOOL cwObjectIsOnInvalidID3Drive(WPObject * somSelf);

ULONG cwQueryOSRelease(void);
BOOL cwMoveNotebookButtonsWarp4(HWND hwndDlg, USHORT usID, USHORT usDelta);
void SysWriteToTrapLog(const char* chrFormat, ...);
ULONG launchPMProg(PSZ pszTitle, PSZ wrapperExe, PSZ parameters,  WPObject *thisPtr, ULONG ulView);
MRESULT EXPENTRY waveInfoDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2);

PSZ _queryMp3HelpLibraryName(void)
{
  static char helpLibraryName[CCHMAXPATH];
  BOOL bDone=FALSE;

  if(!bDone) {
    if(queryModuleHandle()) {
      char  *ptr;
      strncpy(helpLibraryName, classDLLPath, sizeof(helpLibraryName)-1);
      if((ptr=strrchr(helpLibraryName, '\\'))!=NULLHANDLE) {
        *(++ptr)=0;
        if(strlen(helpLibraryName)+strlen(MP3FILE_HELP_LIBRARY)<sizeof(helpLibraryName)) {
          strcat(helpLibraryName, MP3FILE_HELP_LIBRARY );
          bDone=TRUE;
          return helpLibraryName;
        }
      }
    }
    return NULLHANDLE;
  }

  return helpLibraryName;
}

void _fillEntryfieldsWithCurrentId3( MMMP3 *cwMp3, HWND hwnd)
{
  ID3TAG id3Tag;
  char fName[31];

  if(_cwmmQueryId3Tag(cwMp3, &id3Tag))
    {
      fName[0]=0;
      strncat(fName,id3Tag.id3Name,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3NAME),fName);
      
      fName[0]=0;
      strncat(fName,id3Tag.id3Artist,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST),fName);

      fName[0]=0;
      strncat(fName,id3Tag.id3Album,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3ALBUM),fName);

      fName[0]=0;
      strncat(fName,id3Tag.id3Year,4);
      fName[4]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3YEAR),fName);

      fName[0]=0;
      strncat(fName,id3Tag.id3Comment,30);
      fName[30]=0;
      _removeTrailingSpaces(fName);
      WinSetWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT),fName);

      /* Genre */
      if(id3Tag.id3Genre[0]>iGenreLast) {
        fName[0]=0;
        strncat(fName,"",30);
        fName[30]=0;
        _removeTrailingSpaces(fName);
        WinSetWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE), fName);
      }
      else {
        WinSetWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE),genreList[id3Tag.id3Genre[0]]);
      }
    }
}

MRESULT EXPENTRY id3TagDlgProc(HWND hwnd, ULONG msg, MPARAM mp1, MPARAM mp2)
{
  MMMP3 *cwMp3;

  switch(msg) {
  case WM_INITDLG :
    cwMp3=(MMMP3*)PVOIDFROMMP(mp2);
    WinSetWindowULong(WinWindowFromID(hwnd,IDEF_ID3NAME),
                      QWL_USER,(ULONG)cwMp3);//Save object ptr.
    if(somIsObj(cwMp3)) {
      for(;;) {
        int a;
        HWND hwndTemp;
        HWND hwndSave, hwndUndo;

        if(cwObjectIsOnCD(cwMp3))
          {
            /* CDs are readonly so remove 'Save' and 'Undo' buttons */
            WinDestroyWindow(WinWindowFromID(hwnd,IDPB_ID3SAVE));
            WinDestroyWindow(hwndUndo=WinWindowFromID(hwnd,IDPB_CANCEL));
            /* Make entry fields read only */
            WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3NAME),EM_SETREADONLY,MPFROMSHORT((SHORT)TRUE),0);
            WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ARTIST),EM_SETREADONLY,MPFROMSHORT((SHORT)TRUE),0);
            WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ALBUM),EM_SETREADONLY,MPFROMSHORT((SHORT)TRUE),0);
            WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3COMMENT),EM_SETREADONLY,MPFROMSHORT((SHORT)TRUE),0);
            WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3YEAR),EM_SETREADONLY,MPFROMSHORT((SHORT)TRUE),0);
          }

        /* Move default buttons on Warp 4 */
        cwMoveNotebookButtonsWarp4(hwnd, IDPB_ID3HELP, 15);

        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3NAME),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ARTIST),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3ALBUM),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3COMMENT),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)30),0);
        WinSendMsg(WinWindowFromID(hwnd,IDEF_ID3YEAR),EM_SETTEXTLIMIT,MPFROMSHORT((SHORT)4),0);
        /* Fill drop downlist */
        hwndTemp=WinWindowFromID(hwnd, IDDD_ID3GENRE);
        for(a=0;a<=iGenreLast;a++)
          WinSendMsg(hwndTemp, LM_INSERTITEM, MPFROMSHORT(LIT_SORTASCENDING),MPFROMP(genreList[a]));

        /* Get the ID3 tags from the file and insert them into the entry fields */
        _fillEntryfieldsWithCurrentId3(cwMp3, hwnd);
        break;
      }
    }
    WinSetWindowULong(WinQueryWindow(hwnd, QW_PARENT), QWL_HWNDFOCUSSAVE, hwnd);
    return (MRESULT)TRUE;
      /* This prevents switching the notebook page behind the open folder */
    case WM_WINDOWPOSCHANGED:
      {
        MRESULT mr;

        if(WinQueryFocus(HWND_DESKTOP)!=
           WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT)) {
          mp2=MPFROMLONG(LONGFROMMP(mp2)|0x80000);/*AWP_ACTIVATE 0x00080000L*/
          mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
          return mr;  
        }
        break;
      }
    case WM_FOCUSCHANGE:
      {
        if(!SHORT1FROMMP(mp2)) {
          if(HWNDFROMMP(mp1)==hwnd) {
            MRESULT mr;

            mr=WinDefDlgProc(hwnd, msg, mp1, mp2);
            WinSendMsg(WinQueryWindow(WinQueryWindow(hwnd, QW_PARENT), QW_PARENT), WM_SETFOCUS, MPFROMHWND(hwnd), (MPARAM)TRUE);
            return mr;
          }
        }
        break;
      }
    case WM_DESTROY:
      /* The notebook closes and gets destroyed */
      /* Set focus to desktop to prevent PM freeze */
      WinSetFocus(HWND_DESKTOP, HWND_DESKTOP);
      break;
  case WM_COMMAND:    
    cwMp3=(MMMP3*) WinQueryWindowULong(WinWindowFromID(hwnd, IDEF_ID3NAME),QWL_USER);
    if(somIsObj(cwMp3)) {
      ID3TAG id3Tag;
      char fName[31];

      switch(SHORT1FROMMP(mp1))
        {
        case IDPB_CANCEL:
          /* Get the ID3 tags from the file and insert them into the entry fields */
          _fillEntryfieldsWithCurrentId3(cwMp3, hwnd);
          break;
        case IDPB_ID3SAVE:
          {
            int a;
            
            memset(&id3Tag,0,sizeof(id3Tag));
            memcpy(id3Tag.id3Tag,"TAG",sizeof(id3Tag.id3Tag));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3NAME), 31, fName);
            memcpy(id3Tag.id3Name, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ARTIST), 31, fName);
            memcpy(id3Tag.id3Artist, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3ALBUM), 31, fName);
            memcpy(id3Tag.id3Album, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3COMMENT), 31, fName);
            memcpy(id3Tag.id3Comment, fName,strlen(fName));
            WinQueryWindowText(WinWindowFromID(hwnd, IDEF_ID3YEAR), 5, fName);
            memcpy(id3Tag.id3Year, fName,strlen(fName));

            /* Find genre */
            WinQueryWindowText(WinWindowFromID(hwnd, IDDD_ID3GENRE), 31, fName);
            for(a=0;a<=iGenreLast;a++)
              if(!stricmp(fName, genreList[a]))
                break;
            if(a>iGenreLast)
              id3Tag.id3Genre[0]=0xFF;/* No Genre inserted */
            else
              id3Tag.id3Genre[0]=a;
            _cwmmSetId3Tag(cwMp3, &id3Tag);
          }
          break;
        default:
          break;
        }
    }
    return (MRESULT) TRUE;
  default:
    break;
  }
  return WinDefDlgProc(hwnd, msg, mp1, mp2);
}

/*
 * The prototype for cwmp3_cwmmAddId3TagPage was replaced by the following prototype:
 */
/*!*******************************************************/
/*                                                       */
/* @@DESC                                                */
/*                                                       */
/* This instance method is called to allow the object    */
/* to add the ID3 tag page to its Settings notebook.     */
/* :p.                                                   */
/* This page can be used to change the ID3 tag of an     */
/* MP3 file.                                             */
/*                                                       */
/* @@USAGE                                               */
/*                                                       */
/* This method must only be called from within an        */
/* override of wpAddSettingsPages().                     */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* MMMP3 *somSelf input                                  */
/*                                                       */
/* Pointer to the object on which the method is being    */
/* invoked.                                              */
/* :p.                                                   */
/* Points to an object of class :hp2.MMImage:ehp2..      */
/*                                                       */
/* @@PARAM                                               */
/*                                                       */
/* HWND hwndNotebook input                               */
/*                                                       */
/* Settings notebook handle.                             */
/*                                                       */
/* @@OVERRIDE                                            */
/*                                                       */
/* This method should always be overridden in order to   */
/* remove or replace the image information page from     */
/* the object's Settings notbook.                        */
/* :p.                                                   */
/* To remove the page from the Settings notebook, the    */
/* override method should return                         */
/* :hp1.SETTINGS_PAGE_REMOVED:ehp1. without calling the  */
/* the parent method. To replace the page with another   */
/* page, the override method should call the             */
/* wpInsertSettingsPAge method without calling the       */
/* parent method.                                        */
/*                                                       */
/* @@RETURNS                                             */
/*                                                       */
/* ULONG rc                                              */
/*                                                       */
/* :parml compact tsize=15 break=none.                   */
/* :pt.0:pd.Error occurred                               */
/* :pt.PageId :pd.Identifier for the inserted page.      */
/* :eparml.                                              */
/*                                                       */
/*!!******************************************************/
SOM_Scope ULONG  SOMLINK cwmp3_cwmmAddId3TagPage(MMMP3 *somSelf, 
                                                 HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  /*    CWMP3Data *somThis = CWMP3GetData(somSelf);*/
    MMMP3MethodDebug("MMMP3","cwmp3_cwmmAddId3TagPage");

  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = id3TagDlgProc;
  //The resource DLL
  pageinfo.resid = queryResModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_ID3TAGS;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  if(cwObjectIsOnCD(somSelf))
    pageinfo.idDefaultHelpPanel = MP3FILE_SETTINGS_PANEL_CD;
  else
    pageinfo.idDefaultHelpPanel = MP3FILE_SETTINGS_PANEL;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = _queryMp3HelpLibraryName();
  //We have a major tab so we need a name
  if(!getMessage(pageName, ID_ID3TAGSPAGENAME, sizeof(pageName),  queryResModuleHandle(), hwndNotebook))
    strcpy(pageName, "~ID3 tag");
  pageinfo.pszName = pageName;
  //Insert the page into the settings notebook

  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);

}

static void convertID3CodePage(ID3TAG *id3Tag, ULONG ulFromCp, ULONG ulToCp)
{
  if(ulFromCp==0 || ulToCp==0)
    return;
  else {
    char fName[32];
    char fTransName[32];
    ID3TAG  id3Temp;

    HAB hab=WinQueryAnchorBlock(HWND_DESKTOP);

    id3Temp=*id3Tag;
    memset(&id3Temp,0,sizeof(id3Temp));
    memcpy(id3Temp.id3Tag,"TAG",sizeof(id3Temp.id3Tag));

    strncpy(fName, id3Tag->id3Name,30);
    fName[30]=0;/* The ID3 spec allows 30 chars. */
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Name, fTransName, 30);
    
    //    memset(fname,0,sizeof(fname));
    strncpy(fName,id3Tag->id3Artist,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Artist, fTransName, 30);    
    
    strncpy(fName,id3Tag->id3Album,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Album, fTransName, 30);    
    
    strncpy(fName,id3Tag->id3Year,4);
    fName[4]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    strncpy(id3Temp.id3Year, fTransName, 4);    


    if(id3Tag->id3Comment[28]==0 &&
       id3Tag->id3Comment[29]!=0 ) {
      strncpy(fName,id3Tag->id3Comment,28); /* Keep Track information of ID3 V1.1 */
      fName[28]=0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[28]=0;
      strncpy(id3Temp.id3Comment, fTransName,strlen(fTransName));
      id3Temp.id3Comment[28]=0;
      id3Temp.id3Comment[29]=id3Tag->id3Comment[29];
    }
    else {
      strncpy(fName,id3Tag->id3Comment,30);
      fName[30]=0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[30]=0;
      strncpy(id3Temp.id3Comment, fTransName,strlen(fTransName));
    }

#if 0
    fName[0]=0;
    strncat(fName, id3Tag->id3Name,30);
    fName[30]=0;/* The ID3 spec allows 30 chars. */
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Name, fTransName, 30);
    
    //    memset(fname,0,sizeof(fname));
    fName[0]=0;
    strncat(fName,id3Tag->id3Artist,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Artist, fTransName, 30);    
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Album,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Album, fTransName, 30);    
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Year,4);
    fName[4]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
    memcpy(id3Temp.id3Year, fTransName, 4);    


    if(id3Tag->id3Comment[28]==0 &&
       id3Tag->id3Comment[29]!=0 ) {
      strncpy(fName,id3Tag->id3Comment,28); /* Keep Track information of ID3 V1.1 */
      fName[28]==0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[28]=0;
    }
    else {
      strncpy(fName,id3Tag->id3Comment,30);
      fName[30]==0;
      if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
        return;
      fTransName[30]=0;
    }

#if 0
    fName[0]=0;
    strncat(fName,id3Tag->id3Comment,30);
    fName[30]=0;
    if(!WinCpTranslateString(hab, ulFromCp, fName, ulToCp, 31, fTransName))
      return;
    fTransName[30]=0;
#endif
    memcpy(id3Temp.id3Comment, fTransName,strlen(fTransName));
#endif

    id3Temp.id3Genre[0]=id3Tag->id3Genre[0];

    *id3Tag=id3Temp;
  }

}

/*
 * This method gets the ID3 tags from the file, converts the codepage to
 * the current system codepage and puts the information in the instance vars.
 */
SOM_Scope BOOL  SOMLINK cwmp3_cwmmQueryId3Tag(MMMP3 *somSelf, 
                                              ID3TAG* id3Tag)
{
  FILE *file;
  ULONG ulSize;
  char fName[CCHMAXPATH];
  M_MMMP3* m_cwMP3;
  M_MMMP3Data *m_cwMP3Data;
  
  /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
  MMMP3MethodDebug("MMMP3","cwmp3_cwmmQueryId3Tag");
  
  /* Get ID3 tag */
  ulSize=sizeof(fName);
  if(!_wpQueryRealName(somSelf, fName, &ulSize, TRUE))
    return FALSE;
  
  if((file=fopen(fName, "rb"))==NULL)
    return FALSE;
  
  if(fseek(file, -128, SEEK_END)){
    fclose(file);
    return FALSE;
  }
  if(128!=fread(id3Tag, 1, 128, file)){
    fclose(file);
    return FALSE;
  }
  fclose(file);
  
  if(memicmp(id3Tag->id3Tag,"TAG",3))
    return FALSE;/* No ID3 tag */

  /* Convert the info to ISO 8859-1. Somewhere I've seen info the ID3 tag uses this charset.
     Can't find this reference anymore :-(. Because the windows CP is nearly identical
     we should convert the data anyway to see the right info if put into the tag on W*n systems.
     It's a W*n world out there so it's likely this CP was used. The usual W*ndoze user does not
     care about details but just clicks 'OK'. Do I hear I LOVE YOU? <eg> */
  m_cwMP3=_MMMP3;
  if(!somIsObj(m_cwMP3))
    return TRUE;

  m_cwMP3Data  = M_MMMP3GetData(m_cwMP3);
  convertID3CodePage(id3Tag, m_cwMP3Data->ulIsoCodePage, m_cwMP3Data->ulCodePage);
  return TRUE;
}

/*
 * This method writes track information from the instance vars to the files ID3 tag.
 * If the tag doesn't exist yet it will be created. The information is converted from
 * the current codepage to the ISO8859-1 codepage used by ID3 tags.
 */
SOM_Scope BOOL  SOMLINK cwmp3_cwmmSetId3Tag(MMMP3 *somSelf, ID3TAG* id3Tag)
{
  ID3TAG id3TagQuery;
  ULONG ulSize;
  char fName[CCHMAXPATH];
  BOOL   bHaveTag=FALSE;
  HFILE hFile;
  ULONG ulAction;
  ULONG rc;
  M_MMMP3* m_cwMP3;
  M_MMMP3Data *m_cwMP3Data;

    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_cwmmSetId3Tag");

    if(!id3Tag)
      return FALSE;

    /* Ensure the tag has the signature */
    memcpy(id3Tag, "TAG", 3);

    /* Needed to access class instance variables */
    m_cwMP3=_MMMP3;
    if(!somIsObj(m_cwMP3))
      return FALSE;
    m_cwMP3Data  = M_MMMP3GetData(m_cwMP3);

    /* Check if there's already a Tag */
    if(_cwmmQueryId3Tag(somSelf, &id3TagQuery))
      {
        if(!memicmp(id3TagQuery.id3Tag,"TAG",3))
          bHaveTag=TRUE; /* Make sure we have valid information to write. If not the old Tag is kept. */
      }

    /* Open the MP3 */
    ulSize=sizeof(fName);
    _wpQueryRealName(somSelf, fName, &ulSize, TRUE);
    if((rc=DosOpen(fName, &hFile, &ulAction, 0, 0, OPEN_ACTION_FAIL_IF_NEW|OPEN_ACTION_OPEN_IF_EXISTS,
                   OPEN_FLAGS_FAIL_ON_ERROR|OPEN_SHARE_DENYWRITE|OPEN_ACCESS_WRITEONLY,NULL))!=NULLHANDLE) {
      return FALSE;
    }

    if(bHaveTag) {
      /* There's a Tag so move fileptr to the beginning of it */
      if(DosSetFilePtr(hFile, -128, FILE_END, &ulSize)){
        DosClose(hFile);
        return FALSE;
      }
    }
    else
      {
        /* No Tag yet. Move fileptr to the end of the file */
        if(DosSetFilePtr(hFile, 0, FILE_END, &ulSize)){
          DosClose(hFile);
          return FALSE;
        }
      }

    /* Convert the data from current codepage to ISO 8859-1 which is used for ID3 */
    convertID3CodePage(id3Tag, m_cwMP3Data->ulCodePage, m_cwMP3Data->ulIsoCodePage);

    /* Save comment field */
    fName[0]=id3Tag->id3Comment[28];
    fName[1]=id3Tag->id3Comment[29];

    /* Write Tag to the file */
    if(bHaveTag) {
      /* If there's an old tag, keep the track info of ID3 V1.1 */
      if(id3TagQuery.id3Comment[28]==0 &&
         id3TagQuery.id3Comment[29]!=0) {
        /* Track number is the last byte of the comment field. */
        id3Tag->id3Comment[28]=0;/* Terminate comment */
        id3Tag->id3Comment[29]=id3TagQuery.id3Comment[29];/* Old track number */
      }
    }
    if(DosWrite(hFile,id3Tag, 128, &ulSize)){
      DosClose(hFile);
      /* Convert back */
      convertID3CodePage(id3Tag, m_cwMP3Data->ulIsoCodePage, m_cwMP3Data->ulCodePage);
      return FALSE;
    }
    DosClose(hFile);

    id3Tag->id3Comment[28]=fName[0];
    id3Tag->id3Comment[29]=fName[1];

    /* Convert back */
    convertID3CodePage(id3Tag, m_cwMP3Data->ulIsoCodePage, m_cwMP3Data->ulCodePage);

#if 0
    /* Set new instance data. */
    fName[0]=0;
    strncat(fName,id3Tag->id3Name,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_NAME);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Artist,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ARTIST);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Album,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ALBUM);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Year,4);
    fName[4]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_YEAR);
    
    fName[0]=0;
    strncat(fName,id3Tag->id3Comment,30);
    fName[30]=0;
    _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_COMMENT);
    
    if(id3Tag->id3Genre[0]>iGenreLast) {
      fName[0]=0;
      strncat(fName,"",30);
      fName[30]=0;
      _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_GENRE);
    }
    else {
      _cwmmSetTrackInfo(somSelf, genreList[id3Tag->id3Genre[0]], 0, IDINFO_GENRE);
    }
#endif

    return TRUE;
}


/*
 * The prototype for cwmp3_cwmmQueryId3TagValue was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmp3_cwmmQueryId3TagValue(MMMP3 *somSelf, 
                                                   PSZ pszValue, 
                                                   ULONG ulWhich)
{
  ID3TAG id3Tag;

  /*  MMMP3Data *somThis = MMMP3GetData(somSelf);*/
  MMMP3MethodDebug("MMMP3","cwmp3_cwmmQueryId3TagValue");

  /* No ID3 tag yet */  
  if(!_cwmmQueryId3Tag(somSelf, &id3Tag))
    return FALSE;
 
  memset(pszValue,0, ID3TAGVALUE_BUFFER_SIZE);

  switch(ulWhich)
    { 
    case IDINFO_NAME:
      if(id3Tag.id3Name[0]) {
        memcpy(pszValue, id3Tag.id3Name, 30);
        return TRUE;
      }
      break;
    case IDINFO_ARTIST:
      if(id3Tag.id3Artist[0]) {
        memcpy(pszValue, id3Tag.id3Artist, 30);
        return TRUE;
      }
      break;
    case IDINFO_ALBUM:
      if(id3Tag.id3Album[0]) {
        memcpy(pszValue, id3Tag.id3Artist, 30);
        return TRUE;
      }
      break;
    case IDINFO_YEAR:
      if(id3Tag.id3Year[0]) {
        memcpy(pszValue, id3Tag.id3Year, 4);
        return TRUE;
      }
      break;
    case IDINFO_COMMENT:
      if(id3Tag.id3Comment[0]) {
        memcpy(pszValue, id3Tag.id3Comment, 30);
        return TRUE;
      }
      break;
    case IDINFO_GENRE:
      if(id3Tag.id3Genre[0] != (char)0xFF) {
        pszValue[0]=id3Tag.id3Genre[0];
        return TRUE;
      }
      break;
    default:
      break;
    }
  
  /* Return statement to be customized: */
  return FALSE;
}


SOM_Scope BOOL  SOMLINK cwmp3_cwmmSetId3TagValue(MMMP3 *somSelf, 
                                                 PSZ pszValue, 
                                                 ULONG ulWhich)
{
  ID3TAG id3Tag;

  /*  MMMP3Data *somThis = MMMP3GetData(somSelf);*/
  MMMP3MethodDebug("MMMP3","cwmp3_cwmmSetId3TagValue");
  
  if(!pszValue || pszValue[0]==0)
    return FALSE;

  if(!_cwmmQueryId3Tag(somSelf, &id3Tag)) {
    memset(&id3Tag, 0, sizeof(id3Tag)); /* No tag yet. Set it to empty. */
    /* Default for genre is 0xff not 0 which equals 'blues' */
    id3Tag.id3Genre[0]=0xFF;
  }

  switch(ulWhich)
    { 
    case IDINFO_NAME:
      strncpy(id3Tag.id3Name, pszValue, 30);
      break;
    case IDINFO_ARTIST:
        strncpy(id3Tag.id3Artist, pszValue, 30);
      break;
    case IDINFO_ALBUM:
      strncpy(id3Tag.id3Album, pszValue, 30);
      break;
    case IDINFO_YEAR:
        strncpy(id3Tag.id3Year, pszValue, 4);
        break;
    case IDINFO_COMMENT:
      strncpy(id3Tag.id3Comment, pszValue, 30);
      break;
    case IDINFO_GENRE:
      pszValue[0]=id3Tag.id3Genre[0]=pszValue[0];
      break;
    default:
      return FALSE;
    }
  /* ID3 tag built now write it to the file */
  _cwmmSetId3Tag(somSelf, &id3Tag);

  return TRUE;
}

/*
 *    cwmmAddTrackNamePage      : override;
 */

/*
 * SOM_Scope ULONG  SOMLINK cwmp3_cwmmQueryTrackInfo(MMMP3 *somSelf, 
 *                                                   PSZ chrString, 
 *                                                   ULONG ulSize, 
 *                                                   int iWhich)
 */

/*
 * The prototype for cwmp3_cwmmQueryTrackInfo was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwmp3_cwmmQueryTrackInfo(MMMP3 *somSelf, 
                                                  PSZ chrString, 
                                                  ULONG ulSize, 
                                                  ULONG iWhich)
{
  somId id;
  ULONG rc;
  /*   somTD_MMAudio_cwmmQueryTrackInfo methodPtr; */

  /*  MMMP3Data *somThis = MMMP3GetData(somSelf);*/
  /*    MMAudioData *somThis = MMAudioGetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_cwmmQueryTrackInfo");


    if(iWhich<1||iWhich>IDINFO_LASTINFO)
      return FALSE;


    switch(iWhich)
      {
      case IDINFO_BITRATE:
        return (MMMP3_parent_MMAudio_cwmmQueryTrackInfo(somSelf, 
                                                        chrString, 
                                                        ulSize, iWhich));
      default:
        break;
      }
    //  SysWriteToTrapLog("%s %d\n", __FUNCTION__, __LINE__);
    return (MMMP3_parent_MMAudio_cwmmQueryTrackInfo(somSelf, 
                                                    chrString, 
                                                    ulSize, iWhich));


#if 0
  if((mySomId=somIdFromString("cwmmQueryTrackInfo"))!=NULLHANDLE) {
    rc=((somTD_M_WPObject_wpclsQueryStyle)
          somParentNumResolve(__ClassObject->somGetPClsMtabs(),
                              1,
                              __ClassObject->
                              somGetMethodToken(mySomId))
        )(this);
    SOMFree(mySomId);
  }
  
  SysWriteToTrapLog("%s %d, %d, %x %x %x %d, Addr: %x\n", __FUNCTION__, __LINE__, iWhich, somSelf, chrString, ulSize, iWhich, cwmp3_cwmmQueryTrackInfo);
  
  /* Get method address */
  if((id=somIdFromString("cwmmQueryTrackInfo"))!=NULLHANDLE) {
    methodPtr= (somTD_MMAudio_cwmmQueryTrackInfo) _somFindSMethod(_somGetClass(_MMAudio), id);
    methodPtr= (somTD_MMAudio_cwmmQueryTrackInfo) _somFindSMethod(_MMAudio, id);
    if(methodPtr) {
      SysWriteToTrapLog("%s %d, %d, %x %x %x %d, Addr: %x\n", __FUNCTION__, __LINE__, iWhich, somSelf, chrString, ulSize, iWhich, methodPtr);
      methodPtr(somSelf, chrString, ulSize, iWhich);
      /*( (somTD_MMAudio_cwmmQueryTrackInfo) MMMP3_parent_MMAudio_cwmmQueryTrackInfo_resolved)
        (somSelf,chrString,ulSize,iWhich);
        */     
      SysWriteToTrapLog("%s %d, %d, %x %x %x %d, Addr: %x !!\n", __FUNCTION__, __LINE__, iWhich, somSelf, chrString, ulSize, iWhich, 
                        MMMP3_parent_MMAudio_cwmmQueryTrackInfo_resolved);
    }
    SOMFree(id);
  }/* somId */
#endif
}


SOM_Scope ULONG  SOMLINK cwmp3_cwmmAddAudioInformationPage(MMMP3 *somSelf, 
                                                           HWND hwndNotebook)
{
  PAGEINFO pageinfo;
  char pageName[100];

  /*  MMMP3Data *somThis = MMMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_cwmmAddAudioInformationPage");


  //Clear the pageinfo structure
  memset((PCH)&pageinfo, 0, sizeof(PAGEINFO));
  //Fill the pageinfo structure
  pageinfo.cb = sizeof(PAGEINFO);
  pageinfo.hwndPage = NULLHANDLE;
  pageinfo.usPageStyleFlags = BKA_MAJOR | BKA_STATUSTEXTON;
  pageinfo.usPageInsertFlags = BKA_FIRST;
  //We want page numbers
  pageinfo.usSettingsFlags = SETTINGS_PAGE_NUMBERS;
  //The dialog procedure for this page
  pageinfo.pfnwp = waveInfoDlgProc;
  //The resource DLL
  pageinfo.resid = queryResModuleHandle();
  //pageinfo.resid = queryModuleHandle();
  //The ID of the dialog template
  pageinfo.dlgid = IDDLG_WAVEINFOPAGE;
  //We need a pointer to our WPS-object in the dialog procedure
  //to call class functions
  pageinfo.pCreateParams = somSelf;
  //The ID of the help panel for this page
  //pageinfo.idDefaultHelpPanel = IDDLG_GENERAL2PAGE;
  //Tell the WPS the help library name
  pageinfo.pszHelpLibraryName = NULLHANDLE;
  //We have a major tab so we need a name
  if(!getMessage(pageName, ID_WAVEINFOPAGENAME, sizeof(pageName), queryResModuleHandle(), hwndNotebook))
    strcpy(pageName, "~Audio information");
  pageinfo.pszName = pageName;


  /* The following is only important for MP3 files because gathering the audio info
     for MP3 files is currently very slow. Will improve with future releases of MMIOMP3*/
  if(__get_ulFileSize(somSelf)!=_wpQueryFileSize(somSelf)) {
    /* The filesize changed, somebody altered the audio file so reread the info */
    if(!cwObjectIsOnInvalidDrive(somSelf)) {
      //    if(!cwObjectIsOnCD(somSelf)) {
      /* Only get audio info when file isn't on CD. This speeds up opening of folders on CDs filled with
         MP3s. Doesn't hurt because folders of CDs open in normal details view as default so the audio info
         isn't necessary. When opening the settings notebook the info is reread anyway. */      
      
      /* Get class object */
      M_CWMMDataFile *m_cwmmDataFile=_CWMMDataFile;
      
      /* Send the object pointer to the audio worker thread to read the audio info in the background. */
      WinPostMsg(__get_hwndAudioWorker(_CWMMDataFile), WM_APPTERMINATENOTIFY, somSelf, 0);
    }
    else
      return SETTINGS_PAGE_REMOVED; /* Don't show info page on CD because all info is zero anyway. */
  }

  //Insert the page into the settings notebook
  return _wpInsertSettingsPage(somSelf,hwndNotebook,&pageinfo);

  //  return (MMMP3_parent_MMAudio_cwmmAddAudioInformationPage(somSelf, 
  //                                                       hwndNotebook));
}

SOM_Scope BOOL  SOMLINK cwmp3_wpAddSettingsPages(MMMP3 *somSelf, 
                                                 HWND hwndNotebook)
{
  BOOL rc;
    /* MMMP3Data *somThis = MMMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_wpAddSettingsPages");

    rc=(MMMP3_parent_MMAudio_wpAddSettingsPages(somSelf, 
                                                    hwndNotebook));
    _cwmmAddId3TagPage(somSelf,
                       hwndNotebook);

    return rc;
}

/*
 * The prototype for cwmp3_wpRestoreState was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmp3_wpRestoreState(MMMP3 *somSelf, 
                                             ULONG ulReserved)
{
  BOOL bRc; 
  ID3TAG id3Tag;
  char fName[CCHMAXPATH];

  /*    CWMP3Data *somThis = CWMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_wpRestoreState");

    /* Read info from EA in MMAudio(). This fills the instance vars with
       e.g. the trackname, artist etc. ID3 tags are not read and the length of
       that information is much greater than the length of ID3 tags. This
       information is shown in the details view of folders. */
    bRc= (MMMP3_parent_MMAudio_wpRestoreState(somSelf, ulReserved));

    /* Don't read ID3 tags for files on CD because this takes ages on slow drives. */
#if 0
    if(cwObjectIsOnCD(somSelf))
      return bRc;
#endif

    /* Don't read ID3 tags for files on user specified drives  because this may take ages on slow drives. */
    /* The list of drives may be specified in USER ini                                                    */
    if(cwObjectIsOnInvalidID3Drive(somSelf))
      return bRc;

    /* Get ID3 tag */
    if(_cwmmQueryId3Tag(somSelf, &id3Tag))
      {
        char chrDummy[20];

        fName[0]=0;
        strncat(fName,id3Tag.id3Name,30);
        fName[30]=0;/* The ID3 spec allows 30 chars. */
        _removeTrailingSpaces(fName);
        /* Set trackinfo of EA only if not already restored. By doing it this way longer info (see MAX_EA_SIZE)
         isn't overwritten by the shorter ID3 tag info. */
        if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_NAME)) {
          //SysWriteToTrapLog("!! %s %d\n", __FUNCTION__, __LINE__);
          _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_NAME);
        }

        fName[0]=0;
        strncat(fName,id3Tag.id3Artist,30);
        fName[30]=0;
        _removeTrailingSpaces(fName);
        if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_ARTIST))
          _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ARTIST);
          
        fName[0]=0;
        strncat(fName,id3Tag.id3Album,30);
        fName[30]=0;
        _removeTrailingSpaces(fName);
        if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_ALBUM))
          _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_ALBUM);

        fName[0]=0;
        strncat(fName,id3Tag.id3Year,4);
        fName[4]=0;
        //    SysWriteToTrapLog("%s %d: %s\n", __FUNCTION__, __LINE__, fName);
        if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_YEAR))
          _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_YEAR);

        fName[0]=0;
        strncat(fName,id3Tag.id3Comment,30);
        fName[30]=0;
        _removeTrailingSpaces(fName);
        //        SysWriteToTrapLog("%s %d: %s\n", __FUNCTION__, __LINE__, fName);
        if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_COMMENT))
          _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_COMMENT);          

        if(id3Tag.id3Genre[0]>iGenreLast) {
          fName[0]=0;
          strncat(fName,"",30);
          fName[30]=0;/* ID3 encodes genre into one byte. */
          if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_GENRE))
            _cwmmSetTrackInfo(somSelf, fName, 0, IDINFO_GENRE);
        }
        else {
          if(!_cwmmQueryTrackInfo(somSelf, chrDummy, sizeof(chrDummy), IDINFO_GENRE))
            _cwmmSetTrackInfo(somSelf, genreList[id3Tag.id3Genre[0]], 0, IDINFO_GENRE);
        }
      }
    else {
      /* No ID3 tag yet. Insert the info from the EAs */
      //FIXME
      /* Not implemented yet */
    }

    /* Get MP3 technical data */
    return bRc;
}


/*
 * The prototype for cwmp3_wpSetup was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmp3_wpSetup(MMMP3 *somSelf, PSZ pszSetupString)
{
  char buffer[CCHMAXPATH];
  ULONG bufferSize;
  ID3TAG id3Tag;
  int a;
  BOOL bRc;

    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_wpSetup");

    /* Call parent. This will fill the instance vars for EAs with the tracknames etc. */
    bRc=(MMMP3_parent_MMAudio_wpSetup(somSelf, pszSetupString));

    /* New generic names */
    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOTRACKNAME, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_NAME))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_NAME);

#if 0
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Name, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOARTIST, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_ARTIST))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_ARTIST);

#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        //   if(bufferSize<30+1)
        //   buffer[bufferSize-1]=' ';
        memcpy(id3Tag.id3Artist, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOALBUM, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_ALBUM))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_ALBUM);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Album, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOCOMMENT, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_COMMENT))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_COMMENT);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag,0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Comment, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOYEAR, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_YEAR) && bufferSize==4+1)
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_YEAR);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        if(bufferSize==4+1) {
          memcpy(id3Tag.id3Year, buffer, 4);
          _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
        }
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_MMAUDIOGENRE, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_GENRE)) {
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          /* Find genre from string */
          for(a=0;a<=iGenreLast;a++)
            if(!stricmp(buffer, genreList[a]))
              break;
          if(a>iGenreLast)
            id3Value[0]=0xFF;/* No Genre inserted */
          else
            id3Value[0]=a;
          _cwmmSetId3TagValue(somSelf, id3Value, IDINFO_GENRE);
        }
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        /* Find genre from string */
        for(a=0;a<=iGenreLast;a++)
          if(!stricmp(buffer, genreList[a]))
            break;
        if(a>iGenreLast)
          id3Tag.id3Genre[0]=0xFF;/* No Genre inserted */
        else
          id3Tag.id3Genre[0]=a;
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }



    /* Old depracted names. Will vanish in the future. */
    bufferSize=sizeof(buffer);
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3TRACKNAME, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_NAME))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_NAME);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Name, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance ID3 tag data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3ARTIST, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_ARTIST))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_ARTIST);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Artist, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3ALBUM, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_ALBUM))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_ALBUM);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Album, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3COMMENT, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_COMMENT))
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_COMMENT);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag,0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        memcpy(id3Tag.id3Comment, buffer, 30);
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3YEAR, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];

        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_YEAR) && bufferSize==4+1)
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          _cwmmSetId3TagValue(somSelf, buffer, IDINFO_YEAR);
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        if(bufferSize==4+1) {
          memcpy(id3Tag.id3Year, buffer, 4);
          _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
        }
#endif
      }
    bufferSize=sizeof(buffer); 
    if(_wpScanSetupString(somSelf, pszSetupString, SETUP_ID3GENRE, buffer, &bufferSize))
      {
        char id3Value[ID3TAGVALUE_BUFFER_SIZE];
        
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3TagValue(somSelf, id3Value, IDINFO_GENRE)) {
          /* This ID3 tag value not yet set. So add it to the file. The length will be automatically
             truncated to the allowed length of the ID3 tag. */
          /* Find genre from string */
          for(a=0;a<=iGenreLast;a++)
            if(!stricmp(buffer, genreList[a]))
              break;
          if(a>iGenreLast)
            id3Value[0]=0xFF;/* No Genre inserted */
          else
            id3Value[0]=a;
          _cwmmSetId3TagValue(somSelf, id3Value, IDINFO_GENRE);
        }
#if 0
        /* Save the ID3 tag into the file */
        if(!_cwmmQueryId3Tag(somSelf, &id3Tag)){ /* Get ID3 tag */
          memset(&id3Tag, 0,sizeof(id3Tag));      /* No tag yet, clear struct. */
          strncpy(id3Tag.id3Tag, "TAG", 3);
          id3Tag.id3Genre[0]=0xFF;
        }
        /* Find genre from string */
        for(a=0;a<=iGenreLast;a++)
          if(!stricmp(buffer, genreList[a]))
            break;
        if(a>iGenreLast)
          id3Tag.id3Genre[0]=0xFF;/* No Genre inserted */
        else
          id3Tag.id3Genre[0]=a;
        _cwmmSetId3Tag(somSelf, &id3Tag); /* This sets also the instance data */
#endif
      }

    return bRc;
}


/*
 * The prototype for cwmp3_wpSaveState was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmp3_wpSaveState(MMMP3 *somSelf)
{
  char chrBuf[256];
  ULONG ulLength;
  BOOL rc;

    /* CWMP3Data *somThis = CWMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_wpSaveState");

    /* call parent first. By doing so, the MP3 type is written after the Digital Audio type.
     This way the default class the WPS picks is MMMP3 and not MMAudio. */
    rc=(MMMP3_parent_MMAudio_wpSaveState(somSelf));

    /* Set .TYPE EA so the editor and the player are happy. */
    strncpy(chrBuf, _wpQueryType(somSelf), sizeof(chrBuf));
    chrBuf[sizeof(chrBuf)-1]=0;
    //    if(!getMessage(chrTitle, IDSTR_MP3TITLE, sizeof(chrTitle), queryModuleHandle(), HWND_DESKTOP))
    //    strcpy(chrTitle, CLSTYPE_MP3);

    /* Look if type already set */
    if(!strstr(chrBuf,TYPE_MP3)) {
      ulLength=strlen(chrBuf);
      if(ulLength) {
        if(ulLength+2+sizeof(TYPE_MP3) < sizeof(chrBuf)) {
          strcat(chrBuf, "\n");
          strcat(chrBuf, TYPE_MP3);
        }
      }
      else
        strcpy(chrBuf, TYPE_MP3);
    }
    /* Set .TYPE EA so the editor and the player are happy. */
    _wpSetType(somSelf, chrBuf , NULL);

    return rc;
}

SOM_Scope HWND  SOMLINK cwmp3_wpOpen(MMMP3 *somSelf, HWND hwndCnr, 
                                     ULONG ulView, ULONG param)
{
  ULONG ulRc;
    /* MMMP3Data *somThis = MMMP3GetData(somSelf); */
    MMMP3MethodDebug("MMMP3","cwmp3_wpOpen");

    switch(ulView)
      {
      case ID_MENU_PLAYER:
        /*case 0xbbe5:   Player */
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+2]="\"";
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;

          if(!PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "mp3player", NULLHANDLE, chrPlayer,sizeof(chrPlayer)))
            break; /* Fall back to MMAudio player */

          chrPtr++;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");

          if(!getMessage(chrTitle, IDSTR_AUDPLAYERTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Player");

          if((ulRc=launchPMProg(chrTitle, chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      case ID_MENU_EDITOR:
        /* case 0xbc0d:  Editor */ 
        {
          char chrPlayer[CCHMAXPATH]={0};
          char chrParams[CCHMAXPATH+10]={0};
          char chrTitle[50];
          char *chrPtr=chrParams;
          ULONG ulSize;

          if(!PrfQueryProfileString(HINI_USERPROFILE, "CWMM", "mp3editor", NULLHANDLE, chrPlayer,sizeof(chrPlayer)))
            break; /* Fall back to MMAudio editor */

          chrPtr+=4;
          ulSize=sizeof(chrParams)-2;
          _wpQueryRealName(somSelf, chrPtr, &ulSize, TRUE);
          strcat(chrPtr,"\"");

          if(!getMessage(chrTitle, IDSTR_AUDEDITORTITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
            strcpy(chrTitle, "Editor");

          if((ulRc=launchPMProg( chrTitle, chrPlayer, chrParams, somSelf, ulView))==NULLHANDLE) {
            break;
          }
          return NULLHANDLE;
        }
      default:
        break;
      }

    return (MMMP3_parent_MMAudio_wpOpen(somSelf, hwndCnr, ulView, 
                                        param));
}


/*
 * The prototype for cwmp3M_wpclsQueryTitle was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryTitle(M_MMMP3 *somSelf)
{
  static char chrTitle[20]={0};
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_MMMP3MethodDebug("M_MMMP3","cwmp3M_wpclsQueryTitle");

    if(chrTitle[0]==0)
      if(!getMessage(chrTitle, IDSTR_MP3TITLE, sizeof(chrTitle), queryResModuleHandle(), HWND_DESKTOP))
        strcpy(chrTitle,"MP3Audio.MP3");

    return chrTitle;
}

/*
 * The prototype for cwmp3M_wpclsQueryInstanceType was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryInstanceType(M_MMMP3 *somSelf)
{
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_MMMP3MethodDebug("M_MMMP3","cwmp3M_wpclsQueryInstanceType");

    return TYPE_MP3;//"MP3";
}

#if 0
char* _cwmmGetExtFromIni(M_MMMP3 *somSelf, const PSZ pszDefaultExt)
{
  char chrKey[10];
  ULONG ulLength;
  pByte pByte;

  sprintf(chrKey, "%sExt", pszDefaultExt);

  if(!PrfQueryProfileSize(HINI_USERPROFILE, "CWMM", chrKey, NULL, &ulLength))
    return NULLHANDLE;

  pByte=_ wpAllocMem
  if(PrfQueryProfileString(HINI_USERPROFILE, "CWMM", chrKey, NULL, ))
    {
      /* Key  found */

    }
}
#endif

/*
 * The prototype for cwmp3M_wpclsQueryInstanceFilter was replaced by the following prototype:
 */
SOM_Scope PSZ  SOMLINK cwmp3M_wpclsQueryInstanceFilter(M_MMMP3 *somSelf)
{
  //  static char* chrExt;
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_MMMP3MethodDebug("M_MMMP3","cwmp3M_wpclsQueryInstanceFilter");

    return "*.MP3,*.*.MP3,*.*.*.MP3";

}

/*
 * The prototype for cwmp3M_wpclsQueryIconData was replaced by the following prototype:
 */
SOM_Scope ULONG  SOMLINK cwmp3M_wpclsQueryIconData(M_MMMP3 *somSelf, 
                                                   PICONINFO pIconInfo)
{
  HMODULE hmod;
    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_MMMP3MethodDebug("M_MMMP3","cwmp3M_wpclsQueryIconData");

    hmod=queryModuleHandle();
    if(!hmod)
      return M_MMMP3_parent_M_MMAudio_wpclsQueryIconData(somSelf, pIconInfo);

	if (pIconInfo)   {
      pIconInfo->fFormat = ICON_RESOURCE;
      pIconInfo->hmod    = hmod;
      pIconInfo->resid   = ID_ICONMP3FILE;
	} /* endif */

	return ( sizeof(ICONINFO) );
}


ULONG _getISOCp(void)
{
  ULONG ulData;
  ULONG ulNumCp;

  /* Get number of codepages */
  if((ulNumCp=WinQueryCpList(WinQueryAnchorBlock(HWND_DESKTOP), 1, &ulData))!=0) {
    ULONG *ulCpList;

    /* Get memory for codepage list */ 
    ulCpList=(ULONG*)malloc(ulNumCp*sizeof(ULONG));
    if(ulCpList) {
      int a;
      /* Get codepage list */
      if((ulNumCp=WinQueryCpList(WinQueryAnchorBlock(HWND_DESKTOP), ulNumCp, ulCpList))!=0) {
        for(a=0;a<ulNumCp;a++)
          {
            if(ulCpList[a]==819) {
              free(ulCpList);
              return (ULONG) 819;/* The IBM ISO 8859-1 CP */
            } 
          }
        /* ISO 8859-1 CP not found. Try to find 1004 (Windows extended) which is a quite good match */
        for(a=0;a<ulNumCp;a++)
          {
            if(ulCpList[a]==1004) {
              free(ulCpList);
              return (ULONG) 1004;/* The IBM ISO 8859-1 CP */
            } 
          }
      }
      free(ulCpList);
    }
  }
  /* No CP found or an error occured */
  return 0;
}

/*
 * The prototype for cwmp3M_wpclsInitData was replaced by the following prototype:
 */
SOM_Scope void  SOMLINK cwmp3M_wpclsInitData(M_MMMP3 *somSelf)
{
  ULONG ulCp[4];
  ULONG ulInfoLen=0;

  M_MMMP3Data *somThis = M_MMMP3GetData(somSelf);
    M_MMMP3MethodDebug("M_MMMP3","cwmp3M_wpclsInitData");

    M_MMMP3_parent_M_MMAudio_wpclsInitData(somSelf);

    /* Get system codepage */
    if(DosQueryCp(sizeof(ulCp), ulCp,&ulInfoLen)!=NO_ERROR) {
      _ulCodePage=0;/* Indicate some error */
    }
    else 
      _ulCodePage=ulCp[0];

    /* Get ISO codepage */
    _ulIsoCodePage=_getISOCp();


#if 0
    pszMp3ColTitles[0]=chrTrackName;
    pszMp3ColTitles[1]=chrArtist;
    pszMp3ColTitles[2]=chrAlbum;
    pszMp3ColTitles[3]=chrYear;
    pszMp3ColTitles[4]=chrComment;
    pszMp3ColTitles[5]=chrGenre;

  /* Setup the static data for the details view */
  for(i=0,pCfi=cfiMp3FieldInfo;i<NUM_MP3_FIELDS;i++,pCfi++)
    {
      memset((PCH)pCfi,0,sizeof(CLASSFIELDINFO));

      pCfi->cb=sizeof(CLASSFIELDINFO);
      pCfi->flData=CFA_LEFT|CFA_SEPARATOR|CFA_FIREADONLY;
      pCfi->flTitle=CFA_CENTER|CFA_SEPARATOR|CFA_HORZSEPARATOR|CFA_STRING|CFA_FITITLEREADONLY;
      pCfi->pNextFieldInfo=pCfi+1;
       pCfi->pTitleData=(PVOID)pszMp3ColTitles[i];
      pCfi->flCompare=COMPARE_SUPPORTED|SORTBY_SUPPORTED;

      switch(i)
        {
        case 0:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszTrackName));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 1:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszArtist));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          //          WinMessageBox(HWND_DESKTOP, HWND_DESKTOP, pszMp3ColTitles[i], pCfi->pTitleData,1234, MB_MOVEABLE|MB_OK);
          break;
        case 2:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszAlbum));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 3: /* CC */
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszYear));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 4:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszComment));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        case 5:
          pCfi->flData|=CFA_STRING;
          pCfi->offFieldData=(ULONG)(FIELDOFFSETUL(MP3DETAILS,pszGenre));
          pCfi->ulLenFieldData=sizeof(PSZ);
          pCfi->DefaultComparison=CMP_EQUAL;
          break;
        }/* switch(i) */
    }/* for() */
  cfiMp3FieldInfo[NUM_MP3_FIELDS-1].pNextFieldInfo=NULL;
#endif

}

/*
 * The prototype for cwmp3M_wpclsQueryDefaultHelp was replaced by the following prototype:
 */
SOM_Scope BOOL  SOMLINK cwmp3M_wpclsQueryDefaultHelp(M_MMMP3 *somSelf, 
                                                     PULONG pHelpPanelId, 
                                                     PSZ pszHelpLibrary)
{
  PSZ pszHelpLibName;

    /* M_CWMP3Data *somThis = M_CWMP3GetData(somSelf); */
    M_MMMP3MethodDebug("M_MMMP3","cwmp3M_wpclsQueryDefaultHelp");

    if((pszHelpLibName=_queryMp3HelpLibraryName())!=NULLHANDLE)
      {
        if(pHelpPanelId)
          *pHelpPanelId=MP3FILE_HELP_PANEL;
        if(pszHelpLibrary)
          strncpy(pszHelpLibrary, pszHelpLibName, CCHMAXPATH);
        return TRUE; 
      }

    return (M_MMMP3_parent_M_MMAudio_wpclsQueryDefaultHelp(somSelf, 
                                                           pHelpPanelId, 
                                                           pszHelpLibrary));
}


