:userdoc.
:docprof.
:title.CWMM Help

.* ----------------------------------------------------------------------------
:h1 res=010.MP3 audio file
:p.This file is an MP3 audio file. It may be played using MMOS/2 when a suitable
MP3 MMIOProc has been installed.

:p.The MP3 format uses lossy compression to reduce the file size of the source
material. The amount of loss may or may not be acceptable. Usually, the amount
may be controlled by the encoding tool. Once encoded, however, it is not
possible to restore the bits which have been discarded. The source file must be
re-encoded again with a lower degree of loss.

:p.An MP3 MMIOProc package is included in the MMAudio Pak 2, available from&colon.

:p.http&colon.//r6.ca/MMAudioPak/

.* ----------------------------------------------------------------------------
:h1 res=011.ID3 tag
:p.Use this page to edit selected ID3 tag fields.

:p.An ID3 tag is metadata associated with a particular track, and is stored in
the MP3 file. ID3 is a :hp1.de facto:ehp1. standard, generally recognized by
most MP3 players.

:p.If all entry fields are empty, the file does not have an ID3 tag. If some
fields are empty, this data has not been added to the tag.

:p.The new information is only saved after pressing the :hp2.Save:ehp2. button.

:p.The following information may be specified:

:hp2.
:table rules=both frame=box cols='10 8 40'.
:row.
:c.Field
:c.Length
:c.Description
:row.
:c.Name
:c.30
:c.The name of the track.
:row.
:c.Artist
:c.30
:c.The name of the artist.
:row.
:c.Album
:c.30
:c.The album containing the track.
:row.
:c.Comment
:c.30
:c.An arbitrary comment about the track.
:row.
:c.Year
:c.4
:c.The 4-digit year in which the album was published.
:row.
:c.Genre
:c.30
:c.The genre of this track; select from dropdown.
:etable.
:ehp2.

.* ----------------------------------------------------------------------------
:h1 res=013.ID3 tag
:p.This page displays selected fields of the ID3 tag attached to the MP3 file.

:p.An ID3 tag is metadata associated with a particular track, and is stored in
the MP3 file. ID3 is a :hp1.de facto:ehp1. standard, generally recognized by
most MP3 players.

:p.If all entry fields are empty, the file does not have an ID3 tag. If some
fields are empty, this data has not been added to the tag.

:p.The new information is only saved after pressing the :hp2.Save:ehp2. button.

:p.The following information may be specified:

:hp2.
:table rules=both frame=box cols='10 8 40'.
:row.
:c.Field
:c.Length
:c.Description
:row.
:c.Name
:c.30
:c.The name of the track.
:row.
:c.Artist
:c.30
:c.The name of the artist.
:row.
:c.Album
:c.30
:c.The album containing the track.
:row.
:c.Comment
:c.30
:c.An arbitrary comment about the track.
:row.
:c.Year
:c.4
:c.The 4-digit year in which the album was published.
:row.
:c.Genre
:c.30
:c.The genre of this track; select from dropdown.
:etable.
:ehp2.

.* ----------------------------------------------------------------------------
:h1 res=012.Track meta data
:p.Use this page to edit track information. Unlike an ID3 tag, the contents of
these fields will be saved in the extended attributes of the file upon pressing
the :hp2.Save:ehp2. button.

:nt.
Extended attributes are only supported by OS/2 and other operating systems which
utilize these data structures in their filesystems (HPFS, JFS, XFS, ZFS, and to
a limited extent, ext4). Further, this information is not written to CD or DVD.
As a result, this data won't be saved or transferred along with its associated
files to any system which does not recognize extended attributes, resulting in
such copies lacking this data, even if it is present and intact in the source.
Use this feature with care.
:ent.

:p.The following information may be specified. The length of each field is
limited to 256 characters

:hp2.
:table rules=both frame=box cols='10 40'.
:row.
:c.Field
:c.Description
:row.
:c.Name
:c.The name of the track.
:row.
:c.Artist
:c.The name of the artist.
:row.
:c.Album
:c.The album containing the track.
:row.
:c.Comment
:c.An arbitrary comment about the track.
:row.
:c.Year
:c.The 4-digit year in which the album was published.
:row.
:c.Genre
:c.The genre of this track; select from dropdown.
:etable.
:ehp2.

.* ----------------------------------------------------------------------------
:h1 res=014.Audio details
:p.This page displays various technical details about the selected audio track.

:p.The following read-only information is provided&colon.

:hp2.
:table rules=both frame=box cols='20 40'.
:row.
:c.Detail
:c.Description
:row.
:c.Play time
:c.Recording length in mm&colon.ss.
:row.
:c.Sample rate
:c.For digital audio, this refers to the number of samples taken per second.
Generally, the higher the sample rate (sample frequency), the higher the quality
of the resulting audio stream.
:row.
:c.Bits per sample
:c.Bit depth of each sample. The greater the bit depth, the higher the quality of
the resulting audio stream. CD quality audio utilizes a 16-bit depth.
:row.
:c.Channels
:c.Number of audio channels in the file. Monaural audio contains a single
channel, stereo contains two, etc.
:etable.
:ehp2.

.* ----------------------------------------------------------------------------
:h1 res=020.Ogg audio file
:p.This file is an Ogg audio file. It may be played using MMOS/2 when a suitable
Ogg MMIOProc has been installed. Ogg is actually a container format, and may
consist of audio (Vorbis or Opus format for lossy compressed audio, or FLAC or
OggPCM for lossless compressed audio) or video (Theora format, which is lossy).

:p.The amount of loss in a Vorbis or Opus audio file may or may not be
acceptable. Usually, the amount may be controlled by the encoding tool. Once
encoded, however, it is not possible to restore the bits which have been
discarded without re-encoding the source file again with a lower degree of loss.

:p.Ogg MMIOProcs for FLAC and Vorbis are included with ArcaOS 5.x and above.
Alternatively, these MMIOProcs are available in the MMAudio Pak 2 for OS/2&colon.

:p.http&colon.//r6.ca/MMAudioPak/

.* ----------------------------------------------------------------------------
:h1 res=030.CD audio track
:p.This file is a CD audio track. The track name and other info is queried from
a CDDB server if an internet connection is available. The information presented
here is read-only.

:p.Most CDDB servers follow the FreeDB practice of requiring a valid email
address for access. Use the FreeDB Client configuration object in the Multimedia
folder to set this.

:p.The user information is stored in the cddb.ini file in the installation
directory.

.* ----------------------------------------------------------------------------
:h1 res=040.M3U playlist
:p.This file is an M3U (Moving Picture Experts Group Audio Layer 3 Uniform
Resource Locator) playlist. M3U is a :hp1.de facto:ehp1. standard, generally
recognized by most music players.

:p.An M3U playlist is a text file which contains paths (URLs) to the tracks it
references.

:p.To create a playlist, drag the M3U playlist template from the Multimedia
Templates folder to a suitable location on the desktop. Drag and drop media
files in the playlist container. To reorder, ensure that :hp1.Always maintain
sort order:ehp1. option on the :hp2.Sort:ehp2. submenu is deselected, as well
as any other sort options which might affect manual ordering, and drag and drop
the tracks as desired. Save the playlist by selecting :hp2.File | Save:ehp2.
from the menu.

.* ----------------------------------------------------------------------------
:h1 res=050.Audio stream
:p.This object points to a stream provided by a streaming server on the LAN or
across the internet. The URL for the server is specified in the properties
notebook for the stream.

:nt.
Only Icecast servers are supported. Servers using other protocols (Ampache,
SHOUTcast, QuickTime Broadcaster, Open Broadcast System, etc.) will not work.
:ent.

.* ----------------------------------------------------------------------------
:h1 res=060.Convert audio file
:p.Specify the target audio file type and filename, including the full path.
Source audio file details are displayed at the top of the dialog. Note that some
formats may be more lossy than others, and converting from a lossy format to a
less-lossy (or lossless) format will not restore original bits which may no
longer be present in the (lossy) source file, and in some cases, may result in
a converted file of lower quality than the lossy source.

:p.The dropdown will list available MMIOProcs (codecs) for the target file.

:p.Press the :hp2.Convert:ehp2. button to begin the process, and
:hp2.Abort:ehp2. to cancel once conversion has begun. Press :hp2.Close:ehp2. to
exit the dialog.


.* ----------------------------------------------------------------------------
:h1 res=200.Image details
:p.This page displays various technical details about the selected image.

:p.The following read-only information is provided&colon.

:hp2.
:table rules=both frame=box cols='20 40'.
:row.
:c.Detail
:c.Description
:row.
:c.IOProc
:c.Identifies which MMIOProc is being used to render the image.
:row.
:c.Width
:c.Width in pixels of the image.
:row.
:c.Height
:c.Height in pixels of the image.
:row.
:c.Depth
:c.Number of colors (color depth) of the image.
:etable.
:ehp2.

.* ----------------------------------------------------------------------------
:h1 res=210.Convert digital image
:p.Specify the target image file type and filename, including the full path.
A thumbnail of the source image file is displayed at the top of the dialog. Note
that some formats may be more lossy than others, and converting from a lossy
format to a less-lossy (or lossless) format will not restore original bits which
may no longer be present in the (lossy) source file, and in some cases, may
result in a converted file of lower quality than the lossy source.

:p.The dropdown will list available MMIOProcs (codecs) for the target file.

:p.Press the :hp2.Convert:ehp2. button to begin the process, and
:hp2.Abort:ehp2. to cancel once conversion has begun. Press :hp2.Close:ehp2. to
exit the dialog.

:euserdoc.