/******************************************************************************
 * atapi.c - ATAPI command processing
 *
 * Copyright (c) 2010 Christian Mueller, Markus Thielen. 
 * Parts copied from/inspired by the Linux AHCI driver; 
 * those parts are (c) Linux AHCI/ATA maintainers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "os2ahci.h"
#include "ata.h"

/* -------------------------- macros and constants ------------------------- */

/* ------------------------ typedefs and structures ------------------------ */

/* -------------------------- function prototypes -------------------------- */

/* ------------------------ global/static variables ------------------------ */

/* ----------------------------- start of code ----------------------------- */

/******************************************************************************
 * Get device or media geometry. This function is expected to check the IORB
 * command codes and modifiers to see which one is requested.
 */
int atapi_get_geometry(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}

/******************************************************************************
 * Test whether unit is ready.
 */
int atapi_unit_ready(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}

/******************************************************************************
 * Read sectors from AHCI device.
 */
int atapi_read(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}  

/******************************************************************************
 * Verify readability of sectors on AHCI device.
 */
int atapi_verify(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}

/******************************************************************************
 * Write sectors to AHCI device.
 */
int atapi_write(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}

/******************************************************************************
 * Execute ATAPI command.
 */
int atapi_execute_cdb(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}

/******************************************************************************
 * Request sense information for a failed command.
 *
 * NOTE: This function must be called right after an ATAPI command has failed
 *       and before any other commands are queued on the corresponding device.
 *       This function is typically called in the port restart context hook
 *       which is triggered by an AHCI error interrupt.
 *
 */
int atapi_req_sense(IORBH _far *iorb, int slot)
{
  iorb_seterr(iorb, IOERR_CMD_NOT_SUPPORTED);
  return(-1);
}

