/**
 *
 * Copyright (c) 2013-2023 David Azarewicz <david@88watts.net>
 *
 */

#define INCL_LONGLONG
#include "os2ahci.h"

/**
 * Create adapter/port/device list for user output.
 */
void build_user_info(void)
{
  int a;
  int p;
  int d;
  int iFlag;

  for (a = 0; a < ad_info_cnt; a++)
  {
    AD_INFO *ai = ad_infos + a;

    dprintf(0,"Adapter %d: %d:%d:%d ID=%04x:%04x %s %s irq=%d adr=%x version=%x\n", a,
      PCI_BUS_FROM_BDF(ai->BusDevFunc), PCI_DEV_FROM_BDF(ai->BusDevFunc),
      PCI_FUNC_FROM_BDF(ai->BusDevFunc),
      ai->PciVendor, ai->PciDevice, vendor_from_id(ai->PciVendor), ai->pChipName,
      ai->irq, ai->mmio_phys,
      ai->bios_config[HOST_VERSION / sizeof(u32)]);

    for (p = 0; p <= ai->port_max; p++)
    {
      P_INFO *pi = &ai->ports[p];
      iFlag = 1;

      for (d = 0; d <= pi->dev_max; d++)
      {
        if (pi->devs[d].present)
        {
          if (iFlag) dprintf(0,"  Port %d:", p);
          iFlag = 0;
          if (pi->devs[d].atapi) dprintf(0," atapi");
          if (pi->devs[d].removable) dprintf(0," removable");
          if (pi->devs[d].dev_info.pMethod != NULL)
          {
            dprintf(0," %d cylinders, %d heads, %d sectors per track (%dMB) (%s)",
              pi->devs[d].dev_info.ulCylinders, pi->devs[d].dev_info.usHeadsPerCylinder,
              pi->devs[d].dev_info.usSectorsPerTrack,
              (ULONG)(pi->devs[d].dev_info.ullTotalSectors/2048), pi->devs[d].dev_info.pMethod);
          }
          if (pi->devs[d].ignored) dprintf(0," Unusable");
          dprintf(0,"\n");
          dprintf(0,"          Model: %s\n", pi->devs[d].dev_name);
        }
        else if (iVerbose > 0)
        {
          if (iFlag) dprintf(0,"  Port %d: No drive present\n", p);
        } /* if */
      } /* for d */
    } /* for p */
  } /* for a */
}

#ifdef DEBUG
void DumpIorb(IORBH *pIorb, IORBH FAR16DATA *vIorb)
{
  //if (!(D32g_DbgLevel & DBG_DETAILED)) return;
  if (ad_infos[iorb_unit_adapter(pIorb)].ports[iorb_unit_port(pIorb)].devs[iorb_unit_device(pIorb)].atapi) return;

  dprintf(0,"IORB %x: Size=%x Len=%x Handle=%x CmdCode=%x\n",
      vIorb, sizeof(IORBH), pIorb->Length, pIorb->UnitHandle, pIorb->CommandCode);
  dprintf(0,"  CmdMod=%x ReqCtrl=%x Status=%x ErrorCode=%x\n",
      pIorb->CommandModifier, pIorb->RequestControl, pIorb->Status, pIorb->ErrorCode);
  dprintf(0,"  Timeout=%x StatusBlkLen=%x pStatusBlk=%x Res=%x f16NxtIORB=%x\n",
      pIorb->Timeout, pIorb->StatusBlockLen, pIorb->pStatusBlock, pIorb->Reserved_1,
      pIorb->f16NxtIORB);

  if (pIorb->CommandCode == IOCC_EXECUTE_IO || pIorb->CommandCode == IOCC_EXECUTE_IO_64)
  {
    IORB_EXECUTEIO64 *pIo = (IORB_EXECUTEIO64*)pIorb;
    ULONGLONG ullLba;

    ullLba = pIo->RBA;
    if (pIorb->CommandCode == IOCC_EXECUTE_IO_64) ullLba = pIo->ullRBA;

    dprintf(0,"  I/O: Block=%llx Count=%x Xferred=%x Size=%x Flags=%x\n",
      ullLba, pIo->BlockCount, pIo->BlocksXferred, pIo->BlockSize, pIo->Flags);
  }
}
#endif

