/******************************************************************************
 *
 * Copyright (c) 2013-2016 David Azarewicz
 *
 */

#include "os2ahci.h"

/* -------------------------- macros and constants ------------------------- */

/* ------------------------ typedefs and structures ------------------------ */

/* -------------------------- function prototypes -------------------------- */

/* ------------------------ global/static variables ------------------------ */

/* ----------------------------- start of code ----------------------------- */

/******************************************************************************
 * Create adapter/port/device list for user output.
 */
void build_user_info(void)
{
  int a;
  int p;
  int d;

  for (a = 0; a < ad_info_cnt; a++)
  {
    AD_INFO *ai = ad_infos + a;

    dprintf(0,"Adapter %d: PCI=%d:%d:%d ID=%04x:%04x %s %s irq=%d addr=0x%x version=%x\n", a,
      PCI_BUS_FROM_BDF(ai->bus_dev_func), PCI_DEV_FROM_BDF(ai->bus_dev_func),
      PCI_FUNC_FROM_BDF(ai->bus_dev_func),
      ai->pci_vendor, ai->pci_device, vendor_from_id(ai->pci_vendor), ai->pci->chipname,
      ai->irq, ai->mmio_phys,
      ai->bios_config[HOST_VERSION / sizeof(u32)]);

    for (p = 0; p <= ai->port_max; p++)
    {
      P_INFO *pi = &ai->ports[p];

      dprintf(0,"  Port %d:\n", p);

      for (d = 0; d <= pi->dev_max; d++)
      {
        if (!pi->devs[d].present)
        {
          dprintf(0,"    No drive present\n");
        } else {
          dprintf(0,"    Drive %d:", d);
          if (pi->devs[d].atapi) dprintf(0," atapi");
          if (pi->devs[d].removable) dprintf(0," removable");
          if (pi->devs[d].dev_info.Method != NULL)
          {
            dprintf(0," %d cylinders, %d heads, %d sectors per track (%dMB) (%s)",
              pi->devs[d].dev_info.Cylinders, pi->devs[d].dev_info.HeadsPerCylinder, pi->devs[d].dev_info.SectorsPerTrack,
              pi->devs[d].dev_info.TotalSectors/2048, pi->devs[d].dev_info.Method);
          }
          dprintf(0,"\n");
          dprintf(0,"             Model: %s\n", pi->devs[d].dev_name);
        } /* if */
      } /* for d */
    } /* for p */
  } /* for a */
}

#ifdef DEBUG
void DumpIorb(IORBH *pIorb)
{
  DPRINTF(2,"IORB %x: Size=%x Len=%x Handle=%x CmdCode=%x\n",
      pIorb, sizeof(IORBH), pIorb->Length, pIorb->UnitHandle, pIorb->CommandCode);
  DPRINTF(2,"  CmdMod=%x ReqCtrl=%x Status=%x ErrorCode=%x\n",
      pIorb->CommandModifier, pIorb->RequestControl, pIorb->Status, pIorb->ErrorCode);
  DPRINTF(2,"  Timeout=%x StatusBlkLen=%x pStatusBlk=%x Res=%x pNxtIORB=%x\n",
      pIorb->Timeout, pIorb->StatusBlockLen, pIorb->pStatusBlock, pIorb->Reserved_1,
      pIorb->pNxtIORB);
}
#endif

