/******************************************************************************
 * trace.c - code for our internal trace ring buffer
 *
 * Copyright (c) 2011 thi.guten Software Development
 * Copyright (c) 2011 Mensys B.V.
 * Copyright (c) 2013-2016 David Azarewicz
 *
 * Authors: Christian Mueller, Markus Thielen
 *
 * Parts copied from/inspired by the Linux AHCI driver;
 * those parts are (c) Linux AHCI/ATA maintainers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "os2ahci.h"

/* -------------------------- macros and constants ------------------------- */

/* ------------------------ typedefs and structures ------------------------ */

/* -------------------------- function prototypes -------------------------- */

/* ------------------------ global/static variables ------------------------ */

/* ----------------------------- start of code ----------------------------- */

/******************************************************************************
 * Create adapter/port/device list for user output.
 */
void build_user_info(void)
{
  int a;
  int p;
  int d;

  for (a = 0; a < ad_info_cnt; a++)
  {
    AD_INFO *ai = ad_infos + a;

    NTPRINTF("Adapter %d: PCI=%d:%d:%d ID=%04x:%04x %s %s irq=%d addr=0x%x version=%x\n", a,
      PCI_BUS_FROM_BDF(ai->bus_dev_func), PCI_DEV_FROM_BDF(ai->bus_dev_func),
      PCI_FUNC_FROM_BDF(ai->bus_dev_func),
      ai->pci_vendor, ai->pci_device, vendor_from_id(ai->pci_vendor), ai->pci->chipname,
      ai->irq, ai->mmio_phys,
      ai->bios_config[HOST_VERSION / sizeof(u32)]);

    for (p = 0; p < ai->hw_ports; p++)
    {
      P_INFO *pi = &ai->ports[p];

      NTPRINTF("  Port %d:\n", p);

      for (d = 0; d <= pi->dev_max; d++)
      {
        if (!pi->devs[d].present)
        {
          NTPRINTF("    No drive present\n");
        } else {
          NTPRINTF("    Drive %d:", d);
          if (pi->devs[d].atapi) NTPRINTF(" atapi");
          if (pi->devs[d].removable) NTPRINTF(" removable");
          if (pi->devs[d].dev_info.Method != NULL)
          {
            NTPRINTF(" %d cylinders, %d heads, %d sectors per track (%dMB) (%s)",
              pi->devs[d].dev_info.Cylinders, pi->devs[d].dev_info.HeadsPerCylinder, pi->devs[d].dev_info.SectorsPerTrack,
              pi->devs[d].dev_info.TotalSectors/2048, pi->devs[d].dev_info.Method);
          } else NTPRINTF(" Drive present but no information available.");
          NTPRINTF("\n");
        } /* if */
      } /* for d */
    } /* for p */
  } /* for a */
}

#ifdef DEBUG
void DumpIorb(IORBH *pIorb)
{
  DPRINTF(2,"IORB %x: Size=%x Len=%x Handle=%x CmdCode=%x\n",
      pIorb, sizeof(IORBH), pIorb->Length, pIorb->UnitHandle, pIorb->CommandCode);
  DPRINTF(2,"  CmdMod=%x ReqCtrl=%x Status=%x ErrorCode=%x\n",
      pIorb->CommandModifier, pIorb->RequestControl, pIorb->Status, pIorb->ErrorCode);
  DPRINTF(2,"  Timeout=%x StatusBlkLen=%x pStatusBlk=%x Res=%x pNxtIORB=%x\n",
      pIorb->Timeout, pIorb->StatusBlockLen, pIorb->pStatusBlock, pIorb->Reserved_1,
      pIorb->pNxtIORB);
}
#endif

