using System;
using System.Xml;

namespace blowery.Web.HttpModules {
  /// <summary>
  /// Summary description for HttpCompressionModuleSettings.
  /// </summary>
  internal class HttpCompressionModuleSettings {
    
    private HttpCompressionModuleSettings() {
      XmlNode node = BaseConfiguration.GetBaseConfiguration().GetSection("compressionModule");
      
      if(node == null) {
        _preferredAlgorithm = CompressionTypes.Unspecified;
        _compressionLevel = CompressionLevels.Unspecified;
        return;
      }

      XmlAttribute preferredAlgorithm = node.Attributes["preferredAlgorithm"];
      if(preferredAlgorithm != null) {
        switch(preferredAlgorithm.Value.ToLower()) {
          case "gzip":
            _preferredAlgorithm = CompressionTypes.GZip;
            break;
          case "deflate":
            _preferredAlgorithm = CompressionTypes.Deflate;
            break;
          default:
            _preferredAlgorithm = CompressionTypes.Unspecified;
            break;
        }
      } else {
        _preferredAlgorithm = CompressionTypes.Unspecified;
      }

      XmlAttribute compressionLevel = node.Attributes["compressionLevel"];
      if(compressionLevel != null) {
        switch(compressionLevel.Value.ToLower()) {
          case "high":
            _compressionLevel = CompressionLevels.High;
            break;
          case "low":
            _compressionLevel = CompressionLevels.Low;
            break;
          case "normal":
            _compressionLevel = CompressionLevels.Normal;
            break;
          default:
            _compressionLevel = CompressionLevels.Unspecified;
            break;
        }
      }else {
        _compressionLevel = CompressionLevels.Unspecified;
      }
    }


    private static HttpCompressionModuleSettings _settings = null;
    public static HttpCompressionModuleSettings GetSettings() {
      if(_settings == null) {
        _settings = new HttpCompressionModuleSettings();
      }
      return _settings;
    }

    public CompressionTypes PreferredAlgorithm {
      get { return _preferredAlgorithm; }
    }
    private CompressionTypes _preferredAlgorithm;

    public CompressionLevels CompressionLevel {
      get { return _compressionLevel; }
    }
    private CompressionLevels _compressionLevel;

    
  }

  /// <summary>
  /// The available types of compression to use with the HttpCompressionModule
  /// </summary>
  public enum CompressionTypes {
    /// <summary>
    /// Use the deflate algorithm
    /// </summary>
    Deflate,
    /// <summary>
    /// Use the gzip algorithm
    /// </summary>
    GZip,
    /// <summary>
    /// The algorithm was not specified in the configuration file
    /// </summary>
    Unspecified
  }

  /// <summary>
  /// The level of compression to use with some algorithms
  /// </summary>
  public enum CompressionLevels {
    /// <summary>
    /// Use a normal level of compression.  Compromises between speed and size
    /// </summary>
    Normal,
    /// <summary>
    /// Use a high level of compression.  Sacrifices speed for size.
    /// </summary>
    High,
    /// <summary>
    /// Use a low level of compression.  Sacrifices size for speed.
    /// </summary>
    Low,
    /// <summary>
    /// The level of compression was not specified in the configuration file.
    /// </summary>
    Unspecified
  }

}

