using System;
using System.Xml;

namespace blowery.Web.HttpModules
{
  /// <summary>
  /// This represents the base configuration for FactSet.Web.HttpModules.  This will be pulled from
  /// factset.web/httpModules.
  /// </summary>
  public class BaseConfiguration {
    
    static BaseConfiguration _baseConfig = null;

    /// <summary>
    /// Get an instance of the BaseConfiguration
    /// </summary>
    /// <returns>The BaseConfiguration for FactSet.Web.HttpModules</returns>
    public static BaseConfiguration GetBaseConfiguration() {
          
      if(_baseConfig == null) {
        _baseConfig = new BaseConfiguration((XmlNode)System.Configuration.ConfigurationSettings.GetConfig("blowery.web/httpModules"));
      }
      return _baseConfig;
    }


    private XmlNode _baseXmlNode;
    
    private BaseConfiguration(XmlNode configSection) {
      _baseXmlNode = configSection;
    }

    /// <summary>
    /// Get a config section from within factset.web/httpModules
    /// </summary>
    /// <param name="nameOfSection">the name of the section to pull</param>
    /// <returns>An XmlNode representing the config section.</returns>
    public XmlNode GetSection(string nameOfSection) {
      if(_baseXmlNode != null)
        return _baseXmlNode.SelectSingleNode(nameOfSection);
      else
        return null;
    }
    
  }
}
