<?php
/*
Plugin Name: Google Adsense widget
Description: Like the Text widget, but specifically for Google Adsense blocks. Up to 4 instances of this widget may exist (since Google only allows 3 ads and one link block on a page). Heavily derived from the Text widget code included with the widget plugin by Automattic, Inc.
Author: Otto
Version: 1.0
Author URI: http://ottodestruct.com
*/

function widget_adsense_init()
{
	// Check for the required API functions
	if ( !function_exists('register_sidebar_widget') || !function_exists('register_widget_control') )
		return;

	function widget_adsense($args, $number = 1) {
		extract($args);
		$options = get_option('widget_adsense');
		$title = $options[$number]['title'];
		$text = $options[$number]['text'];
	?>
			<?php echo $before_widget; ?>
				<?php $title ? print($before_title . $title . $after_title) : null; ?>
				<div class="adsensewidget"><?php echo $text; ?></div>
			<?php echo $after_widget; ?>
	<?php
	}
	
	function widget_adsense_control($number) {
		$options = $newoptions = get_option('widget_adsense');
		if ( $_POST["adsense-submit-$number"] ) {
			$newoptions[$number]['title'] = strip_tags(stripslashes($_POST["adsense-title-$number"]));
			$newoptions[$number]['text'] = stripslashes($_POST["adsense-text-$number"]);
			if ( !current_user_can('unfiltered_html') )
				$newoptions[$number]['text'] = stripslashes(wp_filter_post_kses($newoptions[$number]['text']));
		}
		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option('widget_adsense', $options);
		}
		$title = htmlspecialchars($options[$number]['title'], ENT_QUOTES);
		$text = htmlspecialchars($options[$number]['text'], ENT_QUOTES);
	?>
				<input style="width: 450px;" id="adsense-title-<?php echo "$number"; ?>" name="adsense-title-<?php echo "$number"; ?>" type="text" value="<?php echo $title; ?>" />
				<p>Insert Google AdSense Code here:</p>
				<textarea style="width: 450px; height: 230px;" id="adsense-text-<?php echo "$number"; ?>" name="adsense-text-<?php echo "$number"; ?>"><?php echo $text; ?></textarea>
				<input type="hidden" id="adsense-submit-<?php echo "$number"; ?>" name="adsense-submit-<?php echo "$number"; ?>" value="1" />
	<?php
	}
	
	function widget_adsense_setup() {
		$options = $newoptions = get_option('widget_adsense');
		if ( isset($_POST['adsense-number-submit']) ) {
			$number = (int) $_POST['adsense-number'];
			if ( $number > 4 ) $number = 4;
			if ( $number < 1 ) $number = 1;
			$newoptions['number'] = $number;
		}
		if ( $options != $newoptions ) {
			$options = $newoptions;
			update_option('widget_adsense', $options);
			widget_adsense_register($options['number']);
		}
	}
	
	function widget_adsense_page() {
		$options = $newoptions = get_option('widget_adsense');
	?>
		<div class="wrap">
			<form method="POST">
				<h2>Google AdSense Widgets</h2>
				<p style="line-height: 30px;"><?php _e('How many Google AdSense widgets would you like?'); ?>
				<select id="adsense-number" name="adsense-number" value="<?php echo $options['number']; ?>">
	<?php for ( $i = 1; $i < 5; ++$i ) echo "<option value='$i' ".($options['number']==$i ? "selected='selected'" : '').">$i</option>"; ?>
				</select>
				<span class="submit"><input type="submit" name="adsense-number-submit" id="adsense-number-submit" value="<?php _e('Save'); ?>" /></span></p>
			</form>
		</div>
	<?php
	}
	
	function widget_adsense_register() {
		$options = get_option('widget_adsense');
		$number = $options['number'];
		if ( $number < 1 ) $number = 1;
		if ( $number > 4 ) $number = 4;
		for ($i = 1; $i <= 4; $i++) {
			$name = array('Google AdSense %s', null, $i);
			register_sidebar_widget($name, $i <= $number ? 'widget_adsense' : /* unregister */ '', $i);
			register_widget_control($name, $i <= $number ? 'widget_adsense_control' : /* unregister */ '', 460, 350, $i);
		}
		add_action('sidebar_admin_setup', 'widget_adsense_setup');
		add_action('sidebar_admin_page', 'widget_adsense_page');
	}
	// Delay plugin execution to ensure Dynamic Sidebar has a chance to load first
	widget_adsense_register();
}

	
// Tell Dynamic Sidebar about our new widget and its control
add_action('plugins_loaded', 'widget_adsense_init');

?>